/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;
/**
 * UpdateEmployeeApiModelEmployment - The employee employment
 */

public class UpdateEmployeeApiModelEmployment {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * The job title of the employee
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("job_title")
    private JsonNullable<String> jobTitle;

    /**
     * The pay rate for the employee
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pay_rate")
    private JsonNullable<String> payRate;

    /**
     * The pay period
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pay_period")
    private JsonNullable<? extends UpdateEmployeeApiModelPayPeriod> payPeriod;

    /**
     * The pay frequency
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pay_frequency")
    private JsonNullable<? extends UpdateEmployeeApiModelPayFrequency> payFrequency;

    /**
     * The currency used for pay
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pay_currency")
    private JsonNullable<String> payCurrency;

    /**
     * The effective date of the employment contract
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("effective_date")
    @Deprecated
    private JsonNullable<OffsetDateTime> effectiveDate;

    /**
     * The type of employment (e.g., contractor, permanent)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employment_type")
    private JsonNullable<? extends UpdateEmployeeApiModelEmploymentEmploymentType> employmentType;

    /**
     * The employment work schedule type (e.g., full-time, part-time)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employment_contract_type")
    private JsonNullable<? extends UpdateEmployeeApiModelEmploymentEmploymentContractType> employmentContractType;

    /**
     * The time worked for the employee in ISO 8601 duration format
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("time_worked")
    private JsonNullable<String> timeWorked;

    @JsonCreator
    public UpdateEmployeeApiModelEmployment(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("job_title") JsonNullable<String> jobTitle,
            @JsonProperty("pay_rate") JsonNullable<String> payRate,
            @JsonProperty("pay_period") JsonNullable<? extends UpdateEmployeeApiModelPayPeriod> payPeriod,
            @JsonProperty("pay_frequency") JsonNullable<? extends UpdateEmployeeApiModelPayFrequency> payFrequency,
            @JsonProperty("pay_currency") JsonNullable<String> payCurrency,
            @JsonProperty("effective_date") JsonNullable<OffsetDateTime> effectiveDate,
            @JsonProperty("employment_type") JsonNullable<? extends UpdateEmployeeApiModelEmploymentEmploymentType> employmentType,
            @JsonProperty("employment_contract_type") JsonNullable<? extends UpdateEmployeeApiModelEmploymentEmploymentContractType> employmentContractType,
            @JsonProperty("time_worked") JsonNullable<String> timeWorked) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(jobTitle, "jobTitle");
        Utils.checkNotNull(payRate, "payRate");
        Utils.checkNotNull(payPeriod, "payPeriod");
        Utils.checkNotNull(payFrequency, "payFrequency");
        Utils.checkNotNull(payCurrency, "payCurrency");
        Utils.checkNotNull(effectiveDate, "effectiveDate");
        Utils.checkNotNull(employmentType, "employmentType");
        Utils.checkNotNull(employmentContractType, "employmentContractType");
        Utils.checkNotNull(timeWorked, "timeWorked");
        this.id = id;
        this.unifiedCustomFields = unifiedCustomFields;
        this.jobTitle = jobTitle;
        this.payRate = payRate;
        this.payPeriod = payPeriod;
        this.payFrequency = payFrequency;
        this.payCurrency = payCurrency;
        this.effectiveDate = effectiveDate;
        this.employmentType = employmentType;
        this.employmentContractType = employmentContractType;
        this.timeWorked = timeWorked;
    }
    
    public UpdateEmployeeApiModelEmployment() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * The job title of the employee
     */
    @JsonIgnore
    public JsonNullable<String> jobTitle() {
        return jobTitle;
    }

    /**
     * The pay rate for the employee
     */
    @JsonIgnore
    public JsonNullable<String> payRate() {
        return payRate;
    }

    /**
     * The pay period
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<UpdateEmployeeApiModelPayPeriod> payPeriod() {
        return (JsonNullable<UpdateEmployeeApiModelPayPeriod>) payPeriod;
    }

    /**
     * The pay frequency
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<UpdateEmployeeApiModelPayFrequency> payFrequency() {
        return (JsonNullable<UpdateEmployeeApiModelPayFrequency>) payFrequency;
    }

    /**
     * The currency used for pay
     */
    @JsonIgnore
    public JsonNullable<String> payCurrency() {
        return payCurrency;
    }

    /**
     * The effective date of the employment contract
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<OffsetDateTime> effectiveDate() {
        return effectiveDate;
    }

    /**
     * The type of employment (e.g., contractor, permanent)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<UpdateEmployeeApiModelEmploymentEmploymentType> employmentType() {
        return (JsonNullable<UpdateEmployeeApiModelEmploymentEmploymentType>) employmentType;
    }

    /**
     * The employment work schedule type (e.g., full-time, part-time)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<UpdateEmployeeApiModelEmploymentEmploymentContractType> employmentContractType() {
        return (JsonNullable<UpdateEmployeeApiModelEmploymentEmploymentContractType>) employmentContractType;
    }

    /**
     * The time worked for the employee in ISO 8601 duration format
     */
    @JsonIgnore
    public JsonNullable<String> timeWorked() {
        return timeWorked;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier
     */
    public UpdateEmployeeApiModelEmployment withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public UpdateEmployeeApiModelEmployment withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public UpdateEmployeeApiModelEmployment withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public UpdateEmployeeApiModelEmployment withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * The job title of the employee
     */
    public UpdateEmployeeApiModelEmployment withJobTitle(String jobTitle) {
        Utils.checkNotNull(jobTitle, "jobTitle");
        this.jobTitle = JsonNullable.of(jobTitle);
        return this;
    }

    /**
     * The job title of the employee
     */
    public UpdateEmployeeApiModelEmployment withJobTitle(JsonNullable<String> jobTitle) {
        Utils.checkNotNull(jobTitle, "jobTitle");
        this.jobTitle = jobTitle;
        return this;
    }

    /**
     * The pay rate for the employee
     */
    public UpdateEmployeeApiModelEmployment withPayRate(String payRate) {
        Utils.checkNotNull(payRate, "payRate");
        this.payRate = JsonNullable.of(payRate);
        return this;
    }

    /**
     * The pay rate for the employee
     */
    public UpdateEmployeeApiModelEmployment withPayRate(JsonNullable<String> payRate) {
        Utils.checkNotNull(payRate, "payRate");
        this.payRate = payRate;
        return this;
    }

    /**
     * The pay period
     */
    public UpdateEmployeeApiModelEmployment withPayPeriod(UpdateEmployeeApiModelPayPeriod payPeriod) {
        Utils.checkNotNull(payPeriod, "payPeriod");
        this.payPeriod = JsonNullable.of(payPeriod);
        return this;
    }

    /**
     * The pay period
     */
    public UpdateEmployeeApiModelEmployment withPayPeriod(JsonNullable<? extends UpdateEmployeeApiModelPayPeriod> payPeriod) {
        Utils.checkNotNull(payPeriod, "payPeriod");
        this.payPeriod = payPeriod;
        return this;
    }

    /**
     * The pay frequency
     */
    public UpdateEmployeeApiModelEmployment withPayFrequency(UpdateEmployeeApiModelPayFrequency payFrequency) {
        Utils.checkNotNull(payFrequency, "payFrequency");
        this.payFrequency = JsonNullable.of(payFrequency);
        return this;
    }

    /**
     * The pay frequency
     */
    public UpdateEmployeeApiModelEmployment withPayFrequency(JsonNullable<? extends UpdateEmployeeApiModelPayFrequency> payFrequency) {
        Utils.checkNotNull(payFrequency, "payFrequency");
        this.payFrequency = payFrequency;
        return this;
    }

    /**
     * The currency used for pay
     */
    public UpdateEmployeeApiModelEmployment withPayCurrency(String payCurrency) {
        Utils.checkNotNull(payCurrency, "payCurrency");
        this.payCurrency = JsonNullable.of(payCurrency);
        return this;
    }

    /**
     * The currency used for pay
     */
    public UpdateEmployeeApiModelEmployment withPayCurrency(JsonNullable<String> payCurrency) {
        Utils.checkNotNull(payCurrency, "payCurrency");
        this.payCurrency = payCurrency;
        return this;
    }

    /**
     * The effective date of the employment contract
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public UpdateEmployeeApiModelEmployment withEffectiveDate(OffsetDateTime effectiveDate) {
        Utils.checkNotNull(effectiveDate, "effectiveDate");
        this.effectiveDate = JsonNullable.of(effectiveDate);
        return this;
    }

    /**
     * The effective date of the employment contract
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public UpdateEmployeeApiModelEmployment withEffectiveDate(JsonNullable<OffsetDateTime> effectiveDate) {
        Utils.checkNotNull(effectiveDate, "effectiveDate");
        this.effectiveDate = effectiveDate;
        return this;
    }

    /**
     * The type of employment (e.g., contractor, permanent)
     */
    public UpdateEmployeeApiModelEmployment withEmploymentType(UpdateEmployeeApiModelEmploymentEmploymentType employmentType) {
        Utils.checkNotNull(employmentType, "employmentType");
        this.employmentType = JsonNullable.of(employmentType);
        return this;
    }

    /**
     * The type of employment (e.g., contractor, permanent)
     */
    public UpdateEmployeeApiModelEmployment withEmploymentType(JsonNullable<? extends UpdateEmployeeApiModelEmploymentEmploymentType> employmentType) {
        Utils.checkNotNull(employmentType, "employmentType");
        this.employmentType = employmentType;
        return this;
    }

    /**
     * The employment work schedule type (e.g., full-time, part-time)
     */
    public UpdateEmployeeApiModelEmployment withEmploymentContractType(UpdateEmployeeApiModelEmploymentEmploymentContractType employmentContractType) {
        Utils.checkNotNull(employmentContractType, "employmentContractType");
        this.employmentContractType = JsonNullable.of(employmentContractType);
        return this;
    }

    /**
     * The employment work schedule type (e.g., full-time, part-time)
     */
    public UpdateEmployeeApiModelEmployment withEmploymentContractType(JsonNullable<? extends UpdateEmployeeApiModelEmploymentEmploymentContractType> employmentContractType) {
        Utils.checkNotNull(employmentContractType, "employmentContractType");
        this.employmentContractType = employmentContractType;
        return this;
    }

    /**
     * The time worked for the employee in ISO 8601 duration format
     */
    public UpdateEmployeeApiModelEmployment withTimeWorked(String timeWorked) {
        Utils.checkNotNull(timeWorked, "timeWorked");
        this.timeWorked = JsonNullable.of(timeWorked);
        return this;
    }

    /**
     * The time worked for the employee in ISO 8601 duration format
     */
    public UpdateEmployeeApiModelEmployment withTimeWorked(JsonNullable<String> timeWorked) {
        Utils.checkNotNull(timeWorked, "timeWorked");
        this.timeWorked = timeWorked;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateEmployeeApiModelEmployment other = (UpdateEmployeeApiModelEmployment) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Objects.deepEquals(this.jobTitle, other.jobTitle) &&
            Objects.deepEquals(this.payRate, other.payRate) &&
            Objects.deepEquals(this.payPeriod, other.payPeriod) &&
            Objects.deepEquals(this.payFrequency, other.payFrequency) &&
            Objects.deepEquals(this.payCurrency, other.payCurrency) &&
            Objects.deepEquals(this.effectiveDate, other.effectiveDate) &&
            Objects.deepEquals(this.employmentType, other.employmentType) &&
            Objects.deepEquals(this.employmentContractType, other.employmentContractType) &&
            Objects.deepEquals(this.timeWorked, other.timeWorked);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            unifiedCustomFields,
            jobTitle,
            payRate,
            payPeriod,
            payFrequency,
            payCurrency,
            effectiveDate,
            employmentType,
            employmentContractType,
            timeWorked);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateEmployeeApiModelEmployment.class,
                "id", id,
                "unifiedCustomFields", unifiedCustomFields,
                "jobTitle", jobTitle,
                "payRate", payRate,
                "payPeriod", payPeriod,
                "payFrequency", payFrequency,
                "payCurrency", payCurrency,
                "effectiveDate", effectiveDate,
                "employmentType", employmentType,
                "employmentContractType", employmentContractType,
                "timeWorked", timeWorked);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
 
        private JsonNullable<String> jobTitle = JsonNullable.undefined();
 
        private JsonNullable<String> payRate = JsonNullable.undefined();
 
        private JsonNullable<? extends UpdateEmployeeApiModelPayPeriod> payPeriod = JsonNullable.undefined();
 
        private JsonNullable<? extends UpdateEmployeeApiModelPayFrequency> payFrequency = JsonNullable.undefined();
 
        private JsonNullable<String> payCurrency = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<OffsetDateTime> effectiveDate = JsonNullable.undefined();
 
        private JsonNullable<? extends UpdateEmployeeApiModelEmploymentEmploymentType> employmentType = JsonNullable.undefined();
 
        private JsonNullable<? extends UpdateEmployeeApiModelEmploymentEmploymentContractType> employmentContractType = JsonNullable.undefined();
 
        private JsonNullable<String> timeWorked = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        /**
         * The job title of the employee
         */
        public Builder jobTitle(String jobTitle) {
            Utils.checkNotNull(jobTitle, "jobTitle");
            this.jobTitle = JsonNullable.of(jobTitle);
            return this;
        }

        /**
         * The job title of the employee
         */
        public Builder jobTitle(JsonNullable<String> jobTitle) {
            Utils.checkNotNull(jobTitle, "jobTitle");
            this.jobTitle = jobTitle;
            return this;
        }

        /**
         * The pay rate for the employee
         */
        public Builder payRate(String payRate) {
            Utils.checkNotNull(payRate, "payRate");
            this.payRate = JsonNullable.of(payRate);
            return this;
        }

        /**
         * The pay rate for the employee
         */
        public Builder payRate(JsonNullable<String> payRate) {
            Utils.checkNotNull(payRate, "payRate");
            this.payRate = payRate;
            return this;
        }

        /**
         * The pay period
         */
        public Builder payPeriod(UpdateEmployeeApiModelPayPeriod payPeriod) {
            Utils.checkNotNull(payPeriod, "payPeriod");
            this.payPeriod = JsonNullable.of(payPeriod);
            return this;
        }

        /**
         * The pay period
         */
        public Builder payPeriod(JsonNullable<? extends UpdateEmployeeApiModelPayPeriod> payPeriod) {
            Utils.checkNotNull(payPeriod, "payPeriod");
            this.payPeriod = payPeriod;
            return this;
        }

        /**
         * The pay frequency
         */
        public Builder payFrequency(UpdateEmployeeApiModelPayFrequency payFrequency) {
            Utils.checkNotNull(payFrequency, "payFrequency");
            this.payFrequency = JsonNullable.of(payFrequency);
            return this;
        }

        /**
         * The pay frequency
         */
        public Builder payFrequency(JsonNullable<? extends UpdateEmployeeApiModelPayFrequency> payFrequency) {
            Utils.checkNotNull(payFrequency, "payFrequency");
            this.payFrequency = payFrequency;
            return this;
        }

        /**
         * The currency used for pay
         */
        public Builder payCurrency(String payCurrency) {
            Utils.checkNotNull(payCurrency, "payCurrency");
            this.payCurrency = JsonNullable.of(payCurrency);
            return this;
        }

        /**
         * The currency used for pay
         */
        public Builder payCurrency(JsonNullable<String> payCurrency) {
            Utils.checkNotNull(payCurrency, "payCurrency");
            this.payCurrency = payCurrency;
            return this;
        }

        /**
         * The effective date of the employment contract
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder effectiveDate(OffsetDateTime effectiveDate) {
            Utils.checkNotNull(effectiveDate, "effectiveDate");
            this.effectiveDate = JsonNullable.of(effectiveDate);
            return this;
        }

        /**
         * The effective date of the employment contract
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder effectiveDate(JsonNullable<OffsetDateTime> effectiveDate) {
            Utils.checkNotNull(effectiveDate, "effectiveDate");
            this.effectiveDate = effectiveDate;
            return this;
        }

        /**
         * The type of employment (e.g., contractor, permanent)
         */
        public Builder employmentType(UpdateEmployeeApiModelEmploymentEmploymentType employmentType) {
            Utils.checkNotNull(employmentType, "employmentType");
            this.employmentType = JsonNullable.of(employmentType);
            return this;
        }

        /**
         * The type of employment (e.g., contractor, permanent)
         */
        public Builder employmentType(JsonNullable<? extends UpdateEmployeeApiModelEmploymentEmploymentType> employmentType) {
            Utils.checkNotNull(employmentType, "employmentType");
            this.employmentType = employmentType;
            return this;
        }

        /**
         * The employment work schedule type (e.g., full-time, part-time)
         */
        public Builder employmentContractType(UpdateEmployeeApiModelEmploymentEmploymentContractType employmentContractType) {
            Utils.checkNotNull(employmentContractType, "employmentContractType");
            this.employmentContractType = JsonNullable.of(employmentContractType);
            return this;
        }

        /**
         * The employment work schedule type (e.g., full-time, part-time)
         */
        public Builder employmentContractType(JsonNullable<? extends UpdateEmployeeApiModelEmploymentEmploymentContractType> employmentContractType) {
            Utils.checkNotNull(employmentContractType, "employmentContractType");
            this.employmentContractType = employmentContractType;
            return this;
        }

        /**
         * The time worked for the employee in ISO 8601 duration format
         */
        public Builder timeWorked(String timeWorked) {
            Utils.checkNotNull(timeWorked, "timeWorked");
            this.timeWorked = JsonNullable.of(timeWorked);
            return this;
        }

        /**
         * The time worked for the employee in ISO 8601 duration format
         */
        public Builder timeWorked(JsonNullable<String> timeWorked) {
            Utils.checkNotNull(timeWorked, "timeWorked");
            this.timeWorked = timeWorked;
            return this;
        }
        
        public UpdateEmployeeApiModelEmployment build() {
            return new UpdateEmployeeApiModelEmployment(
                id,
                unifiedCustomFields,
                jobTitle,
                payRate,
                payPeriod,
                payFrequency,
                payCurrency,
                effectiveDate,
                employmentType,
                employmentContractType,
                timeWorked);
        }
    }
}

