/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.LmsCreateCollectionRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;

public class LmsCreateCollectionRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto;

    @JsonCreator
    public LmsCreateCollectionRequest(String xAccountId, LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(lmsCreateCollectionRequestDto, "lmsCreateCollectionRequestDto");
        this.xAccountId = xAccountId;
        this.lmsCreateCollectionRequestDto = lmsCreateCollectionRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto() {
        return this.lmsCreateCollectionRequestDto;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public LmsCreateCollectionRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsCreateCollectionRequest withLmsCreateCollectionRequestDto(LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto) {
        Utils.checkNotNull(lmsCreateCollectionRequestDto, "lmsCreateCollectionRequestDto");
        this.lmsCreateCollectionRequestDto = lmsCreateCollectionRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsCreateCollectionRequest other = (LmsCreateCollectionRequest)o;
        return Objects.deepEquals(this.xAccountId, other.xAccountId) && Objects.deepEquals(this.lmsCreateCollectionRequestDto, other.lmsCreateCollectionRequestDto);
    }

    public int hashCode() {
        return Objects.hash(this.xAccountId, this.lmsCreateCollectionRequestDto);
    }

    public String toString() {
        return Utils.toString(LmsCreateCollectionRequest.class, "xAccountId", this.xAccountId, "lmsCreateCollectionRequestDto", this.lmsCreateCollectionRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder lmsCreateCollectionRequestDto(LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto) {
            Utils.checkNotNull(lmsCreateCollectionRequestDto, "lmsCreateCollectionRequestDto");
            this.lmsCreateCollectionRequestDto = lmsCreateCollectionRequestDto;
            return this;
        }

        public LmsCreateCollectionRequest build() {
            return new LmsCreateCollectionRequest(this.xAccountId, this.lmsCreateCollectionRequestDto);
        }
    }
}

