/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.AttachmentContentType;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Attachment {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="url")
    private JsonNullable<String> url;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="content_type")
    private JsonNullable<? extends AttachmentContentType> contentType;

    @JsonCreator
    public Attachment(@JsonProperty(value="url") JsonNullable<String> url, @JsonProperty(value="content_type") JsonNullable<? extends AttachmentContentType> contentType) {
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(contentType, "contentType");
        this.url = url;
        this.contentType = contentType;
    }

    public Attachment() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends AttachmentContentType>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> url() {
        return this.url;
    }

    @JsonIgnore
    public JsonNullable<AttachmentContentType> contentType() {
        return this.contentType;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Attachment withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of((Object)url);
        return this;
    }

    public Attachment withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public Attachment withContentType(AttachmentContentType contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = JsonNullable.of((Object)contentType);
        return this;
    }

    public Attachment withContentType(JsonNullable<? extends AttachmentContentType> contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attachment other = (Attachment)o;
        return Objects.deepEquals(this.url, other.url) && Objects.deepEquals(this.contentType, other.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.contentType);
    }

    public String toString() {
        return Utils.toString(Attachment.class, "url", this.url, "contentType", this.contentType);
    }

    public static final class Builder {
        private JsonNullable<String> url = JsonNullable.undefined();
        private JsonNullable<? extends AttachmentContentType> contentType = JsonNullable.undefined();

        private Builder() {
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of((Object)url);
            return this;
        }

        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder contentType(AttachmentContentType contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = JsonNullable.of((Object)contentType);
            return this;
        }

        public Builder contentType(JsonNullable<? extends AttachmentContentType> contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Attachment build() {
            return new Attachment(this.url, this.contentType);
        }
    }
}

