/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.PushTemplatesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class MarketingListPushTemplatesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends PushTemplatesPaginated> pushTemplatesPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<MarketingListPushTemplatesResponse>> next = () -> Optional.empty();

    @JsonCreator
    public MarketingListPushTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends PushTemplatesPaginated> pushTemplatesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(pushTemplatesPaginated, "pushTemplatesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.pushTemplatesPaginated = pushTemplatesPaginated;
        this.headers = headers;
    }

    public MarketingListPushTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<PushTemplatesPaginated> pushTemplatesPaginated() {
        return this.pushTemplatesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<MarketingListPushTemplatesResponse> next() throws Exception {
        return this.next.call();
    }

    private MarketingListPushTemplatesResponse withNext(Callable<Optional<MarketingListPushTemplatesResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public MarketingListPushTemplatesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingListPushTemplatesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingListPushTemplatesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingListPushTemplatesResponse withPushTemplatesPaginated(PushTemplatesPaginated pushTemplatesPaginated) {
        Utils.checkNotNull(pushTemplatesPaginated, "pushTemplatesPaginated");
        this.pushTemplatesPaginated = Optional.ofNullable(pushTemplatesPaginated);
        return this;
    }

    public MarketingListPushTemplatesResponse withPushTemplatesPaginated(Optional<? extends PushTemplatesPaginated> pushTemplatesPaginated) {
        Utils.checkNotNull(pushTemplatesPaginated, "pushTemplatesPaginated");
        this.pushTemplatesPaginated = pushTemplatesPaginated;
        return this;
    }

    public MarketingListPushTemplatesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingListPushTemplatesResponse other = (MarketingListPushTemplatesResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.pushTemplatesPaginated, other.pushTemplatesPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.pushTemplatesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingListPushTemplatesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "pushTemplatesPaginated", this.pushTemplatesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<MarketingListPushTemplatesResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends PushTemplatesPaginated> pushTemplatesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder pushTemplatesPaginated(PushTemplatesPaginated pushTemplatesPaginated) {
            Utils.checkNotNull(pushTemplatesPaginated, "pushTemplatesPaginated");
            this.pushTemplatesPaginated = Optional.ofNullable(pushTemplatesPaginated);
            return this;
        }

        public Builder pushTemplatesPaginated(Optional<? extends PushTemplatesPaginated> pushTemplatesPaginated) {
            Utils.checkNotNull(pushTemplatesPaginated, "pushTemplatesPaginated");
            this.pushTemplatesPaginated = pushTemplatesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<MarketingListPushTemplatesResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public MarketingListPushTemplatesResponse build() {
            return new MarketingListPushTemplatesResponse(this.contentType, this.statusCode, this.rawResponse, this.pushTemplatesPaginated, this.headers).withNext(this.next);
        }
    }
}

