/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * HrisListTimeEntriesQueryParamFilter
 * 
 * <p>HRIS Time Entries filters
 */
public class HrisListTimeEntriesQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<String> updatedAfter;

    /**
     * Filter to select time entries by employee_id
     */
    @SpeakeasyMetadata("queryParam:name=employee_id")
    private JsonNullable<String> employeeId;

    /**
     * Filter to select time entries after a given time
     */
    @SpeakeasyMetadata("queryParam:name=start_time")
    private JsonNullable<String> startTime;

    /**
     * Filter to select time entries before a given time
     */
    @SpeakeasyMetadata("queryParam:name=end_time")
    private JsonNullable<String> endTime;

    @JsonCreator
    public HrisListTimeEntriesQueryParamFilter(
            JsonNullable<String> updatedAfter,
            JsonNullable<String> employeeId,
            JsonNullable<String> startTime,
            JsonNullable<String> endTime) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(employeeId, "employeeId");
        Utils.checkNotNull(startTime, "startTime");
        Utils.checkNotNull(endTime, "endTime");
        this.updatedAfter = updatedAfter;
        this.employeeId = employeeId;
        this.startTime = startTime;
        this.endTime = endTime;
    }
    
    public HrisListTimeEntriesQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<String> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Filter to select time entries by employee_id
     */
    @JsonIgnore
    public JsonNullable<String> employeeId() {
        return employeeId;
    }

    /**
     * Filter to select time entries after a given time
     */
    @JsonIgnore
    public JsonNullable<String> startTime() {
        return startTime;
    }

    /**
     * Filter to select time entries before a given time
     */
    @JsonIgnore
    public JsonNullable<String> endTime() {
        return endTime;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListTimeEntriesQueryParamFilter withUpdatedAfter(String updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListTimeEntriesQueryParamFilter withUpdatedAfter(JsonNullable<String> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Filter to select time entries by employee_id
     */
    public HrisListTimeEntriesQueryParamFilter withEmployeeId(String employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = JsonNullable.of(employeeId);
        return this;
    }

    /**
     * Filter to select time entries by employee_id
     */
    public HrisListTimeEntriesQueryParamFilter withEmployeeId(JsonNullable<String> employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = employeeId;
        return this;
    }

    /**
     * Filter to select time entries after a given time
     */
    public HrisListTimeEntriesQueryParamFilter withStartTime(String startTime) {
        Utils.checkNotNull(startTime, "startTime");
        this.startTime = JsonNullable.of(startTime);
        return this;
    }

    /**
     * Filter to select time entries after a given time
     */
    public HrisListTimeEntriesQueryParamFilter withStartTime(JsonNullable<String> startTime) {
        Utils.checkNotNull(startTime, "startTime");
        this.startTime = startTime;
        return this;
    }

    /**
     * Filter to select time entries before a given time
     */
    public HrisListTimeEntriesQueryParamFilter withEndTime(String endTime) {
        Utils.checkNotNull(endTime, "endTime");
        this.endTime = JsonNullable.of(endTime);
        return this;
    }

    /**
     * Filter to select time entries before a given time
     */
    public HrisListTimeEntriesQueryParamFilter withEndTime(JsonNullable<String> endTime) {
        Utils.checkNotNull(endTime, "endTime");
        this.endTime = endTime;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisListTimeEntriesQueryParamFilter other = (HrisListTimeEntriesQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.employeeId, other.employeeId) &&
            Utils.enhancedDeepEquals(this.startTime, other.startTime) &&
            Utils.enhancedDeepEquals(this.endTime, other.endTime);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, employeeId, startTime,
            endTime);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisListTimeEntriesQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "employeeId", employeeId,
                "startTime", startTime,
                "endTime", endTime);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> updatedAfter = JsonNullable.undefined();

        private JsonNullable<String> employeeId = JsonNullable.undefined();

        private JsonNullable<String> startTime = JsonNullable.undefined();

        private JsonNullable<String> endTime = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(String updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<String> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Filter to select time entries by employee_id
         */
        public Builder employeeId(String employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = JsonNullable.of(employeeId);
            return this;
        }

        /**
         * Filter to select time entries by employee_id
         */
        public Builder employeeId(JsonNullable<String> employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = employeeId;
            return this;
        }


        /**
         * Filter to select time entries after a given time
         */
        public Builder startTime(String startTime) {
            Utils.checkNotNull(startTime, "startTime");
            this.startTime = JsonNullable.of(startTime);
            return this;
        }

        /**
         * Filter to select time entries after a given time
         */
        public Builder startTime(JsonNullable<String> startTime) {
            Utils.checkNotNull(startTime, "startTime");
            this.startTime = startTime;
            return this;
        }


        /**
         * Filter to select time entries before a given time
         */
        public Builder endTime(String endTime) {
            Utils.checkNotNull(endTime, "endTime");
            this.endTime = JsonNullable.of(endTime);
            return this;
        }

        /**
         * Filter to select time entries before a given time
         */
        public Builder endTime(JsonNullable<String> endTime) {
            Utils.checkNotNull(endTime, "endTime");
            this.endTime = endTime;
            return this;
        }

        public HrisListTimeEntriesQueryParamFilter build() {

            return new HrisListTimeEntriesQueryParamFilter(
                updatedAfter, employeeId, startTime,
                endTime);
        }

    }
}
