/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class ConnectSessionType {
    public static final ConnectSessionType PRODUCTION = new ConnectSessionType("production");
    public static final ConnectSessionType TEST = new ConnectSessionType("test");
    public static final ConnectSessionType UNMAPPED_VALUE = new ConnectSessionType("unmapped_value");
    private static final Map<String, ConnectSessionType> values = ConnectSessionType.createValuesMap();
    private static final Map<String, ConnectSessionTypeEnum> enums = ConnectSessionType.createEnumsMap();
    private final String value;

    private ConnectSessionType(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectSessionType of(String value) {
        Class<ConnectSessionType> clazz = ConnectSessionType.class;
        synchronized (ConnectSessionType.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ConnectSessionType((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<ConnectSessionTypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectSessionType other = (ConnectSessionType)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ConnectSessionType [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectSessionType[] values() {
        Class<ConnectSessionType> clazz = ConnectSessionType.class;
        synchronized (ConnectSessionType.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ConnectSessionType[0]);
        }
    }

    private static final Map<String, ConnectSessionType> createValuesMap() {
        LinkedHashMap<String, ConnectSessionType> map = new LinkedHashMap<String, ConnectSessionType>();
        map.put("production", PRODUCTION);
        map.put("test", TEST);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ConnectSessionTypeEnum> createEnumsMap() {
        HashMap<String, ConnectSessionTypeEnum> map = new HashMap<String, ConnectSessionTypeEnum>();
        map.put("production", ConnectSessionTypeEnum.PRODUCTION);
        map.put("test", ConnectSessionTypeEnum.TEST);
        map.put("unmapped_value", ConnectSessionTypeEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum ConnectSessionTypeEnum {
        PRODUCTION("production"),
        TEST("test"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private ConnectSessionTypeEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<ConnectSessionType> {
        protected _Deserializer() {
            super(ConnectSessionType.class);
        }

        public ConnectSessionType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return ConnectSessionType.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<ConnectSessionType> {
        protected _Serializer() {
            super(ConnectSessionType.class);
        }

        public void serialize(ConnectSessionType value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

