/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.IamListRolesRequest;
import com.stackone.stackone_client_java.models.operations.IamListRolesResponse;
import com.stackone.stackone_client_java.operations.IamListRolesOperation;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class IamListRolesRequestBuilder {
    private IamListRolesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public IamListRolesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public IamListRolesRequestBuilder request(IamListRolesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public IamListRolesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public IamListRolesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public IamListRolesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        IamListRolesOperation operation = new IamListRolesOperation(this.sdkConfiguration, options);
        return (IamListRolesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<IamListRolesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        IamListRolesOperation operation = new IamListRolesOperation(this.sdkConfiguration, options);
        Paginator<IamListRolesRequest, String> iterator = new Paginator<IamListRolesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), IamListRolesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<IamListRolesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

