/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class HrisShiftResultValue {
    public static final HrisShiftResultValue DRAFT = new HrisShiftResultValue("draft");
    public static final HrisShiftResultValue PUBLISHED = new HrisShiftResultValue("published");
    public static final HrisShiftResultValue CONFIRMED = new HrisShiftResultValue("confirmed");
    public static final HrisShiftResultValue CANCELLED = new HrisShiftResultValue("cancelled");
    public static final HrisShiftResultValue UNMAPPED_VALUE = new HrisShiftResultValue("unmapped_value");
    private static final Map<String, HrisShiftResultValue> values = HrisShiftResultValue.createValuesMap();
    private static final Map<String, HrisShiftResultValueEnum> enums = HrisShiftResultValue.createEnumsMap();
    private final String value;

    private HrisShiftResultValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HrisShiftResultValue of(String value) {
        Class<HrisShiftResultValue> clazz = HrisShiftResultValue.class;
        synchronized (HrisShiftResultValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new HrisShiftResultValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<HrisShiftResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HrisShiftResultValue other = (HrisShiftResultValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "HrisShiftResultValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HrisShiftResultValue[] values() {
        Class<HrisShiftResultValue> clazz = HrisShiftResultValue.class;
        synchronized (HrisShiftResultValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new HrisShiftResultValue[0]);
        }
    }

    private static final Map<String, HrisShiftResultValue> createValuesMap() {
        LinkedHashMap<String, HrisShiftResultValue> map = new LinkedHashMap<String, HrisShiftResultValue>();
        map.put("draft", DRAFT);
        map.put("published", PUBLISHED);
        map.put("confirmed", CONFIRMED);
        map.put("cancelled", CANCELLED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HrisShiftResultValueEnum> createEnumsMap() {
        HashMap<String, HrisShiftResultValueEnum> map = new HashMap<String, HrisShiftResultValueEnum>();
        map.put("draft", HrisShiftResultValueEnum.DRAFT);
        map.put("published", HrisShiftResultValueEnum.PUBLISHED);
        map.put("confirmed", HrisShiftResultValueEnum.CONFIRMED);
        map.put("cancelled", HrisShiftResultValueEnum.CANCELLED);
        map.put("unmapped_value", HrisShiftResultValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum HrisShiftResultValueEnum {
        DRAFT("draft"),
        PUBLISHED("published"),
        CONFIRMED("confirmed"),
        CANCELLED("cancelled"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private HrisShiftResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<HrisShiftResultValue> {
        protected _Deserializer() {
            super(HrisShiftResultValue.class);
        }

        public HrisShiftResultValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return HrisShiftResultValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<HrisShiftResultValue> {
        protected _Serializer() {
            super(HrisShiftResultValue.class);
        }

        public void serialize(HrisShiftResultValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

