/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.IamRoleResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class IamGetRoleResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends IamRoleResult> iamRoleResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public IamGetRoleResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends IamRoleResult> iamRoleResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(iamRoleResult, "iamRoleResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.iamRoleResult = iamRoleResult;
        this.headers = headers;
    }

    public IamGetRoleResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<IamRoleResult> iamRoleResult() {
        return this.iamRoleResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public IamGetRoleResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public IamGetRoleResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public IamGetRoleResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public IamGetRoleResponse withIamRoleResult(IamRoleResult iamRoleResult) {
        Utils.checkNotNull(iamRoleResult, "iamRoleResult");
        this.iamRoleResult = Optional.ofNullable(iamRoleResult);
        return this;
    }

    public IamGetRoleResponse withIamRoleResult(Optional<? extends IamRoleResult> iamRoleResult) {
        Utils.checkNotNull(iamRoleResult, "iamRoleResult");
        this.iamRoleResult = iamRoleResult;
        return this;
    }

    public IamGetRoleResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamGetRoleResponse other = (IamGetRoleResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.iamRoleResult, other.iamRoleResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.iamRoleResult, this.headers);
    }

    public String toString() {
        return Utils.toString(IamGetRoleResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "iamRoleResult", this.iamRoleResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends IamRoleResult> iamRoleResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder iamRoleResult(IamRoleResult iamRoleResult) {
            Utils.checkNotNull(iamRoleResult, "iamRoleResult");
            this.iamRoleResult = Optional.ofNullable(iamRoleResult);
            return this;
        }

        public Builder iamRoleResult(Optional<? extends IamRoleResult> iamRoleResult) {
            Utils.checkNotNull(iamRoleResult, "iamRoleResult");
            this.iamRoleResult = iamRoleResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public IamGetRoleResponse build() {
            return new IamGetRoleResponse(this.contentType, this.statusCode, this.rawResponse, this.iamRoleResult, this.headers);
        }
    }
}

