package com.stackspot.plugin.openapi

import com.stackspot.plugin.openapi.template.OpenApiTemplate
import com.stackspot.plugin.util.extensions.listOpenApiSpecs
import com.stackspot.plugin.util.extensions.toKebabCase
import org.gradle.api.DefaultTask
import org.gradle.api.file.DirectoryProperty
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.OutputDirectory
import org.gradle.api.tasks.SourceSet
import org.gradle.api.tasks.SourceSetContainer
import org.gradle.api.tasks.TaskAction

abstract class GenerateOpenApiTask : DefaultTask() {

    @get:Input
    abstract val framework: Property<GenerateOpenApiTaskConfigurator.Framework>

    @get:Input
    abstract val inputDir: Property<String>

    @get:OutputDirectory
    abstract val outputDir: DirectoryProperty

    @get:Input
    abstract val packageName: Property<String>

    @TaskAction
    fun generateOpenApi() {
        val framework = framework.get()
        val inputDir = inputDir.get()
        val outputDir = outputDir.get()
        val basePackage = packageName.get()

        val mainFolder = outputDir.dir("main/kotlin")

        if (!mainFolder.asFile.exists()) {
            mainFolder.asFile.mkdirs()
        }

        inputDir.listOpenApiSpecs().forEach { (name, openAPI) ->
            val servicePackage = "$basePackage.${name.toKebabCase()}"

            OpenApiTemplate(mainFolder.toString(), servicePackage, framework).apply {
                createModels(openAPI)
                createOperations(name, openAPI)
            }
        }

        val sourceSets = project.extensions.getByType(
            SourceSetContainer::class.java
        )
        val main = sourceSets.getByName(SourceSet.MAIN_SOURCE_SET_NAME)
        main.java.srcDirs(mainFolder)
    }
}
