/*
 * Decompiled with CFR 0.152.
 */
package com.textkernel.tx.services;

import com.textkernel.tx.EnvironmentSettings;
import com.textkernel.tx.TxClient;
import com.textkernel.tx.exceptions.TxException;
import com.textkernel.tx.http.HttpResponse;
import com.textkernel.tx.models.api.ApiResponse;
import com.textkernel.tx.models.api.ApiResponseInfoLite;
import com.textkernel.tx.models.api.indexes.IndexingOptionsGeneric;
import com.textkernel.tx.models.api.indexes.SearchAndMatchVersion;
import com.textkernel.tx.services.ApiEndpoints;
import com.textkernel.tx.utilities.TxJsonSerializer;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

abstract class ServiceBase {
    private OkHttpClient _httpClient;
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    protected final EnvironmentSettings _settings;
    protected final ApiEndpoints _endpoints;

    protected ServiceBase(OkHttpClient httpClient, EnvironmentSettings settings) {
        this._httpClient = httpClient;
        this._settings = settings;
        this._endpoints = new ApiEndpoints(settings.DataCenter);
    }

    protected void setEnvironment(IndexingOptionsGeneric options) {
        if (options != null && options.SearchAndMatchVersion == SearchAndMatchVersion.V2) {
            options.SearchAndMatchEnvironment = this._settings.MatchV2Environment;
        }
    }

    static String getBodyIfDebug(Request request) {
        if (TxClient.ShowFullRequestBodyInExceptions) {
            try {
                Request copy = request.newBuilder().build();
                Buffer buffer = new Buffer();
                RequestBody body = copy.body();
                if (body != null) {
                    body.writeTo((BufferedSink)buffer);
                    return buffer.readUtf8();
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    protected RequestBody createJsonBody(Object body) {
        return RequestBody.create((MediaType)JSON, (String)TxJsonSerializer.serialize(body));
    }

    protected <T extends ApiResponse<?>> HttpResponse<T> executeRequest(Request apiRequest, Class<T> classOfT, String requestBody) throws TxException {
        ApiResponseInfoLite errorInfo = new ApiResponseInfoLite();
        errorInfo.Code = "Error";
        errorInfo.Message = "Unknown API error.";
        HttpResponse<T> apiResponse = null;
        Response rawResponse = null;
        try {
            rawResponse = this._httpClient.newCall(apiRequest).execute();
            apiResponse = new HttpResponse<T>(rawResponse, classOfT);
            if (rawResponse != null && rawResponse.code() == 413) {
                errorInfo.Message = "Request body was too large.";
                throw new TxException(requestBody, rawResponse, errorInfo, null);
            }
            if (rawResponse != null && apiResponse.getData() == null && rawResponse.code() != 200) {
                errorInfo.Message = rawResponse.code() + " - " + rawResponse.message();
            }
            if (apiResponse == null || apiResponse.getData() == null) {
                throw new TxException(requestBody, rawResponse, errorInfo, null);
            }
        }
        catch (IOException e) {
            errorInfo.Message = e.getMessage();
            TxException newEx = new TxException(requestBody, rawResponse, errorInfo, null);
            newEx.InnerException = e;
            throw newEx;
        }
        if (!rawResponse.isSuccessful()) {
            throw new TxException(requestBody, rawResponse, ((ApiResponse)apiResponse.getData()).Info);
        }
        return apiResponse;
    }
}

