/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.om.AssetID;
import com.versionone.om.BaseAsset;
import com.versionone.om.Member;
import com.versionone.om.MessageException;
import com.versionone.om.MessageReceipt;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.MetaRenamedAttribute;
import com.versionone.om.NotRecipientofMessageException;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.MessageReceiptFilter;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="Message")
public class Message
extends BaseAsset {
    private MessageReceipt _receipt;

    Message(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    Message(V1Instance instance) {
        super(instance);
    }

    public Collection<Member> getRecipients() {
        return this.getMultiRelation("Recipients");
    }

    @MetaRenamedAttribute(value="Asset")
    public BaseAsset getRelatedAsset() {
        return this.getRelation(BaseAsset.class, "Asset");
    }

    public void setRelatedAsset(BaseAsset value) {
        this.setRelation("Asset", value);
    }

    @MetaRenamedAttribute(value="CheckSend")
    public boolean isReadyToSend() {
        return (Boolean)this.get("CheckSend");
    }

    public boolean isUnread() {
        return this.getReceipt().isUnread();
    }

    public boolean isRead() {
        return this.getReceipt().isRead();
    }

    public boolean isUnarchived() {
        return this.getReceipt().isUnarchived();
    }

    public boolean isArchived() {
        return this.getReceipt().isArchived();
    }

    public Message send() {
        if (this.getRecipients().size() == 0) {
            throw new MessageException("Must have at least one message recipient to send to.");
        }
        this.save();
        this.getInstance().executeOperation(Message.class, this, "Send");
        return this;
    }

    private MessageReceipt getReceipt() {
        if (this._receipt == null) {
            MessageReceiptFilter filter = new MessageReceiptFilter();
            filter.recipient.add(this.getInstance().getLoggedInMember());
            filter.message.add(this);
            Collection<MessageReceipt> receipts = this.getInstance().get().messageReceipts(filter);
            if (receipts.size() == 1) {
                Iterator<MessageReceipt> iter = receipts.iterator();
                this._receipt = iter.next();
            } else {
                throw new NotRecipientofMessageException();
            }
        }
        return this._receipt;
    }

    public void markAsRead() {
        this.getReceipt().markAsRead();
    }

    public void markAsUnread() {
        this.getReceipt().markAsUnread();
    }

    public void markAsArchived() {
        this.getReceipt().markAsArchived();
    }

    public void markAsUnarchived() {
        this.getReceipt().markAsUnarchived();
    }

    @Override
    void closeImpl() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    void reactivateImpl() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean deleteReceipt() {
        try {
            this.getReceipt().delete();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

