/*
 * Decompiled with CFR 0.152.
 */
package com.vortexsoftware.sdk;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vortexsoftware.sdk.VortexException;
import com.vortexsoftware.sdk.types.AcceptInvitationRequest;
import com.vortexsoftware.sdk.types.AcceptUser;
import com.vortexsoftware.sdk.types.AutojoinDomainsResponse;
import com.vortexsoftware.sdk.types.ConfigureAutojoinRequest;
import com.vortexsoftware.sdk.types.CreateInvitationRequest;
import com.vortexsoftware.sdk.types.CreateInvitationResponse;
import com.vortexsoftware.sdk.types.InvitationResponse;
import com.vortexsoftware.sdk.types.InvitationResult;
import com.vortexsoftware.sdk.types.InvitationTarget;
import com.vortexsoftware.sdk.types.User;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VortexClient {
    private static final Logger logger = LoggerFactory.getLogger(VortexClient.class);
    private static final String DEFAULT_BASE_URL = "https://api.vortexsoftware.com";
    private static final String USER_AGENT = "vortex-java-sdk/1.0.0";
    private final String apiKey;
    private final String baseUrl;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public VortexClient(String apiKey) {
        this(apiKey, System.getenv().getOrDefault("VORTEX_API_BASE_URL", DEFAULT_BASE_URL));
    }

    public VortexClient(String apiKey, String baseUrl) {
        this.apiKey = Objects.requireNonNull(apiKey, "API key cannot be null");
        this.baseUrl = baseUrl != null ? baseUrl : DEFAULT_BASE_URL;
        this.httpClient = HttpClients.createDefault();
        this.objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    }

    public String generateJwt(Map<String, Object> params) throws VortexException {
        try {
            if (params == null || !params.containsKey("user")) {
                throw new VortexException("params must contain 'user' key");
            }
            Object userObj = params.get("user");
            if (!(userObj instanceof User)) {
                throw new VortexException("'user' must be a User object");
            }
            User user = (User)userObj;
            String[] parts = this.apiKey.split("\\.");
            if (parts.length != 3 || !"VRTX".equals(parts[0])) {
                throw new VortexException("Invalid API key format");
            }
            String encodedId = parts[1];
            String key = parts[2];
            byte[] idBytes = Base64.getUrlDecoder().decode(encodedId);
            String id = this.bytesToUUID(idBytes);
            long now = Instant.now().getEpochSecond();
            long expires = now + 3600L;
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            hmacSha256.init(keySpec);
            byte[] signingKey = hmacSha256.doFinal(id.getBytes(StandardCharsets.UTF_8));
            LinkedHashMap<String, Object> header = new LinkedHashMap<String, Object>();
            header.put("iat", now);
            header.put("alg", "HS256");
            header.put("typ", "JWT");
            header.put("kid", id);
            LinkedHashMap<String, Object> jwtPayload = new LinkedHashMap<String, Object>();
            jwtPayload.put("userId", user.getId());
            jwtPayload.put("userEmail", user.getEmail());
            jwtPayload.put("expires", expires);
            if (user.getUserName() != null) {
                jwtPayload.put("userName", user.getUserName());
            }
            if (user.getUserAvatarUrl() != null) {
                jwtPayload.put("userAvatarUrl", user.getUserAvatarUrl());
            }
            if (user.getAdminScopes() != null) {
                jwtPayload.put("adminScopes", user.getAdminScopes());
            }
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if ("user".equals(entry.getKey())) continue;
                jwtPayload.put(entry.getKey(), entry.getValue());
            }
            String headerJson = this.objectMapper.writeValueAsString(header);
            String payloadJson = this.objectMapper.writeValueAsString(jwtPayload);
            String headerB64 = Base64.getUrlEncoder().withoutPadding().encodeToString(headerJson.getBytes(StandardCharsets.UTF_8));
            String payloadB64 = Base64.getUrlEncoder().withoutPadding().encodeToString(payloadJson.getBytes(StandardCharsets.UTF_8));
            String toSign = headerB64 + "." + payloadB64;
            Mac signer = Mac.getInstance("HmacSHA256");
            SecretKeySpec signingKeySpec = new SecretKeySpec(signingKey, "HmacSHA256");
            signer.init(signingKeySpec);
            byte[] signature = signer.doFinal(toSign.getBytes(StandardCharsets.UTF_8));
            String signatureB64 = Base64.getUrlEncoder().withoutPadding().encodeToString(signature);
            return toSign + "." + signatureB64;
        }
        catch (Exception e) {
            throw new VortexException("Failed to generate JWT", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T apiRequest(String method, String path, Object body, Map<String, String> queryParams, TypeReference<T> responseType) throws VortexException {
        try {
            String url = this.baseUrl + path;
            ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.create((String)method).setUri(url);
            if (queryParams != null) {
                queryParams.forEach((arg_0, arg_1) -> ((ClassicRequestBuilder)requestBuilder).addParameter(arg_0, arg_1));
            }
            requestBuilder.addHeader("Content-Type", "application/json").addHeader("User-Agent", USER_AGENT).addHeader("x-api-key", this.apiKey);
            if (body != null && ("POST".equals(method) || "PUT".equals(method))) {
                String bodyJson = this.objectMapper.writeValueAsString(body);
                requestBuilder.setEntity((HttpEntity)new StringEntity(bodyJson, ContentType.APPLICATION_JSON));
            }
            try (CloseableHttpResponse response = this.httpClient.execute(requestBuilder.build());){
                String responseBody = new String(response.getEntity().getContent().readAllBytes(), StandardCharsets.UTF_8);
                if (response.getCode() >= 400) {
                    throw new VortexException("API request failed: " + response.getCode() + " " + response.getReasonPhrase() + " - " + responseBody);
                }
                if (responseBody.trim().isEmpty()) {
                    T t = null;
                    return t;
                }
                Object object = this.objectMapper.readValue(responseBody, responseType);
                return (T)object;
            }
        }
        catch (VortexException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VortexException("Failed to make API request", e);
        }
    }

    public List<InvitationResult> getInvitationsByTarget(String targetType, String targetValue) throws VortexException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("targetType", targetType);
        queryParams.put("targetValue", targetValue);
        InvitationResponse response = this.apiRequest("GET", "/api/v1/invitations", null, queryParams, new TypeReference<InvitationResponse>(){});
        return response != null ? response.getInvitations() : new ArrayList<InvitationResult>();
    }

    public InvitationResult getInvitation(String invitationId) throws VortexException {
        return this.apiRequest("GET", "/api/v1/invitations/" + invitationId, null, null, new TypeReference<InvitationResult>(){});
    }

    public void revokeInvitation(String invitationId) throws VortexException {
        this.apiRequest("DELETE", "/api/v1/invitations/" + invitationId, null, null, new TypeReference<Void>(){});
    }

    public InvitationResult acceptInvitations(List<String> invitationIds, AcceptUser user) throws VortexException {
        if ((user.getEmail() == null || user.getEmail().isEmpty()) && (user.getPhone() == null || user.getPhone().isEmpty())) {
            throw new VortexException("User must have either email or phone");
        }
        AcceptInvitationRequest request = new AcceptInvitationRequest(invitationIds, user);
        InvitationResponse response = this.apiRequest("POST", "/api/v1/invitations/accept", request, null, new TypeReference<InvitationResponse>(){});
        if (response.getInvitations() != null && !response.getInvitations().isEmpty()) {
            return response.getInvitations().get(0);
        }
        throw new VortexException("No invitations returned from accept endpoint");
    }

    @Deprecated
    public InvitationResult acceptInvitations(List<String> invitationIds, InvitationTarget target) throws VortexException {
        logger.warn("[Vortex SDK] DEPRECATED: Passing an InvitationTarget is deprecated. Use the AcceptUser format instead: acceptInvitations(invitationIds, new AcceptUser(email))");
        AcceptUser user = new AcceptUser();
        if ("email".equals((Object)target.getType())) {
            user.setEmail(target.getValue());
        } else if ("phone".equals((Object)target.getType()) || "phoneNumber".equals((Object)target.getType())) {
            user.setPhone(target.getValue());
        } else {
            user.setEmail(target.getValue());
        }
        return this.acceptInvitations(invitationIds, user);
    }

    @Deprecated
    public InvitationResult acceptInvitations(List<String> invitationIds, List<InvitationTarget> targets) throws VortexException {
        logger.warn("[Vortex SDK] DEPRECATED: Passing a list of InvitationTarget is deprecated. Use the AcceptUser format and call once per user instead.");
        if (targets == null || targets.isEmpty()) {
            throw new VortexException("No targets provided");
        }
        InvitationResult lastResult = null;
        VortexException lastException = null;
        for (InvitationTarget target : targets) {
            try {
                lastResult = this.acceptInvitations(invitationIds, target);
            }
            catch (VortexException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return lastResult;
    }

    public void deleteInvitationsByGroup(String groupType, String groupId) throws VortexException {
        this.apiRequest("DELETE", "/api/v1/invitations/by-group/" + groupType + "/" + groupId, null, null, new TypeReference<Void>(){});
    }

    public List<InvitationResult> getInvitationsByGroup(String groupType, String groupId) throws VortexException {
        InvitationResponse response = this.apiRequest("GET", "/api/v1/invitations/by-group/" + groupType + "/" + groupId, null, null, new TypeReference<InvitationResponse>(){});
        return response != null ? response.getInvitations() : new ArrayList<InvitationResult>();
    }

    public InvitationResult reinvite(String invitationId) throws VortexException {
        return this.apiRequest("POST", "/api/v1/invitations/" + invitationId + "/reinvite", null, null, new TypeReference<InvitationResult>(){});
    }

    public CreateInvitationResponse createInvitation(CreateInvitationRequest request) throws VortexException {
        if (request == null) {
            throw new VortexException("Request cannot be null");
        }
        if (request.getWidgetConfigurationId() == null || request.getWidgetConfigurationId().isEmpty()) {
            throw new VortexException("widgetConfigurationId is required");
        }
        if (request.getTarget() == null || request.getTarget().getValue() == null || request.getTarget().getValue().isEmpty()) {
            throw new VortexException("target with value is required");
        }
        if (request.getInviter() == null || request.getInviter().getUserId() == null || request.getInviter().getUserId().isEmpty()) {
            throw new VortexException("inviter with userId is required");
        }
        return this.apiRequest("POST", "/api/v1/invitations", request, null, new TypeReference<CreateInvitationResponse>(){});
    }

    public AutojoinDomainsResponse getAutojoinDomains(String scopeType, String scope) throws VortexException {
        String encodedScopeType = URLEncoder.encode(scopeType, StandardCharsets.UTF_8);
        String encodedScope = URLEncoder.encode(scope, StandardCharsets.UTF_8);
        String path = "/api/v1/invitations/by-scope/" + encodedScopeType + "/" + encodedScope + "/autojoin";
        return this.apiRequest("GET", path, null, null, new TypeReference<AutojoinDomainsResponse>(){});
    }

    public AutojoinDomainsResponse configureAutojoin(ConfigureAutojoinRequest request) throws VortexException {
        if (request == null) {
            throw new VortexException("Request cannot be null");
        }
        if (request.getScope() == null || request.getScope().isEmpty()) {
            throw new VortexException("scope is required");
        }
        if (request.getScopeType() == null || request.getScopeType().isEmpty()) {
            throw new VortexException("scopeType is required");
        }
        if (request.getWidgetId() == null || request.getWidgetId().isEmpty()) {
            throw new VortexException("widgetId is required");
        }
        return this.apiRequest("POST", "/api/v1/invitations/autojoin", request, null, new TypeReference<AutojoinDomainsResponse>(){});
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (Exception e) {
            logger.warn("Error closing HTTP client", (Throwable)e);
        }
    }

    private String bytesToUUID(byte[] bytes) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("UUID bytes must be 16 bytes long");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                sb.append('-');
            }
            sb.append(String.format("%02x", bytes[i]));
        }
        return sb.toString();
    }
}

