/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Preconditions;
import com.wavefront.common.MetricMangler;
import com.wavefront.ingester.Decoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.razorvine.pickle.Unpickler;
import sunnylabs.report.ReportPoint;

public class PickleProtocolDecoder
implements Decoder<byte[]> {
    protected static final Logger logger = Logger.getLogger("agent");
    private final int port;
    private final String defaultHostName;
    private final List<String> customSourceTags;
    private final MetricMangler metricMangler;
    private final ThreadLocal<Unpickler> unpicklerThreadLocal = new ThreadLocal<Unpickler>(){

        @Override
        protected Unpickler initialValue() {
            return new Unpickler();
        }
    };

    public PickleProtocolDecoder(String hostName, List<String> customSourceTags, MetricMangler mangler, int port) {
        Preconditions.checkNotNull((Object)hostName);
        this.defaultHostName = hostName;
        Preconditions.checkNotNull(customSourceTags);
        this.customSourceTags = customSourceTags;
        this.metricMangler = mangler;
        this.port = port;
    }

    @Override
    public void decodeReportPoints(byte[] msg, List<ReportPoint> out, String customerId) {
        Object dataRaw;
        ByteArrayInputStream is = new ByteArrayInputStream(msg);
        try {
            dataRaw = this.unpicklerThreadLocal.get().load((InputStream)is);
            if (!(dataRaw instanceof List)) {
                throw new IllegalArgumentException(String.format("[%d] unable to unpickle data (unpickle did not return list)", this.port));
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(String.format("[%d] unable to unpickle data", this.port), ioe);
        }
        List data = (List)dataRaw;
        for (Object[] o : data) {
            double value;
            long ts;
            Object[] details = (Object[])o[1];
            if (details == null || details.length != 2) {
                logger.warning(String.format("[%d] Unexpected pickle protocol input", this.port));
                continue;
            }
            if (details[0] == null) {
                logger.warning(String.format("[%d] Unexpected pickle protocol input (timestamp is null)", this.port));
                continue;
            }
            if (details[0] instanceof Double) {
                ts = ((Double)details[0]).longValue() * 1000L;
            } else if (details[0] instanceof Long) {
                ts = (Long)details[0] * 1000L;
            } else if (details[0] instanceof Integer) {
                ts = ((Integer)details[0]).longValue() * 1000L;
            } else {
                logger.warning(String.format("[%d] Unexpected pickle protocol input (details[0]: %s)", this.port, details[0].getClass().getName()));
                continue;
            }
            if (details[1] == null) continue;
            if (details[1] instanceof Double) {
                value = (Double)details[1];
            } else if (details[1] instanceof Long) {
                value = ((Long)details[1]).longValue();
            } else if (details[1] instanceof Integer) {
                value = ((Integer)details[1]).intValue();
            } else {
                logger.warning(String.format("[%d] Unexpected pickle protocol input (value is null)", this.port));
                continue;
            }
            ReportPoint point = new ReportPoint();
            MetricMangler.MetricComponents components = this.metricMangler.extractComponents(o[0].toString());
            point.setMetric(components.metric);
            String host = components.source;
            Map<String, String> annotations = point.getAnnotations();
            if (host == null && annotations != null) {
                String tag;
                Iterator<String> iterator = this.customSourceTags.iterator();
                while (iterator.hasNext() && (host = annotations.remove(tag = iterator.next())) == null) {
                }
                if (host == null) {
                    host = this.defaultHostName;
                }
            }
            point.setHost(host);
            point.setTable(customerId);
            point.setTimestamp(ts);
            point.setValue(value);
            point.setAnnotations(Collections.emptyMap());
            out.add(point);
        }
    }

    @Override
    public void decodeReportPoints(byte[] msg, List<ReportPoint> out) {
        this.decodeReportPoints(msg, out, "dummy");
    }
}

