/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.Decoder;
import com.wavefront.ingester.ReportPointIngesterFormatter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import wavefront.report.ReportPoint;

public class HistogramDecoder
implements Decoder<String> {
    private static final Logger logger = Logger.getLogger(HistogramDecoder.class.getCanonicalName());
    private static final AbstractIngesterFormatter<ReportPoint> FORMAT = ReportPointIngesterFormatter.newBuilder().whiteSpace().binType().whiteSpace().appendOptionalTimestamp().adjustTimestamp().whiteSpace().centroids().whiteSpace().appendMetricName().whiteSpace().appendAnnotationsConsumer().build();
    private final String defaultHostName;

    public HistogramDecoder() {
        this("unknown");
    }

    public HistogramDecoder(String defaultHostName) {
        this.defaultHostName = defaultHostName;
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out, String customerId) {
        ReportPoint point = FORMAT.drive(msg, this.defaultHostName, customerId);
        if (point != null) {
            out.add(ReportPoint.newBuilder(point).build());
        }
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out) {
        logger.log(Level.WARNING, "This decoder does not support customerId extraction, ignoring " + msg);
    }
}

