/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.example.quotes;

import com.webull.openapi.common.dict.Category;
import com.webull.openapi.common.dict.Timespan;
import com.webull.openapi.example.config.Env;
import com.webull.openapi.execption.ClientException;
import com.webull.openapi.execption.ServerException;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.quotes.api.QuotesApiClient;
import com.webull.openapi.quotes.domain.Quote;
import java.util.HashSet;
import java.util.List;

public class QuotesGrpcApi {
    private static final Logger logger = LoggerFactory.getLogger(QuotesGrpcApi.class);

    public static void main(String[] args) {
        String symbol = "AAPL";
        try (QuotesApiClient quotesApiClient = QuotesApiClient.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId(Env.REGION_ID).build();){
            HashSet<String> symbols = new HashSet<String>();
            symbols.add(symbol);
            List instruments = quotesApiClient.getInstruments(symbols, Category.US_STOCK.name());
            logger.info("Instruments: {}", (Object)instruments);
            List bars = quotesApiClient.getBars(symbol, Category.US_STOCK.name(), Timespan.D.name(), 10);
            logger.info("Bars: {}", (Object)bars);
            Quote quote = quotesApiClient.getQuote(symbol, Category.US_STOCK.name());
            logger.info("Quote: {}", (Object)quote);
            List snapshots = quotesApiClient.getSnapshots(symbols, Category.US_STOCK.name());
            logger.info("Snapshots: {}", (Object)snapshots);
            List ticks = quotesApiClient.getTicks(symbol, Category.US_STOCK.name(), 10);
            logger.info("Ticks: {}", (Object)ticks);
        }
        catch (ClientException ex) {
            logger.error("Client error", (Throwable)ex);
        }
        catch (ServerException ex) {
            logger.error("Sever error", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Unknown error", (Throwable)ex);
        }
    }
}

