/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.example.quotes;

import com.webull.openapi.common.dict.Category;
import com.webull.openapi.common.dict.EventType;
import com.webull.openapi.common.dict.Timespan;
import com.webull.openapi.example.config.Env;
import com.webull.openapi.execption.ClientException;
import com.webull.openapi.execption.ServerException;
import com.webull.openapi.http.HttpApiConfig;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.quotes.domain.CorpActionRequest;
import com.webull.openapi.quotes.internal.http.HttpQuotesApiClient;
import java.util.HashSet;
import java.util.List;

public class QuotesHttpApi {
    private static final Logger logger = LoggerFactory.getLogger(QuotesHttpApi.class);

    public static void main(String[] args) {
        HashSet<String> symbols = new HashSet<String>();
        symbols.add("AAPL");
        symbols.add("TSLA");
        HashSet<String> instrumentIds = new HashSet<String>();
        instrumentIds.add("913303964");
        instrumentIds.add("913256135");
        HashSet<String> eventTypes = new HashSet<String>();
        eventTypes.add(EventType.Reverse_Stock_Split.getCode());
        eventTypes.add(EventType.Stock_Split.getCode());
        HttpApiConfig apiConfig = HttpApiConfig.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId(Env.REGION_ID).build();
        try (HttpQuotesApiClient quotesApiClient = new HttpQuotesApiClient(apiConfig);){
            List bars = quotesApiClient.getBars("AAPL", Category.US_STOCK.name(), Timespan.D.name(), 200);
            logger.info("Bars: {}", (Object)bars);
            List snapshots = quotesApiClient.getSnapshots(symbols, Category.US_STOCK.name());
            logger.info("Snapshots: {}", (Object)snapshots);
            List instruments = quotesApiClient.getInstruments(symbols, Category.US_STOCK.name());
            logger.info("Instruments: {}", (Object)instruments);
            List pageInstruments = quotesApiClient.queryPageInstruments(Integer.valueOf(913303964), Integer.valueOf(10));
            logger.info("Page Instruments: {}", (Object)pageInstruments);
            List eodBars = quotesApiClient.getEodBars(instrumentIds, "2023-01-01", Integer.valueOf(10));
            logger.info("Eod bars: {}", (Object)eodBars);
            CorpActionRequest corpActionReq = new CorpActionRequest();
            corpActionReq.setEventTypes(eventTypes);
            corpActionReq.setInstrumentIds(instrumentIds);
            List corpAction = quotesApiClient.getCorpAction(corpActionReq);
            logger.info("Corp action: {}", (Object)corpAction);
        }
        catch (ClientException ex) {
            logger.error("Client error", (Throwable)ex);
        }
        catch (ServerException ex) {
            logger.error("Sever error", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Unknown error", (Throwable)ex);
        }
    }
}

