/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.example.trade;

import com.webull.openapi.common.dict.InstrumentSuperType;
import com.webull.openapi.common.dict.Markets;
import com.webull.openapi.common.dict.OrderSide;
import com.webull.openapi.common.dict.OrderTIF;
import com.webull.openapi.common.dict.OrderType;
import com.webull.openapi.example.config.Env;
import com.webull.openapi.execption.ClientException;
import com.webull.openapi.execption.ServerException;
import com.webull.openapi.http.HttpApiConfig;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.trade.api.http.TradeHttpApiService;
import com.webull.openapi.trade.api.request.StockOrder;
import com.webull.openapi.trade.api.response.Account;
import com.webull.openapi.trade.api.response.AccountDetail;
import com.webull.openapi.trade.api.response.AccountPositions;
import com.webull.openapi.trade.api.response.BalanceBase;
import com.webull.openapi.trade.api.response.InstrumentInfo;
import com.webull.openapi.trade.api.response.Order;
import com.webull.openapi.trade.api.response.OrderResponse;
import com.webull.openapi.trade.api.response.Orders;
import com.webull.openapi.trade.api.response.TradableInstruments;
import com.webull.openapi.utils.CollectionUtils;
import com.webull.openapi.utils.GUID;
import com.webull.openapi.utils.StringUtils;
import java.util.Collection;
import java.util.List;

public class TradeApi {
    private static final Logger logger = LoggerFactory.getLogger(TradeApi.class);

    public static void main(String[] args) {
        try {
            HttpApiConfig apiConfig = HttpApiConfig.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId(Env.REGION_ID).build();
            TradeHttpApiService apiService = new TradeHttpApiService(apiConfig);
            List accounts = apiService.getAccountList("");
            logger.info("Accounts: {}", (Object)accounts);
            String accountId = null;
            if (CollectionUtils.isNotEmpty((Collection)accounts)) {
                accountId = ((Account)accounts.get(0)).getAccountId();
            }
            if (StringUtils.isBlank(accountId)) {
                logger.info("Account id is empty.");
                return;
            }
            BalanceBase accountBalance = apiService.getAccountBalance(accountId, "");
            logger.info("Account balance: {}", (Object)accountBalance);
            AccountDetail accountDetail = apiService.getAccountDetail(accountId);
            logger.info("Account detail: {}", (Object)accountDetail);
            AccountPositions accountPositions = apiService.getAccountPositions(accountId, Integer.valueOf(10), "");
            logger.info("Account positions: {}", (Object)accountPositions);
            String clientOrderId = GUID.get();
            StockOrder stockOrder = new StockOrder();
            stockOrder.setClientOrderId(clientOrderId);
            stockOrder.setInstrumentId("913256135");
            stockOrder.setSide(OrderSide.BUY.name());
            stockOrder.setTif(OrderTIF.DAY.name());
            stockOrder.setOrderType(OrderType.MARKET.name());
            stockOrder.setQty("100");
            stockOrder.setExtendedHoursTrading(Boolean.valueOf(false));
            OrderResponse placeOrderResponse = apiService.placeOrder(accountId, stockOrder);
            logger.info("Place order: {}", (Object)placeOrderResponse);
            OrderResponse replaceOrderResponse = apiService.replaceOrder(accountId, stockOrder);
            logger.info("Replace order: {}", (Object)replaceOrderResponse);
            OrderResponse cancelOrderResponse = apiService.cancelOrder(accountId, clientOrderId);
            logger.info("Cancel order: {}", (Object)cancelOrderResponse);
            Orders dayOrders = apiService.getDayOrders(accountId, Integer.valueOf(10), "");
            logger.info("Day orders: {}", (Object)dayOrders);
            Orders openedOrders = apiService.getOpenedOrders(accountId, Integer.valueOf(10), "");
            logger.info("Opened orders: {}", (Object)openedOrders);
            Order orderDetail = apiService.getOrderDetails(accountId, clientOrderId);
            logger.info("Order detail: {}", (Object)orderDetail);
            InstrumentInfo instrumentInfo = apiService.getTradeInstrument("913256135");
            logger.info("Instrument info: {}", (Object)instrumentInfo);
            List tradeCalendars = apiService.getTradeCalendar(Markets.US.name(), "2023-01-01", "2023-01-10");
            logger.info("Trade calendars: {}", (Object)tradeCalendars);
            InstrumentInfo securityInfo = apiService.getSecurityInfo("SPX", Markets.US.name(), InstrumentSuperType.OPTION.name(), "CALL_OPTION", "3400", "2024-12-20");
            logger.info("Security info: {}", (Object)securityInfo);
            TradableInstruments tradeableInstruments = apiService.getTradeableInstruments("", Integer.valueOf(10));
            logger.info("Tradeable instruments info: {}", (Object)tradeableInstruments);
        }
        catch (ClientException ex) {
            logger.error("Client error", (Throwable)ex);
        }
        catch (ServerException ex) {
            logger.error("Sever error", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Unknown error", (Throwable)ex);
        }
    }
}

