/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.MemcachedItem;
import com.schooner.MemCached.ObjectTransCoder;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.SchoonerSockIOPool;
import com.schooner.MemCached.TransCoder;
import com.schooner.MemCached.command.DeletionCommand;
import com.schooner.MemCached.command.FlushAllCommand;
import com.schooner.MemCached.command.IncrdecrCommand;
import com.schooner.MemCached.command.RetrievalCommand;
import com.schooner.MemCached.command.StatsCommand;
import com.schooner.MemCached.command.StorageCommand;
import com.schooner.MemCached.command.SyncAllCommand;
import com.schooner.MemCached.command.SyncCommand;
import com.whalin.MemCached.ErrorHandler;
import com.whalin.MemCached.MemCachedClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AscIIUDPClient
extends MemCachedClient {
    private TransCoder transCoder = new ObjectTransCoder();
    private SchoonerSockIOPool pool;
    private String poolName;
    private boolean sanitizeKeys;
    private boolean primitiveAsString;
    private boolean compressEnable;
    private long compressThreshold;
    private String defaultEncoding = "utf-8";
    public static final byte B_DELIMITER = 32;
    public static final byte B_RETURN = 13;

    @Override
    public boolean isUseBinaryProtocol() {
        return false;
    }

    public AscIIUDPClient() {
        this("default");
    }

    public AscIIUDPClient(String string) {
        this.poolName = string;
        this.init();
    }

    public AscIIUDPClient(String string, ClassLoader classLoader, ErrorHandler errorHandler) {
        this.poolName = string;
        this.classLoader = classLoader;
        this.errorHandler = errorHandler;
        this.init();
    }

    private void init() {
        this.sanitizeKeys = true;
        this.primitiveAsString = false;
        this.compressEnable = true;
        this.compressThreshold = 30720L;
        this.defaultEncoding = "UTF-8";
        this.poolName = this.poolName == null ? "default" : this.poolName;
        this.pool = SchoonerSockIOPool.getInstance(this.poolName);
    }

    @Override
    public boolean set(String string, Object object) {
        return this.set("set", string, object, null, null, 0L);
    }

    @Override
    public boolean set(String string, Object object, Integer n) {
        return this.set("set", string, object, null, n, 0L);
    }

    @Override
    public boolean set(String string, Object object, Date date) {
        return this.set("set", string, object, date, null, 0L);
    }

    @Override
    public boolean set(String string, Object object, Date date, Integer n) {
        return this.set("set", string, object, date, n, 0L);
    }

    @Override
    public boolean add(String string, Object object) {
        return this.set("add", string, object, null, null, 0L);
    }

    @Override
    public boolean add(String string, Object object, Integer n) {
        return this.set("add", string, object, null, n, 0L);
    }

    @Override
    public boolean add(String string, Object object, Date date) {
        return this.set("add", string, object, date, null, 0L);
    }

    @Override
    public boolean add(String string, Object object, Date date, Integer n) {
        return this.set("add", string, object, date, n, 0L);
    }

    @Override
    public boolean append(String string, Object object, Integer n) {
        return this.set("append", string, object, null, n, 0L);
    }

    @Override
    public boolean append(String string, Object object) {
        return this.set("append", string, object, null, null, 0L);
    }

    @Override
    public boolean cas(String string, Object object, Integer n, long l) {
        return this.set("cas", string, object, null, n, l);
    }

    @Override
    public boolean cas(String string, Object object, Date date, long l) {
        return this.set("cas", string, object, date, null, l);
    }

    @Override
    public boolean cas(String string, Object object, Date date, Integer n, long l) {
        return this.set("cas", string, object, date, n, l);
    }

    @Override
    public boolean cas(String string, Object object, long l) {
        return this.set("cas", string, object, null, null, l);
    }

    @Override
    public boolean prepend(String string, Object object, Integer n) {
        return this.set("prepend", string, object, null, n, 0L);
    }

    @Override
    public boolean prepend(String string, Object object) {
        return this.set("prepend", string, object, null, null, 0L);
    }

    @Override
    public boolean replace(String string, Object object) {
        return this.set("replace", string, object, null, null, 0L);
    }

    @Override
    public boolean replace(String string, Object object, Integer n) {
        return this.set("replace", string, object, null, n, 0L);
    }

    @Override
    public boolean replace(String string, Object object, Date date) {
        return this.set("replace", string, object, date, null, 0L);
    }

    @Override
    public boolean replace(String string, Object object, Date date, Integer n) {
        return this.set("replace", string, object, date, n, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean set(String string, String string2, Object object, Date date, Integer n, Long l) {
        if (string == null || string2 == null) {
            if (log.isErrorEnabled()) {
                log.error("key is null or cmd is null/empty for set()");
            }
            return false;
        }
        try {
            string2 = this.sanitizeKey(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, unsupportedEncodingException, string2);
            }
            if (log.isErrorEnabled()) {
                log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            }
            return false;
        }
        if (object == null) {
            if (log.isErrorEnabled()) {
                log.error("trying to store a null value to cache");
            }
            return false;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string2, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), string2);
            }
            return false;
        }
        if (date == null) {
            date = new Date(0L);
        }
        try {
            StorageCommand storageCommand = new StorageCommand(string, string2, object, date, n, l, this.transCoder);
            short s = storageCommand.request(schoonerSockIO);
            boolean bl = storageCommand.response(schoonerSockIO, s);
            return bl;
        }
        catch (IOException iOException) {
            block21: {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, iOException, string2);
                }
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on set");
                    log.error(iOException.getMessage(), (Throwable)iOException);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    if (!log.isErrorEnabled()) break block21;
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return false;
    }

    @Override
    public void setTransCoder(TransCoder transCoder) {
        this.transCoder = transCoder;
    }

    @Override
    public long addOrDecr(String string) {
        return this.addOrDecr(string, 0L, null);
    }

    @Override
    public long addOrDecr(String string, long l) {
        return this.addOrDecr(string, l, null);
    }

    @Override
    public long addOrDecr(String string, long l, Integer n) {
        boolean bl = this.add(string, (Object)("" + l), n);
        if (bl) {
            return l;
        }
        return this.incrdecr("decr", string, l, n);
    }

    @Override
    public long addOrIncr(String string) {
        return this.addOrIncr(string, 0L, null);
    }

    @Override
    public long addOrIncr(String string, long l) {
        return this.addOrIncr(string, l, null);
    }

    @Override
    public long addOrIncr(String string, long l, Integer n) {
        boolean bl = this.add(string, (Object)("" + l), n);
        if (bl) {
            return l;
        }
        return this.incrdecr("incr", string, l, n);
    }

    @Override
    public long decr(String string) {
        return this.incrdecr("decr", string, 1L, null);
    }

    @Override
    public long decr(String string, long l) {
        return this.incrdecr("decr", string, l, null);
    }

    @Override
    public long decr(String string, long l, Integer n) {
        return this.incrdecr("decr", string, l, n);
    }

    @Override
    public boolean delete(String string) {
        return this.delete(string, null, null);
    }

    @Override
    public boolean delete(String string, Date date) {
        return this.delete(string, null, date);
    }

    @Override
    public boolean flushAll() {
        return this.flushAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushAll(String[] stringArray) {
        if (this.pool == null) {
            if (log.isErrorEnabled()) {
                log.error("++++ unable to get SockIOPool instance");
            }
            return false;
        }
        String[] stringArray2 = stringArray = stringArray == null ? this.pool.getServers() : stringArray;
        if (stringArray == null || stringArray.length <= 0) {
            if (log.isErrorEnabled()) {
                log.error("++++ no servers to flush");
            }
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            SchoonerSockIO schoonerSockIO = this.pool.getConnection(stringArray[i]);
            if (schoonerSockIO == null) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnFlush(this, new IOException("no socket to server available"));
                }
                if (log.isErrorEnabled()) {
                    log.error("++++ unable to get connection to : " + stringArray[i]);
                }
                bl = false;
                continue;
            }
            try {
                FlushAllCommand flushAllCommand = new FlushAllCommand();
                short s = flushAllCommand.request(schoonerSockIO);
                bl = flushAllCommand.response(schoonerSockIO, s);
                if (bl) continue;
                boolean bl2 = bl;
                return bl2;
            }
            catch (IOException iOException) {
                block18: {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnFlush(this, iOException);
                    }
                    if (log.isErrorEnabled()) {
                        log.error("++++ exception thrown while writing bytes to server on flushAll");
                        log.error(iOException.getMessage(), (Throwable)iOException);
                    }
                    try {
                        schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                    }
                    catch (Exception exception) {
                        if (!log.isErrorEnabled()) break block18;
                        log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                    }
                }
                bl = false;
                schoonerSockIO = null;
                continue;
            }
            finally {
                if (schoonerSockIO != null) {
                    schoonerSockIO.close();
                    schoonerSockIO = null;
                }
            }
        }
        return bl;
    }

    @Override
    public Object get(String string) {
        return this.get(string, null);
    }

    @Override
    public Object get(String string, Integer n) {
        return this.get((String)"get", (String)string, (Integer)n).value;
    }

    @Override
    public Map<String, Object> getMulti(String[] stringArray) {
        return this.getMulti(stringArray, null);
    }

    @Override
    public Map<String, Object> getMulti(String[] stringArray, Integer[] integerArray) {
        if (stringArray == null || stringArray.length == 0) {
            if (log.isErrorEnabled()) {
                log.error("missing keys for getMulti()");
            }
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            SchoonerSockIO schoonerSockIO;
            String string = stringArray[i];
            if (string == null) {
                if (!log.isErrorEnabled()) continue;
                log.error("null key, so skipping");
                continue;
            }
            Integer n = null;
            if (integerArray != null && integerArray.length > i) {
                n = integerArray[i];
            }
            if ((schoonerSockIO = this.pool.getSock(string, n)) == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), string);
                continue;
            }
            hashMap.put(string, this.get((String)"get", (String)string, (Integer)n).value);
            schoonerSockIO.close();
        }
        return hashMap;
    }

    @Override
    public Object[] getMultiArray(String[] stringArray) {
        return this.getMultiArray(stringArray, null);
    }

    @Override
    public Object[] getMultiArray(String[] stringArray, Integer[] integerArray) {
        Map<String, Object> map = this.getMulti(stringArray, integerArray);
        if (map == null) {
            return null;
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = map.get(stringArray[i]);
        }
        return objectArray;
    }

    @Override
    public Object[] getMultiArray(String[] stringArray, Integer[] integerArray, boolean bl) {
        Map<String, Object> map = this.getMulti(stringArray, integerArray, bl);
        if (map == null) {
            return null;
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = map.get(stringArray[i]);
        }
        return objectArray;
    }

    @Override
    public MemcachedItem gets(String string) {
        return this.gets(string, null);
    }

    @Override
    public MemcachedItem gets(String string, Integer n) {
        return this.get("gets", string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemcachedItem get(String string, String string2, Integer n) {
        MemcachedItem memcachedItem = new MemcachedItem();
        if (string2 == null) {
            if (log.isErrorEnabled()) {
                log.error("key is null for get()");
            }
            return memcachedItem;
        }
        try {
            string2 = this.sanitizeKey(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)unsupportedEncodingException, string2);
            }
            if (log.isErrorEnabled()) {
                log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            }
            return null;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string2, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), string2);
            }
            return memcachedItem;
        }
        RetrievalCommand retrievalCommand = new RetrievalCommand(string, string2);
        try {
            short s = retrievalCommand.request(schoonerSockIO);
            MemcachedItem memcachedItem2 = retrievalCommand.response(schoonerSockIO, this.transCoder, s);
            return memcachedItem2;
        }
        catch (IOException iOException) {
            block16: {
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    if (!log.isErrorEnabled()) break block16;
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return memcachedItem;
    }

    @Override
    public long incr(String string) {
        return this.incrdecr("incr", string, 1L, null);
    }

    @Override
    public long incr(String string, long l) {
        return this.incrdecr("incr", string, l, null);
    }

    @Override
    public long incr(String string, long l, Integer n) {
        return this.incrdecr("incr", string, l, n);
    }

    @Override
    public boolean keyExists(String string) {
        return this.get(string, null) != null;
    }

    @Override
    public Map<String, Map<String, String>> stats() {
        return this.stats(null);
    }

    @Override
    public Map<String, Map<String, String>> stats(String[] stringArray) {
        return this.stats(stringArray, "stats\r\n", "STAT");
    }

    @Override
    public Map<String, Map<String, String>> statsCacheDump(int n, int n2) {
        return this.statsCacheDump(null, n, n2);
    }

    @Override
    public Map<String, Map<String, String>> statsCacheDump(String[] stringArray, int n, int n2) {
        return this.stats(stringArray, String.format("stats cachedump %d %d\r\n", n, n2), "ITEM");
    }

    @Override
    public Map<String, Map<String, String>> statsItems() {
        return this.statsItems(null);
    }

    @Override
    public Map<String, Map<String, String>> statsItems(String[] stringArray) {
        return this.stats(stringArray, "stats items\r\n", "STAT");
    }

    @Override
    public Map<String, Map<String, String>> statsSlabs() {
        return this.statsSlabs(null);
    }

    @Override
    public Map<String, Map<String, String>> statsSlabs(String[] stringArray) {
        return this.stats(stringArray, "stats slabs\r\n", "STAT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sync(String string, Integer n) {
        if (string == null) {
            if (log.isErrorEnabled()) {
                log.error("null value for key passed to delete()");
            }
            return false;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string, n);
        if (schoonerSockIO == null) {
            return false;
        }
        try {
            SyncCommand syncCommand = new SyncCommand(string, n);
            short s = syncCommand.request(schoonerSockIO);
            boolean bl = syncCommand.response(schoonerSockIO, s);
            return bl;
        }
        catch (IOException iOException) {
            block12: {
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on delete");
                    log.error(iOException.getMessage(), (Throwable)iOException);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    if (!log.isErrorEnabled()) break block12;
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return false;
    }

    @Override
    public boolean sync(String string) {
        return this.sync(string, null);
    }

    @Override
    public boolean syncAll() {
        return this.syncAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean syncAll(String[] stringArray) {
        if (this.pool == null) {
            if (log.isErrorEnabled()) {
                log.error("++++ unable to get SockIOPool instance");
            }
            return false;
        }
        String[] stringArray2 = stringArray = stringArray == null ? this.pool.getServers() : stringArray;
        if (stringArray == null || stringArray.length <= 0) {
            if (log.isErrorEnabled()) {
                log.error("++++ no servers to sync");
            }
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            SchoonerSockIO schoonerSockIO = this.pool.getConnection(stringArray[i]);
            if (schoonerSockIO == null) {
                if (log.isErrorEnabled()) {
                    log.error("++++ unable to get connection to : " + stringArray[i]);
                }
                bl = false;
                continue;
            }
            try {
                SyncAllCommand syncAllCommand = new SyncAllCommand();
                short s = syncAllCommand.request(schoonerSockIO);
                bl = syncAllCommand.response(schoonerSockIO, s);
                if (bl) continue;
                boolean bl2 = false;
                return bl2;
            }
            catch (IOException iOException) {
                block16: {
                    if (log.isErrorEnabled()) {
                        log.error("++++ exceptionthrown while writing bytes to server on flushAll");
                        log.error(iOException.getMessage(), (Throwable)iOException);
                    }
                    try {
                        schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                    }
                    catch (Exception exception) {
                        if (!log.isErrorEnabled()) break block16;
                        log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                    }
                }
                bl = false;
                schoonerSockIO = null;
                continue;
            }
            finally {
                if (schoonerSockIO != null) {
                    schoonerSockIO.close();
                    schoonerSockIO = null;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String string, Integer n, Date date) {
        if (string == null) {
            if (log.isErrorEnabled()) {
                log.error("null value for key passed to delete()");
            }
            return false;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, new IOException("no socket to server available"), string);
            }
            return false;
        }
        try {
            DeletionCommand deletionCommand = new DeletionCommand(string, n, date);
            short s = deletionCommand.request(schoonerSockIO);
            boolean bl = deletionCommand.response(schoonerSockIO, s);
            return bl;
        }
        catch (IOException iOException) {
            block14: {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnDelete(this, iOException, string);
                }
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on delete");
                    log.error(iOException.getMessage(), (Throwable)iOException);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    if (!log.isErrorEnabled()) break block14;
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrdecr(String string, String string2, long l, Integer n) {
        if (string2 == null) {
            if (log.isErrorEnabled()) {
                log.error("null key for incrdecr()");
            }
            return -1L;
        }
        try {
            string2 = this.sanitizeKey(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)unsupportedEncodingException, string2);
            }
            if (log.isErrorEnabled()) {
                log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            }
            return -1L;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string2, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), string2);
            }
            return -1L;
        }
        try {
            IncrdecrCommand incrdecrCommand = new IncrdecrCommand(string, string2, l, n);
            short s = incrdecrCommand.request(schoonerSockIO);
            if (incrdecrCommand.response(schoonerSockIO, s)) {
                long l2 = incrdecrCommand.getResult();
                return l2;
            }
            long l3 = -1L;
            return l3;
        }
        catch (IOException iOException) {
            block20: {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)iOException, string2);
                }
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on incr/decr");
                    log.error(iOException.getMessage(), (Throwable)iOException);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    if (!log.isErrorEnabled()) break block20;
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> stats(String[] stringArray, String string, String string2) {
        if (string == null || string.trim().equals("")) {
            if (log.isErrorEnabled()) {
                log.error("++++ invalid / missing command for stats()");
            }
            return null;
        }
        String[] stringArray2 = stringArray = stringArray == null ? this.pool.getServers() : stringArray;
        if (stringArray == null || stringArray.length <= 0) {
            if (log.isErrorEnabled()) {
                log.error("++++ no servers to check stats");
            }
            return null;
        }
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        for (int i = 0; i < stringArray.length; ++i) {
            SchoonerSockIO schoonerSockIO = this.pool.getConnection(stringArray[i]);
            if (schoonerSockIO == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnStats(this, new IOException("no socket to server available"));
                continue;
            }
            try {
                StatsCommand statsCommand = new StatsCommand(string, string2);
                short s = statsCommand.request(schoonerSockIO);
                Map<String, String> map = statsCommand.response(schoonerSockIO, s);
                hashMap.put(stringArray[i], map);
                continue;
            }
            catch (IOException iOException) {
                block16: {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnStats(this, iOException);
                    }
                    if (log.isErrorEnabled()) {
                        log.error("++++ exception thrown while writing bytes to server on stats");
                        log.error(iOException.getMessage(), (Throwable)iOException);
                    }
                    try {
                        schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                    }
                    catch (Exception exception) {
                        if (!log.isErrorEnabled()) break block16;
                        log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                    }
                }
                schoonerSockIO = null;
                continue;
            }
            finally {
                if (schoonerSockIO != null) {
                    schoonerSockIO.close();
                    schoonerSockIO = null;
                }
            }
        }
        return hashMap;
    }

    @Override
    public void setDefaultEncoding(String string) {
        this.defaultEncoding = string;
    }

    @Override
    public void setPrimitiveAsString(boolean bl) {
        this.primitiveAsString = bl;
    }

    @Override
    public void setSanitizeKeys(boolean bl) {
        this.sanitizeKeys = bl;
    }

    private String sanitizeKey(String string) throws UnsupportedEncodingException {
        return this.sanitizeKeys ? URLEncoder.encode(string, "UTF-8") : string;
    }

    @Override
    public Object get(String string, Integer n, boolean bl) {
        return this.get((String)"get", (String)string, (Integer)n).value;
    }

    @Override
    public Map<String, Object> getMulti(String[] stringArray, Integer[] integerArray, boolean bl) {
        return this.getMulti(stringArray, integerArray);
    }
}

