/*
 * Decompiled with CFR 0.152.
 */
package com.wirequery.core.query;

import com.wirequery.core.query.QueryParser;
import com.wirequery.core.query.context.Query;
import com.wirequery.core.query.context.QueryHead;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u0015\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0006J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00192\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/wirequery/core/query/QueryParser;", "", "()V", "createAppHead", "Lcom/wirequery/core/query/context/QueryHead;", "value", "", "createQueryWithAggregatorOperation", "Lcom/wirequery/core/query/context/Query;", "queryHead", "operations", "", "Lcom/wirequery/core/query/context/Query$Operation;", "createQueryWithoutAggregatorOperation", "errorIfNonBlankString", "", "name", "checkAlreadySet", "isAggregatorOperation", "", "operation", "isStreamOperation", "parse", "expression", "splitExpressionIntoStreamParts", "Lkotlin/sequences/Sequence;", "streamPartToOperation", "Companion", "wirequery-java-core"})
public final class QueryParser {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    private static final Regex QUERY_PARTS_PATTERN = new Regex("(([^'\"|](\\|\\|)?)*('([^'\\\\]|[\\\\].)*'|\"([^\"\\\\]|[\\\\].)*\")*)*");
    @Deprecated
    @NotNull
    private static final List<String> METHODS;
    @Deprecated
    @NotNull
    private static final List<String> STREAM_OPERATIONS;
    @Deprecated
    @NotNull
    private static final List<String> AGGREGATOR_OPERATIONS;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Query parse(@NotNull String expression) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        List streamParts = SequencesKt.toList(this.splitExpressionIntoStreamParts(expression));
        QueryHead appHead = this.createAppHead((String)CollectionsKt.first((List)streamParts));
        Iterable $this$mapNotNull$iv = CollectionsKt.drop((Iterable)streamParts, (int)1);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Query.Operation it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.streamPartToOperation(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List operations = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (this.isAggregatorOperation((Query.Operation)CollectionsKt.lastOrNull((List)operations))) {
            return this.createQueryWithAggregatorOperation(appHead, operations);
        }
        return this.createQueryWithoutAggregatorOperation(appHead, operations);
    }

    private final Sequence<String> splitExpressionIntoStreamParts(String expression) {
        return SequencesKt.map((Sequence)Regex.findAll$default((Regex)QUERY_PARTS_PATTERN, (CharSequence)expression, (int)0, (int)2, null), (Function1)splitExpressionIntoStreamParts.1.INSTANCE);
    }

    private final QueryHead createAppHead(String value) {
        String method = null;
        method = "";
        String path = null;
        path = "";
        String statusCode = null;
        statusCode = "";
        String[] stringArray = new String[]{" "};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Unit it;
            Object object;
            String part = (String)element$iv;
            boolean bl = false;
            if (METHODS.contains(part)) {
                this.errorIfNonBlankString("Method", method);
                it = object = Unit.INSTANCE;
                boolean bl2 = false;
                method = part;
                continue;
            }
            if (StringsKt.startsWith$default((String)part, (String)"/", (boolean)false, (int)2, null)) {
                this.errorIfNonBlankString("Path", path);
                it = object = Unit.INSTANCE;
                boolean bl3 = false;
                path = part;
                continue;
            }
            object = part;
            if (!new Regex("[0-9x]{3}").matches((CharSequence)object)) continue;
            this.errorIfNonBlankString("Status code", statusCode);
            it = object = Unit.INSTANCE;
            boolean bl4 = false;
            statusCode = part;
        }
        return new QueryHead(method, path, statusCode);
    }

    private final void errorIfNonBlankString(String name, String checkAlreadySet) {
        if (!StringsKt.isBlank((CharSequence)checkAlreadySet)) {
            throw new IllegalStateException((name + " is already set").toString());
        }
    }

    private final Query.Operation streamPartToOperation(String value) {
        if (((CharSequence)value).length() == 0) {
            return null;
        }
        String[] stringArray = new String[]{" "};
        List it = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)value)).toString(), (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        boolean bl = false;
        return new Query.Operation((String)it.get(0), (String)CollectionsKt.getOrNull((List)it, (int)1));
    }

    private final Query createQueryWithAggregatorOperation(QueryHead queryHead, List<Query.Operation> operations) {
        List streamOperations = CollectionsKt.dropLast(operations, (int)1);
        Iterable $this$forEach$iv = streamOperations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Query.Operation it = (Query.Operation)element$iv;
            boolean bl = false;
            if (this.isStreamOperation(it)) continue;
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return new Query(queryHead, streamOperations, (Query.Operation)CollectionsKt.last(operations));
    }

    private final Query createQueryWithoutAggregatorOperation(QueryHead queryHead, List<Query.Operation> operations) {
        Iterable $this$forEach$iv = operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Query.Operation it = (Query.Operation)element$iv;
            boolean bl = false;
            if (this.isStreamOperation(it)) continue;
            throw new IllegalStateException((it.getName() + " is not a known stream operation").toString());
        }
        return new Query(queryHead, operations, null);
    }

    private final boolean isAggregatorOperation(Query.Operation operation) {
        return operation != null && AGGREGATOR_OPERATIONS.contains(operation.getName());
    }

    private final boolean isStreamOperation(Query.Operation operation) {
        return operation != null && STREAM_OPERATIONS.contains(operation.getName());
    }

    static {
        Object[] objectArray = new String[]{"GET", "POST", "PUT", "HEAD", "DELETE", "PATCH", "OPTIONS", "CONNECT", "TRACE"};
        METHODS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"map", "flatMap", "filter"};
        STREAM_OPERATIONS = CollectionsKt.listOf((Object[])objectArray);
        AGGREGATOR_OPERATIONS = CollectionsKt.listOf((Object)"distinct");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/wirequery/core/query/QueryParser$Companion;", "", "()V", "AGGREGATOR_OPERATIONS", "", "", "getAGGREGATOR_OPERATIONS", "()Ljava/util/List;", "METHODS", "getMETHODS", "QUERY_PARTS_PATTERN", "Lkotlin/text/Regex;", "getQUERY_PARTS_PATTERN", "()Lkotlin/text/Regex;", "STREAM_OPERATIONS", "getSTREAM_OPERATIONS", "wirequery-java-core"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getQUERY_PARTS_PATTERN() {
            return QUERY_PARTS_PATTERN;
        }

        @NotNull
        public final List<String> getMETHODS() {
            return METHODS;
        }

        @NotNull
        public final List<String> getSTREAM_OPERATIONS() {
            return STREAM_OPERATIONS;
        }

        @NotNull
        public final List<String> getAGGREGATOR_OPERATIONS() {
            return AGGREGATOR_OPERATIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

