/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.preprocessor;

import dev.jorel.commandapi.preprocessor.RequireField;
import dev.jorel.commandapi.preprocessor.RequireFields;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.tools.Diagnostic;

public class Preprocessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(RequireField.class.getCanonicalName(), RequireFields.class.getCanonicalName()));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(RequireField.class)) {
            this.processRequireField(element.getAnnotation(RequireField.class));
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(RequireFields.class)) {
            for (RequireField requireField : element.getAnnotation(RequireFields.class).value()) {
                this.processRequireField(requireField);
            }
        }
        return true;
    }

    private Class<?> fromMirror(MirroredTypeException e) {
        if (e.getTypeMirror().getKind().isPrimitive()) {
            return switch (e.getTypeMirror().toString()) {
                case "void" -> Void.TYPE;
                case "boolean" -> Boolean.TYPE;
                case "char" -> Character.TYPE;
                case "byte" -> Byte.TYPE;
                case "short" -> Short.TYPE;
                case "int" -> Integer.TYPE;
                case "long" -> Long.TYPE;
                case "float" -> Float.TYPE;
                case "double" -> Double.TYPE;
                default -> throw new IllegalArgumentException("Unexpected value: " + e.getTypeMirror().toString());
            };
        }
        try {
            return Class.forName(e.getTypeMirror().toString(), false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
    }

    private void processRequireField(RequireField field) {
        Field classField;
        Class<?> type;
        Class<?> in;
        try {
            in = field.in();
        }
        catch (MirroredTypeException e) {
            in = this.fromMirror(e);
        }
        try {
            type = field.ofType();
        }
        catch (MirroredTypeException e) {
            type = this.fromMirror(e);
        }
        try {
            classField = in.getDeclaredField(field.name());
        }
        catch (NoSuchFieldException | SecurityException e) {
            String message = String.format("Field: %s %s.%s does not exist", type.getSimpleName(), in.getSimpleName(), field.name());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
            return;
        }
        catch (NullPointerException e) {
            String message = String.format("Field: %s ??.%s does not exist. The class for this field is also missing!", type.getSimpleName(), field.name());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
            return;
        }
        if (!classField.getType().getCanonicalName().equals(type.getCanonicalName())) {
            String message = String.format("Field: %s %s.%s does not exist. Instead found field: %s %s.%s", type.getCanonicalName(), in.getSimpleName(), field.name(), classField.getType().getCanonicalName(), in.getSimpleName(), field.name());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
        }
    }
}

