/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.game;

import dev.secondsun.game.Renderer;
import dev.secondsun.geometry.EdgeEntry;
import dev.secondsun.geometry.Model;
import dev.secondsun.geometry.Quad;
import dev.secondsun.geometry.Texture;
import dev.secondsun.geometry.Triangle;
import dev.secondsun.geometry.Vertex;
import dev.secondsun.geometry.Vertex2D;
import dev.secondsun.util.Maths;
import dev.secondsun.util.Resources;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class ScanLineEngine
implements Renderer {
    private final int screenWidth;
    private final int screenHeight;
    private List<EdgeEntry>[] edgeTable;
    boolean pause = false;
    private final Resources resources;

    public ScanLineEngine(int screenWidth, int screenHeight, Model board, Resources resources) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.edgeTable = this.createEdgeTupleTable(screenHeight);
        this.resources = resources;
    }

    private void generateEdgeList(List<Triangle> tiles) {
        this.initEdgeTable();
        tiles.forEach(triangle -> {
            float yMin = Maths.min(triangle.v1.y, triangle.v2.y, triangle.v3.y);
            float yMax = Maths.max(triangle.v1.y, triangle.v2.y, triangle.v3.y);
            float xMin = Maths.min(triangle.v1.x, triangle.v2.x, triangle.v3.x);
            float xMax = Maths.max(triangle.v1.x, triangle.v2.x, triangle.v3.x);
            if (yMax < 0.0f || yMin > (float)this.screenHeight) {
                return;
            }
            if (xMax < 0.0f || xMin > (float)this.screenWidth) {
                return;
            }
            this.storeTriangleInTable((Triangle)triangle);
        });
    }

    private List<EdgeEntry>[] createEdgeTupleTable(int i) {
        List[] edgeTupleTable = new List[i];
        for (int x = 0; x < i; ++x) {
            edgeTupleTable[x] = new ArrayList();
        }
        return edgeTupleTable;
    }

    void initEdgeTable() {
        for (int i = 0; i < this.screenHeight; ++i) {
            this.edgeTable[i] = new ArrayList<EdgeEntry>();
        }
    }

    private void storeTriangleInTable(Triangle poly) {
        int color = poly.textureId;
        if (poly.normal().z > 0.0f) {
            return;
        }
        Vertex v1 = poly.v1;
        Vertex v2 = poly.v2;
        Vertex v3 = poly.v3;
        if (v1.equals(v2) || v2.equals(v3) || v3.equals(v1)) {
            return;
        }
        ArrayList<Vertex> sorted = new ArrayList<Vertex>(List.of(v1, v2, v3));
        sorted.sort((l, r) -> {
            float result = r.y - l.y;
            if (result < 0.0f) {
                return -1;
            }
            if (result > 0.0f) {
                return 1;
            }
            return l.x - r.x < 0.0f ? -1 : 1;
        });
        Vertex first = sorted.get(0);
        Vertex second = sorted.get(1);
        Vertex third = sorted.get(2);
        int lastY = (int)Math.floor(Math.min((float)(this.screenHeight - 1), first.y));
        if (first.y != second.y) {
            lastY = this.drawTop(first, second, third, poly.center().z, color, poly);
        }
        if (third.y != second.y) {
            this.drawBottom(first, second, third, poly.center().z, color, lastY, poly);
        }
    }

    private void drawBottom(Vertex first, Vertex second, Vertex third, float zIndex, int color, int startY, Triangle poly) {
        float secondThirdSlopeInv = (second.x - third.x) / (second.y - third.y);
        float secondThirdYintercept = second.y - second.x / secondThirdSlopeInv;
        float firstThirdSlopeInv = (first.x - third.x) / (first.y - third.y);
        float firstThirdYintercept = first.y - first.x / firstThirdSlopeInv;
        int y = startY;
        while ((float)y >= Math.max(0.0f, third.y)) {
            float endX;
            float startX;
            if (second.x > first.x) {
                startX = firstThirdSlopeInv == 0.0f ? first.x : ((float)y - firstThirdYintercept) * firstThirdSlopeInv;
                endX = secondThirdSlopeInv == 0.0f ? third.x : ((float)y - secondThirdYintercept) * secondThirdSlopeInv;
            } else {
                endX = firstThirdSlopeInv == 0.0f ? first.x : ((float)y - firstThirdYintercept) * firstThirdSlopeInv;
                startX = secondThirdSlopeInv == 0.0f ? third.x : ((float)y - secondThirdYintercept) * secondThirdSlopeInv;
            }
            float diff = startX - endX;
            if (diff > 0.0f) {
                float temp = startX;
                startX = endX;
                endX = temp;
            }
            if ((double)Math.abs(diff) < 0.05) {
                endX = startX;
            }
            try {
                EdgeEntry ee = new EdgeEntry((int)Math.floor(startX), (int)Math.ceil(endX), zIndex, 0.0f, 0.0f, 0.0f, color, poly);
                this.addEdge(ee, y);
            }
            catch (RuntimeException ex) {
                System.err.println(startX + " " + endX);
                System.err.println(String.format("Poly: ,A:%s\n B:%s\n C:%s", first.toString(), second.toString(), third.toString()));
                throw ex;
            }
            --y;
        }
    }

    private void addEdge(EdgeEntry ee, int y) {
        for (EdgeEntry entry : this.edgeTable[y]) {
            if (entry.endX < ee.startX || entry.startX > ee.endX) continue;
            if (entry.startX > ee.startX && entry.endX < ee.endX) {
                EdgeEntry eeLeft = new EdgeEntry(ee.startX, entry.startX, ee.z, ee.textureVectorX, ee.textureVectorY, ee.textureVectorLength, ee.textureId, ee.triangle);
                EdgeEntry eeRight = new EdgeEntry(entry.endX, ee.endX, ee.z, ee.textureVectorX, ee.textureVectorY, ee.textureVectorLength, ee.textureId, ee.triangle);
                this.addEdge(eeLeft, y);
                this.addEdge(eeRight, y);
                return;
            }
            if (entry.startX > ee.startX && entry.endX >= ee.endX) {
                ee.endX = entry.startX;
                continue;
            }
            if (entry.startX <= ee.startX && entry.endX < ee.endX) {
                ee.startX = entry.endX;
                continue;
            }
            if (entry.startX <= ee.startX && entry.endX >= ee.endX) {
                return;
            }
            System.err.println("WTF");
        }
        this.edgeTable[y].add(ee);
    }

    private int drawTop(Vertex first, Vertex second, Vertex third, float zIndex, int color, Triangle poly) {
        int toReturn = (int)Math.floor(Math.min((float)(this.screenHeight - 1), first.y));
        float firstSecondYintercept = 0.0f;
        float firstSecondSlopeInv = (first.x - second.x) / (first.y - second.y);
        firstSecondYintercept = first.y - first.x / firstSecondSlopeInv;
        float firstThirdSlopeInv = (first.x - third.x) / (first.y - third.y);
        float firstThirdYintercept = first.y - first.x / firstThirdSlopeInv;
        int y = (int)Math.floor(Math.min((float)(this.screenHeight - 1), first.y));
        while ((float)y >= Math.max(0.0f, second.y)) {
            float endX;
            float startX;
            if (second.x > first.x) {
                startX = firstThirdSlopeInv == 0.0f ? first.x : ((float)y - firstThirdYintercept) * firstThirdSlopeInv;
                endX = firstSecondSlopeInv == 0.0f ? second.x : ((float)y - firstSecondYintercept) * firstSecondSlopeInv;
            } else {
                endX = firstThirdSlopeInv == 0.0f ? first.x : ((float)y - firstThirdYintercept) * firstThirdSlopeInv;
                startX = firstSecondSlopeInv == 0.0f ? second.x : ((float)y - firstSecondYintercept) * firstSecondSlopeInv;
            }
            float diff = startX - endX;
            if (diff > 0.0f) {
                float temp = startX;
                startX = endX;
                endX = temp;
            }
            if ((double)Math.abs(diff) < 0.05) {
                endX = startX;
            }
            EdgeEntry ee = new EdgeEntry((int)Math.floor(startX), (int)Math.ceil(endX), zIndex, 0.0f, 0.0f, 0.0f, color, poly);
            this.addEdge(ee, y);
            toReturn = y - 1;
            --y;
        }
        return toReturn;
    }

    @Override
    public BufferedImage draw(List<Triangle> tiles) {
        this.generateEdgeList(tiles);
        BufferedImage image = new BufferedImage(this.screenWidth, this.screenHeight, 1);
        for (int i = 0; i < this.screenHeight; ++i) {
            int y = this.screenHeight - i - 1;
            List<EdgeEntry> line = this.edgeTable[this.screenHeight - i - 1];
            line.sort((e1, e2) -> e1.startX - e2.startX);
            if (line.isEmpty()) continue;
            for (int x = 0; x < this.screenWidth; ++x) {
                int lineIndex = 0;
                if (line.size() == 0) continue;
                EdgeEntry entry = line.get(0);
                ++lineIndex;
                if (x < entry.startX) continue;
                while (lineIndex < line.size() && x >= line.get((int)lineIndex).startX) {
                    EdgeEntry test = line.get(lineIndex);
                    if (test.z > entry.z) {
                        entry = test;
                    }
                    ++lineIndex;
                }
                Texture text = this.resources.getTexture(entry.textureId);
                if (text != null) {
                    Vertex2D uv;
                    if (text.u() > 0) {
                        Vertex c = Maths.add(Maths.add(entry.triangle.v2, Maths.subtract(entry.triangle.v3, entry.triangle.v2)), Maths.subtract(entry.triangle.v1, entry.triangle.v2));
                        quad = new Quad(new Vertex2D(entry.triangle.v2.x, entry.triangle.v2.y), new Vertex2D(entry.triangle.v3.x, entry.triangle.v3.y), new Vertex2D(c.x, c.y), new Vertex2D(entry.triangle.v1.x, entry.triangle.v1.y));
                        uv = Maths.reverseBilinear(new Vertex2D(x, y), quad);
                    } else {
                        Vertex a = Maths.add(Maths.add(entry.triangle.v2, Maths.subtract(entry.triangle.v3, entry.triangle.v2)), Maths.subtract(entry.triangle.v1, entry.triangle.v2));
                        quad = new Quad(new Vertex2D(a.x, a.y), new Vertex2D(entry.triangle.v1.x, entry.triangle.v1.y), new Vertex2D(entry.triangle.v2.x, entry.triangle.v2.y), new Vertex2D(entry.triangle.v3.x, entry.triangle.v3.y));
                        uv = Maths.reverseBilinear(new Vertex2D(x, y), quad);
                    }
                    BufferedImage texture = this.resources.getImage(text.imageId());
                    try {
                        image.setRGB(x, i, texture.getRGB((int)Math.abs(uv.x * (float)text.u()) % text.u(), (int)Math.abs(uv.y * (float)text.v()) % text.v()));
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        image.setRGB(x, i, Color.BLACK.getRGB());
                    }
                } else {
                    image.setRGB(x, i, entry.textureId);
                }
                lineIndex = 0;
                while (lineIndex < line.size() && x >= line.get((int)lineIndex).startX) {
                    if (line.get((int)lineIndex).endX < x) {
                        line.remove(lineIndex);
                        continue;
                    }
                    ++lineIndex;
                }
            }
        }
        return image;
    }
}

