/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.xml.xpath.SecuritySupport;
import javax.xml.xpath.XPathFactory;

final class XPathFactoryFinder {
    private static boolean debug = false;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Properties cacheProps;
    private static boolean firstTime;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;
    static /* synthetic */ Class class$javax$xml$xpath$XPathFactory;

    private static void debugPrintln(String string2) {
        if (debug) {
            System.err.println("JAXP: " + string2);
        }
    }

    public XPathFactoryFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == SecuritySupport.getContextClassLoader()) {
                XPathFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            XPathFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        XPathFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public XPathFactory newFactory(String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        XPathFactory xPathFactory = this._newFactory(string2);
        if (debug) {
            if (xPathFactory != null) {
                XPathFactoryFinder.debugPrintln("factory '" + xPathFactory.getClass().getName() + "' was found for " + string2);
            } else {
                XPathFactoryFinder.debugPrintln("unable to find a factory for " + string2);
            }
        }
        return xPathFactory;
    }

    private XPathFactory _newFactory(String string2) {
        Serializable serializable2;
        Object object;
        XPathFactory xPathFactory;
        block27: {
            String string3;
            String string4;
            block26: {
                string4 = SERVICE_CLASS.getName() + ":" + string2;
                try {
                    if (debug) {
                        XPathFactoryFinder.debugPrintln("Looking up system property '" + string4 + "'");
                    }
                    if ((string3 = SecuritySupport.getSystemProperty(string4)) != null) {
                        if (debug) {
                            XPathFactoryFinder.debugPrintln("The value is '" + string3 + "'");
                        }
                        if ((xPathFactory = this.createInstance(string3)) != null) {
                            return xPathFactory;
                        }
                    } else if (debug) {
                        XPathFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (Throwable throwable) {
                    if (!debug) break block26;
                    XPathFactoryFinder.debugPrintln("failed to look up system property '" + string4 + "'");
                    throwable.printStackTrace();
                }
            }
            string3 = SecuritySupport.getSystemProperty("java.home");
            String string5 = string3 + File.separator + "lib" + File.separator + "jaxp.properties";
            String string6 = null;
            try {
                if (firstTime) {
                    object = cacheProps;
                    synchronized (object) {
                        if (firstTime) {
                            serializable2 = new File(string5);
                            firstTime = false;
                            if (SecuritySupport.doesFileExist((File)serializable2)) {
                                if (debug) {
                                    XPathFactoryFinder.debugPrintln("Read properties file " + serializable2);
                                }
                                cacheProps.load(SecuritySupport.getFileInputStream((File)serializable2));
                            }
                        }
                    }
                }
                string6 = cacheProps.getProperty(string4);
                if (debug) {
                    XPathFactoryFinder.debugPrintln("found " + string6 + " in $java.home/jaxp.properties");
                }
                if (string6 != null && (xPathFactory = this.createInstance(string6)) != null) {
                    return xPathFactory;
                }
            }
            catch (Exception exception) {
                if (!debug) break block27;
                exception.printStackTrace();
            }
        }
        object = this.createServiceFileIterator();
        while (object.hasNext()) {
            serializable2 = (URL)object.next();
            if (debug) {
                XPathFactoryFinder.debugPrintln("looking into " + serializable2);
            }
            try {
                xPathFactory = this.loadFromServicesFile(string2, ((URL)serializable2).toExternalForm(), SecuritySupport.getURLInputStream((URL)serializable2));
                if (xPathFactory == null) continue;
                return xPathFactory;
            }
            catch (IOException iOException) {
                if (!debug) continue;
                XPathFactoryFinder.debugPrintln("failed to read " + serializable2);
                iOException.printStackTrace();
            }
        }
        if (string2.equals("http://java.sun.com/jaxp/xpath/dom")) {
            if (debug) {
                XPathFactoryFinder.debugPrintln("attempting to use the platform default W3C DOM XPath lib");
            }
            return this.createInstance("org.apache.xpath.jaxp.XPathFactoryImpl");
        }
        if (debug) {
            XPathFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        }
        return null;
    }

    private XPathFactory createInstance(String string2) {
        block6: {
            try {
                Object obj;
                if (debug) {
                    XPathFactoryFinder.debugPrintln("instanciating " + string2);
                }
                Class<?> clazz = this.classLoader != null ? this.classLoader.loadClass(string2) : Class.forName(string2);
                if (debug) {
                    XPathFactoryFinder.debugPrintln("loaded it from " + XPathFactoryFinder.which(clazz));
                }
                if ((obj = clazz.newInstance()) instanceof XPathFactory) {
                    return (XPathFactory)obj;
                }
                if (debug) {
                    XPathFactoryFinder.debugPrintln(string2 + " is not assignable to " + SERVICE_CLASS.getName());
                }
            }
            catch (Throwable throwable) {
                if (!debug) break block6;
                XPathFactoryFinder.debugPrintln("failed to instanciate " + string2);
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private XPathFactory loadFromServicesFile(String string2, String string3, InputStream inputStream) {
        BufferedReader bufferedReader;
        if (debug) {
            XPathFactoryFinder.debugPrintln("Reading " + string3);
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 80);
        }
        String string4 = null;
        XPathFactory xPathFactory = null;
        while (true) {
            try {
                string4 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                break;
            }
            if (string4 == null) break;
            int n = string4.indexOf(35);
            if (n != -1) {
                string4 = string4.substring(0, n);
            }
            if ((string4 = string4.trim()).length() == 0) continue;
            try {
                XPathFactory xPathFactory2 = this.createInstance(string4);
                if (!xPathFactory2.isObjectModelSupported(string2)) continue;
                xPathFactory = xPathFactory2;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return xPathFactory;
    }

    private Iterator createServiceFileIterator() {
        if (this.classLoader == null) {
            return new SingleIterator(){
                static /* synthetic */ Class class$javax$xml$xpath$XPathFactoryFinder;

                protected Object value() {
                    ClassLoader classLoader = (class$javax$xml$xpath$XPathFactoryFinder == null ? (class$javax$xml$xpath$XPathFactoryFinder = 1.class$("javax.xml.xpath.XPathFactoryFinder")) : class$javax$xml$xpath$XPathFactoryFinder).getClassLoader();
                    return SecuritySupport.getResourceAsURL(classLoader, SERVICE_ID);
                }

                static /* synthetic */ Class class$(String string2) {
                    try {
                        return Class.forName(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            };
        }
        try {
            final Enumeration enumeration = SecuritySupport.getResources(this.classLoader, SERVICE_ID);
            if (debug && !enumeration.hasMoreElements()) {
                XPathFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return new Iterator(){

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return enumeration.hasMoreElements();
                }

                public Object next() {
                    return enumeration.nextElement();
                }
            };
        }
        catch (IOException iOException) {
            if (debug) {
                XPathFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
                iOException.printStackTrace();
            }
            return ((AbstractList)new ArrayList()).iterator();
        }
    }

    private static String which(Class clazz) {
        return XPathFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String string2, ClassLoader classLoader) {
        URL uRL;
        String string3 = string2.replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((uRL = SecuritySupport.getResourceAsURL(classLoader, string3)) != null) {
            return uRL.toString();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string2 = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = string2 != null && !"false".equals(string2);
        }
        catch (Exception exception) {
            debug = false;
        }
        cacheProps = new Properties();
        firstTime = true;
        SERVICE_CLASS = class$javax$xml$xpath$XPathFactory == null ? (class$javax$xml$xpath$XPathFactory = XPathFactoryFinder.class$("javax.xml.xpath.XPathFactory")) : class$javax$xml$xpath$XPathFactory;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }

    private static abstract class SingleIterator
    implements Iterator {
        private boolean seen = false;

        private SingleIterator() {
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final boolean hasNext() {
            return !this.seen;
        }

        public final Object next() {
            if (this.seen) {
                throw new NoSuchElementException();
            }
            this.seen = true;
            return this.value();
        }

        protected abstract Object value();
    }
}

