/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.accessibility.fo;

import java.util.Stack;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.accessibility.fo.FOEventRecorder;
import org.apache.fop.accessibility.fo.StructureTreeEventTrigger;
import org.apache.fop.fo.DelegatingFOEventHandler;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.extensions.ExternalDocument;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.fo.flow.PageNumberCitationLast;
import org.apache.fop.fo.flow.Wrapper;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.xml.sax.SAXException;

public class FO2StructureTreeConverter
extends DelegatingFOEventHandler {
    private FOEventHandler converter;
    private final Stack<FOEventHandler> converters = new Stack();
    private final Stack<FOEventRecorder> tableFooterRecorders = new Stack();
    private final FOEventHandler structureTreeEventTrigger;
    private final FOEventHandler eventSwallower = new FOEventHandler(){};

    public FO2StructureTreeConverter(StructureTreeEventHandler structureTreeEventHandler, FOEventHandler delegate) {
        super(delegate);
        this.converter = this.structureTreeEventTrigger = new StructureTreeEventTrigger(structureTreeEventHandler);
    }

    public void startDocument() throws SAXException {
        this.converter.startDocument();
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.converter.endDocument();
        super.endDocument();
    }

    public void startRoot(Root root2) {
        this.converter.startRoot(root2);
        super.startRoot(root2);
    }

    public void endRoot(Root root2) {
        this.converter.endRoot(root2);
        super.endRoot(root2);
    }

    public void startPageSequence(PageSequence pageSeq) {
        this.converter.startPageSequence(pageSeq);
        super.startPageSequence(pageSeq);
    }

    public void endPageSequence(PageSequence pageSeq) {
        this.converter.endPageSequence(pageSeq);
        super.endPageSequence(pageSeq);
    }

    public void startPageNumber(PageNumber pagenum) {
        this.converter.startPageNumber(pagenum);
        super.startPageNumber(pagenum);
    }

    public void endPageNumber(PageNumber pagenum) {
        this.converter.endPageNumber(pagenum);
        super.endPageNumber(pagenum);
    }

    public void startPageNumberCitation(PageNumberCitation pageCite) {
        this.converter.startPageNumberCitation(pageCite);
        super.startPageNumberCitation(pageCite);
    }

    public void endPageNumberCitation(PageNumberCitation pageCite) {
        this.converter.endPageNumberCitation(pageCite);
        super.endPageNumberCitation(pageCite);
    }

    public void startPageNumberCitationLast(PageNumberCitationLast pageLast) {
        this.converter.startPageNumberCitationLast(pageLast);
        super.startPageNumberCitationLast(pageLast);
    }

    public void endPageNumberCitationLast(PageNumberCitationLast pageLast) {
        this.converter.endPageNumberCitationLast(pageLast);
        super.endPageNumberCitationLast(pageLast);
    }

    public void startFlow(Flow fl) {
        this.converter.startFlow(fl);
        super.startFlow(fl);
    }

    public void endFlow(Flow fl) {
        this.converter.endFlow(fl);
        super.endFlow(fl);
    }

    public void startBlock(Block bl) {
        this.converter.startBlock(bl);
        super.startBlock(bl);
    }

    public void endBlock(Block bl) {
        this.converter.endBlock(bl);
        super.endBlock(bl);
    }

    public void startBlockContainer(BlockContainer blc) {
        this.converter.startBlockContainer(blc);
        super.startBlockContainer(blc);
    }

    public void endBlockContainer(BlockContainer blc) {
        this.converter.endBlockContainer(blc);
        super.endBlockContainer(blc);
    }

    public void startInline(Inline inl) {
        this.converter.startInline(inl);
        super.startInline(inl);
    }

    public void endInline(Inline inl) {
        this.converter.endInline(inl);
        super.endInline(inl);
    }

    public void startTable(Table tbl) {
        this.converter.startTable(tbl);
        this.tableFooterRecorders.push(null);
        super.startTable(tbl);
    }

    public void endTable(Table tbl) {
        FOEventRecorder tableFooterRecorder = this.tableFooterRecorders.pop();
        if (tableFooterRecorder != null) {
            tableFooterRecorder.replay(this.converter);
        }
        this.converter.endTable(tbl);
        super.endTable(tbl);
    }

    public void startColumn(TableColumn tc) {
        this.converter.startColumn(tc);
        super.startColumn(tc);
    }

    public void endColumn(TableColumn tc) {
        this.converter.endColumn(tc);
        super.endColumn(tc);
    }

    public void startHeader(TableHeader header) {
        this.converter.startHeader(header);
        super.startHeader(header);
    }

    public void endHeader(TableHeader header) {
        this.converter.endHeader(header);
        super.endHeader(header);
    }

    public void startFooter(TableFooter footer) {
        this.converters.push(this.converter);
        this.converter = new FOEventRecorder();
        this.converter.startFooter(footer);
        super.startFooter(footer);
    }

    public void endFooter(TableFooter footer) {
        this.converter.endFooter(footer);
        this.tableFooterRecorders.pop();
        this.tableFooterRecorders.push((FOEventRecorder)this.converter);
        this.converter = this.converters.pop();
        super.endFooter(footer);
    }

    public void startBody(TableBody body2) {
        this.converter.startBody(body2);
        super.startBody(body2);
    }

    public void endBody(TableBody body2) {
        this.converter.endBody(body2);
        super.endBody(body2);
    }

    public void startRow(TableRow tr) {
        this.converter.startRow(tr);
        super.startRow(tr);
    }

    public void endRow(TableRow tr) {
        this.converter.endRow(tr);
        super.endRow(tr);
    }

    public void startCell(TableCell tc) {
        this.converter.startCell(tc);
        super.startCell(tc);
    }

    public void endCell(TableCell tc) {
        this.converter.endCell(tc);
        super.endCell(tc);
    }

    public void startList(ListBlock lb) {
        this.converter.startList(lb);
        super.startList(lb);
    }

    public void endList(ListBlock lb) {
        this.converter.endList(lb);
        super.endList(lb);
    }

    public void startListItem(ListItem li) {
        this.converter.startListItem(li);
        super.startListItem(li);
    }

    public void endListItem(ListItem li) {
        this.converter.endListItem(li);
        super.endListItem(li);
    }

    public void startListLabel(ListItemLabel listItemLabel) {
        this.converter.startListLabel(listItemLabel);
        super.startListLabel(listItemLabel);
    }

    public void endListLabel(ListItemLabel listItemLabel) {
        this.converter.endListLabel(listItemLabel);
        super.endListLabel(listItemLabel);
    }

    public void startListBody(ListItemBody listItemBody) {
        this.converter.startListBody(listItemBody);
        super.startListBody(listItemBody);
    }

    public void endListBody(ListItemBody listItemBody) {
        this.converter.endListBody(listItemBody);
        super.endListBody(listItemBody);
    }

    public void startStatic(StaticContent staticContent) {
        this.handleStartArtifact(staticContent);
        this.converter.startStatic(staticContent);
        super.startStatic(staticContent);
    }

    public void endStatic(StaticContent statisContent) {
        this.converter.endStatic(statisContent);
        this.handleEndArtifact(statisContent);
        super.endStatic(statisContent);
    }

    public void startMarkup() {
        this.converter.startMarkup();
        super.startMarkup();
    }

    public void endMarkup() {
        this.converter.endMarkup();
        super.endMarkup();
    }

    public void startLink(BasicLink basicLink) {
        this.converter.startLink(basicLink);
        super.startLink(basicLink);
    }

    public void endLink(BasicLink basicLink) {
        this.converter.endLink(basicLink);
        super.endLink(basicLink);
    }

    public void image(ExternalGraphic eg) {
        this.converter.image(eg);
        super.image(eg);
    }

    public void pageRef() {
        this.converter.pageRef();
        super.pageRef();
    }

    public void startInstreamForeignObject(InstreamForeignObject ifo) {
        this.converter.startInstreamForeignObject(ifo);
        super.startInstreamForeignObject(ifo);
    }

    public void endInstreamForeignObject(InstreamForeignObject ifo) {
        this.converter.endInstreamForeignObject(ifo);
        super.endInstreamForeignObject(ifo);
    }

    public void startFootnote(Footnote footnote) {
        this.converter.startFootnote(footnote);
        super.startFootnote(footnote);
    }

    public void endFootnote(Footnote footnote) {
        this.converter.endFootnote(footnote);
        super.endFootnote(footnote);
    }

    public void startFootnoteBody(FootnoteBody body2) {
        this.converter.startFootnoteBody(body2);
        super.startFootnoteBody(body2);
    }

    public void endFootnoteBody(FootnoteBody body2) {
        this.converter.endFootnoteBody(body2);
        super.endFootnoteBody(body2);
    }

    public void startLeader(Leader l) {
        this.converters.push(this.converter);
        this.converter = this.eventSwallower;
        this.converter.startLeader(l);
        super.startLeader(l);
    }

    public void endLeader(Leader l) {
        this.converter.endLeader(l);
        this.converter = this.converters.pop();
        super.endLeader(l);
    }

    public void startWrapper(Wrapper wrapper) {
        this.handleStartArtifact(wrapper);
        this.converter.startWrapper(wrapper);
        super.startWrapper(wrapper);
    }

    public void endWrapper(Wrapper wrapper) {
        this.converter.endWrapper(wrapper);
        this.handleEndArtifact(wrapper);
        super.endWrapper(wrapper);
    }

    public void character(Character c) {
        this.converter.character(c);
        super.character(c);
    }

    public void characters(FOText foText) {
        this.converter.characters(foText);
        super.characters(foText);
    }

    public void startExternalDocument(ExternalDocument document2) {
        this.converter.startExternalDocument(document2);
        super.startExternalDocument(document2);
    }

    public void endExternalDocument(ExternalDocument document2) {
        this.converter.endExternalDocument(document2);
        super.endExternalDocument(document2);
    }

    private void handleStartArtifact(CommonAccessibilityHolder fobj) {
        if (this.isArtifact(fobj)) {
            this.converters.push(this.converter);
            this.converter = this.eventSwallower;
        }
    }

    private void handleEndArtifact(CommonAccessibilityHolder fobj) {
        if (this.isArtifact(fobj)) {
            this.converter = this.converters.pop();
        }
    }

    private boolean isArtifact(CommonAccessibilityHolder fobj) {
        CommonAccessibility accessibility = fobj.getCommonAccessibility();
        return "artifact".equalsIgnoreCase(accessibility.getRole());
    }
}

