/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.goca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.goca.AbstractGraphicsDrawingOrder;
import org.apache.fop.afp.util.BinaryUtils;

public abstract class AbstractGraphicsCoord
extends AbstractGraphicsDrawingOrder {
    protected int[] coords = null;
    protected boolean relative = false;

    public AbstractGraphicsCoord(int[] coords) {
        if (coords == null) {
            this.relative = true;
        } else {
            this.coords = coords;
        }
    }

    public AbstractGraphicsCoord(int[] coords, boolean relative) {
        this(coords);
        this.relative = relative;
    }

    public AbstractGraphicsCoord(int x, int y) {
        this(new int[]{x, y});
    }

    public AbstractGraphicsCoord(int x1, int y1, int x2, int y2) {
        this(new int[]{x1, y1, x2, y2});
    }

    public int getDataLength() {
        return 2 + (this.coords != null ? this.coords.length * 2 : 0);
    }

    int getCoordinateDataStartIndex() {
        return 2;
    }

    byte[] getData() {
        byte[] data2 = super.getData();
        if (this.coords != null) {
            this.addCoords(data2, this.getCoordinateDataStartIndex());
        }
        return data2;
    }

    public void writeToStream(OutputStream os) throws IOException {
        os.write(this.getData());
    }

    protected void addCoords(byte[] data2, int fromIndex) {
        int i = 0;
        while (i < this.coords.length) {
            byte[] coord = BinaryUtils.convert(this.coords[i], 2);
            data2[fromIndex] = coord[0];
            data2[fromIndex + 1] = coord[1];
            ++i;
            fromIndex += 2;
        }
    }

    public String toString() {
        String coordsStr = "";
        for (int i = 0; i < this.coords.length; ++i) {
            coordsStr = coordsStr + (i % 2 == 0 ? "x" : "y");
            coordsStr = coordsStr + i / 2 + "=" + this.coords[i] + ",";
        }
        coordsStr = coordsStr.substring(0, coordsStr.length() - 1);
        return this.getName() + "{" + coordsStr + "}";
    }

    protected boolean isRelative() {
        return this.relative;
    }
}

