/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.afp.util.BinaryUtils;

public class IncludePageOverlay
extends AbstractNamedAFPObject {
    private int x = 0;
    private int y = 0;
    private int orientation = 0;

    public IncludePageOverlay(String overlayName, int x, int y, int orientation) {
        super(overlayName);
        this.x = x;
        this.y = y;
        this.setOrientation(orientation);
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 90 && orientation != 180 && orientation != 270) {
            throw new IllegalArgumentException("The orientation must be one of the values 0, 90, 180, 270");
        }
        this.orientation = orientation;
    }

    public void writeToStream(OutputStream os) throws IOException {
        byte[] data2 = new byte[25];
        this.copySF(data2, (byte)-81, (byte)-40);
        byte[] len = BinaryUtils.convert(24, 2);
        data2[1] = len[0];
        data2[2] = len[1];
        byte[] xPos = BinaryUtils.convert(this.x, 3);
        data2[17] = xPos[0];
        data2[18] = xPos[1];
        data2[19] = xPos[2];
        byte[] yPos = BinaryUtils.convert(this.y, 3);
        data2[20] = yPos[0];
        data2[21] = yPos[1];
        data2[22] = yPos[2];
        switch (this.orientation) {
            case 90: {
                data2[23] = 45;
                data2[24] = 0;
                break;
            }
            case 180: {
                data2[23] = 90;
                data2[24] = 0;
                break;
            }
            case 270: {
                data2[23] = -121;
                data2[24] = 0;
                break;
            }
            default: {
                data2[23] = 0;
                data2[24] = 0;
            }
        }
        os.write(data2);
    }
}

