/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.fo.expr.PropertyException;

class PropertyTokenizer {
    static final int TOK_EOF = 0;
    static final int TOK_NCNAME = 1;
    static final int TOK_MULTIPLY = 2;
    static final int TOK_LPAR = 3;
    static final int TOK_RPAR = 4;
    static final int TOK_LITERAL = 5;
    static final int TOK_NUMBER = 6;
    static final int TOK_FUNCTION_LPAR = 7;
    static final int TOK_PLUS = 8;
    static final int TOK_MINUS = 9;
    static final int TOK_MOD = 10;
    static final int TOK_DIV = 11;
    static final int TOK_NUMERIC = 12;
    static final int TOK_COMMA = 13;
    static final int TOK_PERCENT = 14;
    static final int TOK_COLORSPEC = 15;
    static final int TOK_FLOAT = 16;
    static final int TOK_INTEGER = 17;
    protected int currentToken = 0;
    protected String currentTokenValue = null;
    protected int currentUnitLength = 0;
    private int currentTokenStartIndex = 0;
    private String expr;
    private int exprIndex = 0;
    private int exprLength;
    private static final String NAME_START_CHARS = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String NAME_CHARS = ".-0123456789";
    private static final String DIGITS = "0123456789";
    private static final String HEX_CHARS = "0123456789abcdefABCDEF";

    PropertyTokenizer(String s2) {
        this.expr = s2;
        this.exprLength = s2.length();
    }

    void next() throws PropertyException {
        this.currentTokenValue = null;
        this.currentTokenStartIndex = this.exprIndex;
        block13: while (true) {
            if (this.exprIndex >= this.exprLength) {
                this.currentToken = 0;
                return;
            }
            char c = this.expr.charAt(this.exprIndex++);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.currentTokenStartIndex = this.exprIndex;
                    continue block13;
                }
                case ',': {
                    this.currentToken = 13;
                    return;
                }
                case '+': {
                    this.currentToken = 8;
                    return;
                }
                case '-': {
                    this.currentToken = 9;
                    return;
                }
                case '(': {
                    this.currentToken = 3;
                    return;
                }
                case ')': {
                    this.currentToken = 4;
                    return;
                }
                case '\"': 
                case '\'': {
                    this.exprIndex = this.expr.indexOf(c, this.exprIndex);
                    if (this.exprIndex < 0) {
                        this.exprIndex = this.currentTokenStartIndex + 1;
                        throw new PropertyException("missing quote");
                    }
                    this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex + 1, this.exprIndex++);
                    this.currentToken = 5;
                    return;
                }
                case '*': {
                    this.currentToken = 2;
                    return;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    boolean bSawDecimal;
                    this.scanDigits();
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '.') {
                        ++this.exprIndex;
                        bSawDecimal = true;
                        if (this.exprIndex < this.exprLength && PropertyTokenizer.isDigit(this.expr.charAt(this.exprIndex))) {
                            ++this.exprIndex;
                            this.scanDigits();
                        }
                    } else {
                        bSawDecimal = false;
                    }
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '%') {
                        ++this.exprIndex;
                        this.currentToken = 14;
                    } else {
                        this.currentUnitLength = this.exprIndex;
                        this.scanName();
                        this.currentUnitLength = this.exprIndex - this.currentUnitLength;
                        this.currentToken = this.currentUnitLength > 0 ? 12 : (bSawDecimal ? 16 : 17);
                    }
                    this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
                    return;
                }
                case '.': {
                    this.nextDecimalPoint();
                    return;
                }
                case '#': {
                    this.nextColor();
                    return;
                }
            }
            break;
        }
        --this.exprIndex;
        this.scanName();
        if (this.exprIndex == this.currentTokenStartIndex) {
            throw new PropertyException("illegal character");
        }
        this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
        if (this.currentTokenValue.equals("mod")) {
            this.currentToken = 10;
            return;
        }
        if (this.currentTokenValue.equals("div")) {
            this.currentToken = 11;
            return;
        }
        this.currentToken = this.followingParen() ? 7 : 1;
    }

    private void nextDecimalPoint() throws PropertyException {
        if (this.exprIndex < this.exprLength && PropertyTokenizer.isDigit(this.expr.charAt(this.exprIndex))) {
            ++this.exprIndex;
            this.scanDigits();
            if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '%') {
                ++this.exprIndex;
                this.currentToken = 14;
            } else {
                this.currentUnitLength = this.exprIndex;
                this.scanName();
                this.currentUnitLength = this.exprIndex - this.currentUnitLength;
                this.currentToken = this.currentUnitLength > 0 ? 12 : 16;
            }
            this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
            return;
        }
        throw new PropertyException("illegal character '.'");
    }

    private void nextColor() throws PropertyException {
        if (this.exprIndex < this.exprLength) {
            ++this.exprIndex;
            this.scanHexDigits();
            int len = this.exprIndex - this.currentTokenStartIndex - 1;
            if (len % 3 == 0) {
                this.currentToken = 15;
            } else {
                this.scanRestOfName();
                this.currentToken = 1;
            }
            this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
            return;
        }
        throw new PropertyException("illegal character '#'");
    }

    private void scanName() {
        if (this.exprIndex < this.exprLength && PropertyTokenizer.isNameStartChar(this.expr.charAt(this.exprIndex))) {
            this.scanRestOfName();
        }
    }

    private void scanRestOfName() {
        while (++this.exprIndex < this.exprLength && PropertyTokenizer.isNameChar(this.expr.charAt(this.exprIndex))) {
        }
    }

    private void scanDigits() {
        while (this.exprIndex < this.exprLength && PropertyTokenizer.isDigit(this.expr.charAt(this.exprIndex))) {
            ++this.exprIndex;
        }
    }

    private void scanHexDigits() {
        while (this.exprIndex < this.exprLength && PropertyTokenizer.isHexDigit(this.expr.charAt(this.exprIndex))) {
            ++this.exprIndex;
        }
    }

    private boolean followingParen() {
        block4: for (int i = this.exprIndex; i < this.exprLength; ++i) {
            switch (this.expr.charAt(i)) {
                case '(': {
                    this.exprIndex = i + 1;
                    return true;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean isDigit(char c) {
        return DIGITS.indexOf(c) >= 0;
    }

    private static boolean isHexDigit(char c) {
        return HEX_CHARS.indexOf(c) >= 0;
    }

    private static boolean isSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private static boolean isNameStartChar(char c) {
        return NAME_START_CHARS.indexOf(c) >= 0 || c >= '\u0080';
    }

    private static boolean isNameChar(char c) {
        return NAME_START_CHARS.indexOf(c) >= 0 || NAME_CHARS.indexOf(c) >= 0 || c >= '\u0080';
    }
}

