/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import java.util.List;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;

public class CommonTextDecoration {
    private static final int UNDERLINE = 1;
    private static final int OVERLINE = 2;
    private static final int LINE_THROUGH = 4;
    private static final int BLINK = 8;
    private int decoration;
    private Color underColor;
    private Color overColor;
    private Color throughColor;

    public static CommonTextDecoration createFromPropertyList(PropertyList pList) throws PropertyException {
        return CommonTextDecoration.calcTextDecoration(pList);
    }

    private static CommonTextDecoration calcTextDecoration(PropertyList pList) throws PropertyException {
        Property textDecoProp;
        CommonTextDecoration deco = null;
        PropertyList parentList = pList.getParentPropertyList();
        if (parentList != null) {
            deco = CommonTextDecoration.calcTextDecoration(parentList);
        }
        if ((textDecoProp = pList.getExplicit(248)) != null) {
            List list2 = textDecoProp.getList();
            for (Property prop : list2) {
                FOUserAgent ua;
                int propEnum = prop.getEnum();
                FOUserAgent fOUserAgent = pList == null ? null : (ua = pList.getFObj() == null ? null : pList.getFObj().getUserAgent());
                if (propEnum == 95) {
                    if (deco != null) {
                        deco.decoration = 0;
                    }
                    return deco;
                }
                if (propEnum == 153) {
                    if (deco == null) {
                        deco = new CommonTextDecoration();
                    }
                    deco.decoration |= 1;
                    deco.underColor = pList.get(72).getColor(ua);
                    continue;
                }
                if (propEnum == 92) {
                    if (deco == null) continue;
                    deco.decoration &= 0xE;
                    deco.underColor = pList.get(72).getColor(ua);
                    continue;
                }
                if (propEnum == 103) {
                    if (deco == null) {
                        deco = new CommonTextDecoration();
                    }
                    deco.decoration |= 2;
                    deco.overColor = pList.get(72).getColor(ua);
                    continue;
                }
                if (propEnum == 91) {
                    if (deco == null) continue;
                    deco.decoration &= 0xD;
                    deco.overColor = pList.get(72).getColor(ua);
                    continue;
                }
                if (propEnum == 77) {
                    if (deco == null) {
                        deco = new CommonTextDecoration();
                    }
                    deco.decoration |= 4;
                    deco.throughColor = pList.get(72).getColor(ua);
                    continue;
                }
                if (propEnum == 90) {
                    if (deco == null) continue;
                    deco.decoration &= 0xB;
                    deco.throughColor = pList.get(72).getColor(ua);
                    continue;
                }
                if (propEnum == 17) {
                    if (deco == null) {
                        deco = new CommonTextDecoration();
                    }
                    deco.decoration |= 8;
                    continue;
                }
                if (propEnum == 86) {
                    if (deco == null) continue;
                    deco.decoration &= 7;
                    continue;
                }
                throw new PropertyException("Illegal value encountered: " + prop.getString());
            }
        }
        return deco;
    }

    public boolean hasUnderline() {
        return (this.decoration & 1) != 0;
    }

    public boolean hasOverline() {
        return (this.decoration & 2) != 0;
    }

    public boolean hasLineThrough() {
        return (this.decoration & 4) != 0;
    }

    public boolean isBlinking() {
        return (this.decoration & 8) != 0;
    }

    public Color getUnderlineColor() {
        return this.underColor;
    }

    public Color getOverlineColor() {
        return this.overColor;
    }

    public Color getLineThroughColor() {
        return this.throughColor;
    }
}

