/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFReference;

public class PDFGoToRemote
extends PDFAction {
    private PDFReference pdfFileSpec;
    private int pageReference = 0;
    private String destination = null;
    private boolean newWindow = false;

    public PDFGoToRemote(PDFFileSpec pdfFileSpec, boolean newWindow) {
        this.pdfFileSpec = pdfFileSpec.makeReference();
        this.newWindow = newWindow;
    }

    public PDFGoToRemote(PDFFileSpec pdfFileSpec, int page, boolean newWindow) {
        this(pdfFileSpec.makeReference(), page, newWindow);
    }

    public PDFGoToRemote(PDFReference pdfFileSpec, int page, boolean newWindow) {
        this.pdfFileSpec = pdfFileSpec;
        this.pageReference = page;
        this.newWindow = newWindow;
    }

    public PDFGoToRemote(PDFFileSpec pdfFileSpec, String dest, boolean newWindow) {
        this.pdfFileSpec = pdfFileSpec.makeReference();
        this.destination = dest;
        this.newWindow = newWindow;
    }

    public String getAction() {
        return this.referencePDF();
    }

    public String toPDFString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("<<\n/S /GoToR\n/F ");
        sb.append(this.pdfFileSpec.toString());
        sb.append("\n");
        if (this.destination != null) {
            sb.append("/D (").append(this.destination).append(")");
        } else {
            sb.append("/D [ ").append(this.pageReference).append(" /XYZ null null null ]");
        }
        if (this.newWindow) {
            sb.append("/NewWindow true");
        }
        sb.append("\n>>");
        return sb.toString();
    }

    protected boolean contentEquals(PDFObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PDFGoToRemote)) {
            return false;
        }
        PDFGoToRemote remote2 = (PDFGoToRemote)obj;
        if (!remote2.pdfFileSpec.toString().equals(this.pdfFileSpec.toString())) {
            return false;
        }
        if (this.destination != null ? !this.destination.equals(remote2.destination) : this.pageReference != remote2.pageReference) {
            return false;
        }
        return this.newWindow == remote2.newWindow;
    }
}

