/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.extensions.prepress;

import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.apache.xmlgraphics.util.QName;

public final class PageScale {
    public static final QName EXT_PAGE_SCALE = new QName("http://xmlgraphics.apache.org/fop/extensions", null, "scale");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");

    private PageScale() {
    }

    public static Point2D getScale(String scale) {
        double scaleY;
        double scaleX;
        String err2 = "Extension 'scale' attribute has incorrect value(s): {0}";
        if (scale == null || scale.equals("")) {
            return null;
        }
        String[] scales = WHITESPACE_PATTERN.split(scale);
        try {
            scaleX = Double.parseDouble(scales[0]);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(MessageFormat.format("Extension 'scale' attribute has incorrect value(s): {0}", scale));
        }
        switch (scales.length) {
            case 1: {
                scaleY = scaleX;
                break;
            }
            case 2: {
                try {
                    scaleY = Double.parseDouble(scales[1]);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(MessageFormat.format("Extension 'scale' attribute has incorrect value(s): {0}", scale));
                }
            }
            default: {
                throw new IllegalArgumentException("Too many arguments");
            }
        }
        if (scaleX <= 0.0 || scaleY <= 0.0) {
            throw new IllegalArgumentException(MessageFormat.format("Extension 'scale' attribute has incorrect value(s): {0}", scale));
        }
        return new Point2D.Double(scaleX, scaleY);
    }
}

