/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.gedcom4j.io.AnselMapping;
import org.gedcom4j.io.Encoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GedcomFileWriter {
    Encoding encoding;
    private boolean useLittleEndianForUnicode = true;
    public LineTerminator terminator;
    private List<String> gedcomLines;

    public GedcomFileWriter(List<String> gedcomLines) {
        this.gedcomLines = gedcomLines;
        this.setDefaultLineTerminator();
        this.setEncodingFromContent();
    }

    public void setLittleEndianForUnicode(boolean useLittleEndian) {
        this.useLittleEndianForUnicode = useLittleEndian;
        if (useLittleEndian && this.encoding == Encoding.UNICODE_BIG_ENDIAN) {
            this.encoding = Encoding.UNICODE_LITTLE_ENDIAN;
        }
        if (!useLittleEndian && this.encoding == Encoding.UNICODE_LITTLE_ENDIAN) {
            this.encoding = Encoding.UNICODE_BIG_ENDIAN;
        }
    }

    public void write(OutputStream out) throws IOException {
        block7: for (String line : this.gedcomLines) {
            switch (this.encoding) {
                case ASCII: {
                    this.writeAsciiLine(out, line);
                    continue block7;
                }
                case ANSEL: {
                    this.writeAnselLine(out, line);
                    continue block7;
                }
                case UNICODE_BIG_ENDIAN: {
                    this.writeUnicodeBigEndianLine(out, line);
                    continue block7;
                }
                case UNICODE_LITTLE_ENDIAN: {
                    this.writeUnicodeLittleEndianLine(out, line);
                    continue block7;
                }
                case UTF_8: {
                    this.writeUtf8Line(out, line);
                    continue block7;
                }
            }
            throw new IllegalStateException("Encoding " + (Object)((Object)this.encoding) + " is an unrecognized value");
        }
    }

    private void setDefaultLineTerminator() {
        this.terminator = LineTerminator.CRLF;
        String jvmLineTerm = System.getProperty("line.separator");
        if (Character.toString('\r').equals(jvmLineTerm)) {
            this.terminator = LineTerminator.CR_ONLY;
        } else if (Character.toString('\n').equals(jvmLineTerm)) {
            this.terminator = LineTerminator.LF_ONLY;
        } else if ((Character.toString('\r') + Character.toString('\n')).equals(jvmLineTerm)) {
            this.terminator = LineTerminator.CRLF;
        } else if ((Character.toString('\n') + Character.toString('\r')).equals(jvmLineTerm)) {
            this.terminator = LineTerminator.LFCR;
        }
    }

    private void setEncodingFromContent() {
        this.encoding = Encoding.ANSEL;
        for (String line : this.gedcomLines) {
            if ("1 CHAR ASCII".equals(line)) {
                this.encoding = Encoding.ASCII;
                return;
            }
            if ("1 CHAR UTF-8".equals(line)) {
                this.encoding = Encoding.UTF_8;
                return;
            }
            if (!"1 CHAR UNICODE".equals(line)) continue;
            this.encoding = this.useLittleEndianForUnicode ? Encoding.UNICODE_LITTLE_ENDIAN : Encoding.UNICODE_BIG_ENDIAN;
            return;
        }
    }

    private void writeAnselLine(OutputStream out, String line) throws IOException {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            out.write(AnselMapping.encode(c));
        }
        this.writeLineTerminator(out);
    }

    private void writeAsciiLine(OutputStream out, String line) throws IOException {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c < '\u0000' || c > '\u007f') {
                c = "?".charAt(0);
            }
            out.write(c);
        }
        this.writeLineTerminator(out);
    }

    private void writeLineTerminator(OutputStream out) throws IOException {
        block0 : switch (this.encoding) {
            case ASCII: 
            case ANSEL: 
            case UTF_8: {
                switch (this.terminator) {
                    case CR_ONLY: {
                        out.write(13);
                        break block0;
                    }
                    case LF_ONLY: {
                        out.write(10);
                        break block0;
                    }
                    case LFCR: {
                        out.write(10);
                        out.write(13);
                        break block0;
                    }
                    case CRLF: {
                        out.write(13);
                        out.write(10);
                        break block0;
                    }
                }
                throw new IllegalStateException("Terminator selection of " + (Object)((Object)this.terminator) + " is an unrecognized value");
            }
            case UNICODE_BIG_ENDIAN: {
                switch (this.terminator) {
                    case CR_ONLY: {
                        out.write(0);
                        out.write(13);
                        break block0;
                    }
                    case LF_ONLY: {
                        out.write(0);
                        out.write(10);
                        break block0;
                    }
                    case LFCR: {
                        out.write(0);
                        out.write(10);
                        out.write(0);
                        out.write(13);
                        break block0;
                    }
                    case CRLF: {
                        out.write(0);
                        out.write(13);
                        out.write(0);
                        out.write(10);
                        break block0;
                    }
                }
                throw new IllegalStateException("Terminator selection of " + (Object)((Object)this.terminator) + " is an unrecognized value");
            }
            case UNICODE_LITTLE_ENDIAN: {
                switch (this.terminator) {
                    case CR_ONLY: {
                        out.write(13);
                        out.write(0);
                        break block0;
                    }
                    case LF_ONLY: {
                        out.write(10);
                        out.write(0);
                        break block0;
                    }
                    case LFCR: {
                        out.write(10);
                        out.write(0);
                        out.write(13);
                        out.write(0);
                        break block0;
                    }
                    case CRLF: {
                        out.write(13);
                        out.write(0);
                        out.write(10);
                        out.write(0);
                        break block0;
                    }
                }
                throw new IllegalStateException("Terminator selection of " + (Object)((Object)this.terminator) + " is an unrecognized value");
            }
            default: {
                throw new IllegalStateException("Encoding " + (Object)((Object)this.encoding) + " is an unrecognized value");
            }
        }
    }

    private void writeUnicodeBigEndianLine(OutputStream out, String line) throws IOException {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            out.write(c >> 8);
            out.write(c & 0xFF);
        }
        this.writeLineTerminator(out);
    }

    private void writeUnicodeLittleEndianLine(OutputStream out, String line) throws IOException {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            out.write(c & 0xFF);
            out.write(c >> 8);
        }
        this.writeLineTerminator(out);
    }

    private void writeUtf8Line(OutputStream out, String line) throws IOException {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            out.write(c);
        }
        this.writeLineTerminator(out);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineTerminator {
        CRLF,
        LFCR,
        LF_ONLY,
        CR_ONLY;

    }
}

