/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.gedcom4j.model.Note;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.GedcomValidationException;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.NoteValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NotesValidator
extends AbstractValidator {
    private final List<Note> notes;
    private final Object parentObject;

    public NotesValidator(GedcomValidator rootValidator, Object parentObject, List<Note> notes) {
        this.rootValidator = rootValidator;
        this.parentObject = parentObject;
        this.notes = notes;
    }

    @Override
    protected void validate() {
        if (this.notes == null) {
            if (this.rootValidator.autorepair) {
                try {
                    Field f = this.parentObject.getClass().getField("notes");
                    f.set(this.parentObject, new ArrayList());
                    this.addInfo("Notes collection on " + this.parentObject.getClass().getSimpleName() + " was null - autorepaired");
                }
                catch (SecurityException e) {
                    throw new GedcomValidationException("Could not autorepair null notes collection on " + this.parentObject.getClass().getSimpleName(), e);
                }
                catch (NoSuchFieldException e) {
                    throw new GedcomValidationException("Could not autorepair null notes collection on " + this.parentObject.getClass().getSimpleName(), e);
                }
                catch (IllegalArgumentException e) {
                    throw new GedcomValidationException("Could not autorepair null notes collection on " + this.parentObject.getClass().getSimpleName(), e);
                }
                catch (IllegalAccessException e) {
                    throw new GedcomValidationException("Could not autorepair null notes collection on " + this.parentObject.getClass().getSimpleName(), e);
                }
            } else {
                this.addError("Notes collection on " + this.parentObject.getClass().getSimpleName() + " is null");
            }
        } else {
            int i = 0;
            for (Note n : this.notes) {
                new NoteValidator(this.rootValidator, ++i, n).validate();
            }
        }
    }
}

