/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class LazilyLoadedCtor {
    private static Method getter;
    private static Method setter;
    private String ctorName;
    private String className;
    private boolean sealed;
    private boolean isReplaced;

    public LazilyLoadedCtor(ScriptableObject scriptableObject, String string2, String string3, boolean bl) {
        this.className = string3;
        this.ctorName = string2;
        this.sealed = bl;
        if (getter == null) {
            Method[] methodArray = FunctionObject.getMethodList(this.getClass());
            getter = FunctionObject.findSingleMethod(methodArray, "getProperty");
            setter = FunctionObject.findSingleMethod(methodArray, "setProperty");
        }
        scriptableObject.defineProperty(string2, this, getter, setter, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(ScriptableObject scriptableObject) {
        ScriptableObject scriptableObject2 = scriptableObject;
        synchronized (scriptableObject2) {
            if (!this.isReplaced) {
                boolean bl = false;
                Class clazz = Kit.classOrNull(this.className);
                if (clazz == null) {
                    bl = true;
                } else {
                    try {
                        ScriptableObject.defineClass(scriptableObject, clazz, this.sealed);
                        this.isReplaced = true;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getTargetException();
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        bl = true;
                    }
                    catch (RhinoException rhinoException) {
                        bl = true;
                    }
                    catch (InstantiationException instantiationException) {
                        bl = true;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        bl = true;
                    }
                    catch (SecurityException securityException) {
                        bl = true;
                    }
                    catch (LinkageError linkageError) {
                        bl = true;
                    }
                }
                if (bl) {
                    scriptableObject.delete(this.ctorName);
                    return Scriptable.NOT_FOUND;
                }
            }
        }
        return scriptableObject.get(this.ctorName, (Scriptable)scriptableObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setProperty(ScriptableObject scriptableObject, Object object) {
        ScriptableObject scriptableObject2 = scriptableObject;
        synchronized (scriptableObject2) {
            this.isReplaced = true;
            return object;
        }
    }
}

