/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.optimizer.Codegen;

public class ClassCompiler {
    private String mainMethodClassName;
    private CompilerEnvirons compilerEnv;
    private Class targetExtends;
    private Class[] targetImplements;

    public ClassCompiler(CompilerEnvirons compilerEnvirons) {
        if (compilerEnvirons == null) {
            throw new IllegalArgumentException();
        }
        this.compilerEnv = compilerEnvirons;
        this.mainMethodClassName = "org.mozilla.javascript.optimizer.OptRuntime";
    }

    public void setMainMethodClass(String string2) {
        this.mainMethodClassName = string2;
    }

    public String getMainMethodClass() {
        return this.mainMethodClassName;
    }

    public CompilerEnvirons getCompilerEnv() {
        return this.compilerEnv;
    }

    public Class getTargetExtends() {
        return this.targetExtends;
    }

    public void setTargetExtends(Class clazz) {
        this.targetExtends = clazz;
    }

    public Class[] getTargetImplements() {
        return this.targetImplements == null ? null : (Class[])this.targetImplements.clone();
    }

    public void setTargetImplements(Class[] classArray) {
        this.targetImplements = classArray == null ? null : (Class[])classArray.clone();
    }

    protected String makeAuxiliaryClassName(String string2, String string3) {
        return string2 + string3;
    }

    public Object[] compileToClassFiles(String string2, String string3, int n, String string4) {
        Parser parser = new Parser(this.compilerEnv, this.compilerEnv.getErrorReporter());
        ScriptOrFnNode scriptOrFnNode = parser.parse(string2, string3, n);
        String string5 = parser.getEncodedSource();
        Class clazz = this.getTargetExtends();
        Class[] classArray = this.getTargetImplements();
        boolean bl = classArray == null && clazz == null;
        String string6 = bl ? string4 : this.makeAuxiliaryClassName(string4, "1");
        Codegen codegen = new Codegen();
        codegen.setMainMethodClass(this.mainMethodClassName);
        byte[] byArray = codegen.compileToClassFile(this.compilerEnv, string6, scriptOrFnNode, string5, false);
        if (bl) {
            return new Object[]{string6, byArray};
        }
        int n2 = scriptOrFnNode.getFunctionCount();
        ObjToIntMap objToIntMap = new ObjToIntMap(n2);
        for (int i = 0; i != n2; ++i) {
            FunctionNode functionNode = scriptOrFnNode.getFunctionNode(i);
            String string7 = functionNode.getFunctionName();
            if (string7 == null || string7.length() == 0) continue;
            objToIntMap.put(string7, functionNode.getParamCount());
        }
        if (clazz == null) {
            clazz = ScriptRuntime.ObjectClass;
        }
        byte[] byArray2 = JavaAdapter.createAdapterCode(objToIntMap, string4, clazz, classArray, string6);
        return new Object[]{string4, byArray2, string6, byArray};
    }
}

