/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.tools.debugger.ContextWindow;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.EvalWindow;
import org.mozilla.javascript.tools.debugger.FileSystemViewWrapper;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.FileWrapper;
import org.mozilla.javascript.tools.debugger.FindFunction;
import org.mozilla.javascript.tools.debugger.GuiCallback;
import org.mozilla.javascript.tools.debugger.JSInternalConsole;
import org.mozilla.javascript.tools.debugger.Menubar;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.MoreWindows;
import org.mozilla.javascript.tools.debugger.RunProxy;

public class SwingGui
extends JFrame
implements GuiCallback {
    private static final long serialVersionUID = -8217029773456711621L;
    Dim dim;
    private Runnable exitAction;
    private JDesktopPane desk;
    private ContextWindow context;
    private Menubar menubar;
    private JToolBar toolBar;
    private JSInternalConsole console;
    private EvalWindow evalWindow;
    private JSplitPane split1;
    private JLabel statusBar;
    private Hashtable toplevels = new Hashtable();
    private Hashtable fileWindows = new Hashtable();
    private FileWindow currentWindow;
    JFileChooser dlg;
    private EventQueue awtEventQueue;
    static /* synthetic */ Class class$javax$swing$JSplitPane;

    public SwingGui(Dim dim, String string2) {
        super(string2);
        this.dim = dim;
        this.init();
        dim.setGuiCallback(this);
    }

    public Menubar getMenubar() {
        return this.menubar;
    }

    public void setExitAction(Runnable runnable) {
        this.exitAction = runnable;
    }

    public JSInternalConsole getConsole() {
        return this.console;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.console.consoleTextArea.requestFocus();
            this.context.split.setDividerLocation(0.5);
            try {
                this.console.setMaximum(true);
                this.console.setSelected(true);
                this.console.show();
                this.console.consoleTextArea.requestFocus();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void addTopLevel(String string2, JFrame jFrame) {
        if (jFrame != this) {
            this.toplevels.put(string2, jFrame);
        }
    }

    private void init() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        this.menubar = new Menubar(this);
        this.setJMenuBar(this.menubar);
        this.toolBar = new JToolBar();
        String[] stringArray = new String[]{"Break (Pause)", "Go (F5)", "Step Into (F11)", "Step Over (F7)", "Step Out (F8)"};
        int n = 0;
        JButton jButton7 = jButton6 = (jButton5 = new JButton("Break"));
        jButton6.setToolTipText("Break");
        jButton6.setActionCommand("Break");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(true);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton4 = new JButton("Go");
        jButton6.setToolTipText("Go");
        jButton6.setActionCommand("Go");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(false);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton3 = new JButton("Step Into");
        jButton6.setToolTipText("Step Into");
        jButton6.setActionCommand("Step Into");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(false);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton2 = new JButton("Step Over");
        jButton6.setToolTipText("Step Over");
        jButton6.setActionCommand("Step Over");
        jButton6.setEnabled(false);
        jButton6.addActionListener(this.menubar);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton = new JButton("Step Out");
        jButton6.setToolTipText("Step Out");
        jButton6.setActionCommand("Step Out");
        jButton6.setEnabled(false);
        jButton6.addActionListener(this.menubar);
        jButton6.setToolTipText(stringArray[n++]);
        Dimension dimension = jButton2.getPreferredSize();
        jButton5.setPreferredSize(dimension);
        jButton5.setMinimumSize(dimension);
        jButton5.setMaximumSize(dimension);
        jButton5.setSize(dimension);
        jButton4.setPreferredSize(dimension);
        jButton4.setMinimumSize(dimension);
        jButton4.setMaximumSize(dimension);
        jButton3.setPreferredSize(dimension);
        jButton3.setMinimumSize(dimension);
        jButton3.setMaximumSize(dimension);
        jButton2.setPreferredSize(dimension);
        jButton2.setMinimumSize(dimension);
        jButton2.setMaximumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setMaximumSize(dimension);
        this.toolBar.add(jButton5);
        this.toolBar.add(jButton4);
        this.toolBar.add(jButton3);
        this.toolBar.add(jButton2);
        this.toolBar.add(jButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.desk = new JDesktopPane();
        this.desk.setPreferredSize(new Dimension(600, 300));
        this.desk.setMinimumSize(new Dimension(150, 50));
        this.console = new JSInternalConsole("JavaScript Console");
        this.desk.add(this.console);
        this.context = new ContextWindow(this);
        this.context.setPreferredSize(new Dimension(600, 120));
        this.context.setMinimumSize(new Dimension(50, 50));
        this.split1 = new JSplitPane(0, this.desk, this.context);
        this.split1.setOneTouchExpandable(true);
        SwingGui.setResizeWeight(this.split1, 0.66);
        jPanel.add((Component)this.split1, "Center");
        this.statusBar = new JLabel();
        this.statusBar.setText("Thread: ");
        jPanel.add((Component)this.statusBar, "South");
        try {
            this.dlg = new JFileChooser();
        }
        catch (SecurityException securityException) {
            this.dlg = new JFileChooser(new FileWrapper("."), (FileSystemView)new FileSystemViewWrapper());
        }
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                String string2;
                if (file.isDirectory()) {
                    return true;
                }
                String string3 = file.getName();
                int n = string3.lastIndexOf(46);
                return n > 0 && n < string3.length() - 1 && (string2 = string3.substring(n + 1).toLowerCase()).equals("js");
            }

            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter(fileFilter);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SwingGui.this.exit();
            }
        });
    }

    private void exit() {
        if (this.exitAction != null) {
            SwingUtilities.invokeLater(this.exitAction);
        }
        this.dim.setReturnValue(5);
    }

    FileWindow getFileWindow(String string2) {
        if (string2 == null || string2.equals("<stdin>")) {
            return null;
        }
        return (FileWindow)this.fileWindows.get(string2);
    }

    static String getShortName(String string2) {
        int n = string2.lastIndexOf(47);
        if (n < 0) {
            n = string2.lastIndexOf(92);
        }
        String string3 = string2;
        if (n >= 0 && n + 1 < string2.length()) {
            string3 = string2.substring(n + 1);
        }
        return string3;
    }

    void removeWindow(FileWindow fileWindow) {
        this.fileWindows.remove(fileWindow.getUrl());
        JMenu jMenu = this.getWindowMenu();
        int n = jMenu.getItemCount();
        JMenuItem jMenuItem = jMenu.getItem(n - 1);
        String string2 = SwingGui.getShortName(fileWindow.getUrl());
        for (int i = 5; i < n; ++i) {
            int n2;
            String string3;
            JMenuItem jMenuItem2 = jMenu.getItem(i);
            if (jMenuItem2 == null || !(string3 = jMenuItem2.getText()).substring((n2 = string3.indexOf(32)) + 1).equals(string2)) continue;
            jMenu.remove(jMenuItem2);
            if (n == 6) {
                jMenu.remove(4);
                break;
            }
            int n3 = i - 4;
            while (i < n - 1) {
                JMenuItem jMenuItem3 = jMenu.getItem(i);
                if (jMenuItem3 != null) {
                    string3 = jMenuItem3.getText();
                    if (string3.equals("More Windows...")) break;
                    n2 = string3.indexOf(32);
                    jMenuItem3.setText((char)(48 + n3) + " " + string3.substring(n2 + 1));
                    jMenuItem3.setMnemonic(48 + n3);
                    ++n3;
                }
                ++i;
            }
            if (n - 6 != 0 || jMenuItem == jMenuItem2 || !jMenuItem.getText().equals("More Windows...")) break;
            jMenu.remove(jMenuItem);
            break;
        }
        jMenu.revalidate();
    }

    void showStopLine(Dim.StackFrame stackFrame) {
        String string2 = stackFrame.getUrl();
        if (string2 == null || string2.equals("<stdin>")) {
            if (this.console.isVisible()) {
                this.console.show();
            }
        } else {
            int n = stackFrame.getLineNumber();
            FileWindow fileWindow = this.getFileWindow(string2);
            if (fileWindow != null) {
                this.setFilePosition(fileWindow, n);
            } else {
                Dim.SourceInfo sourceInfo = stackFrame.sourceInfo();
                this.createFileWindow(sourceInfo, n);
            }
        }
    }

    void createFileWindow(Dim.SourceInfo sourceInfo, int n) {
        boolean bl = true;
        String string2 = sourceInfo.url();
        FileWindow fileWindow = new FileWindow(this, sourceInfo);
        this.fileWindows.put(string2, fileWindow);
        if (n != -1) {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            try {
                fileWindow.setPosition(fileWindow.textArea.getLineStartOffset(n - 1));
            }
            catch (BadLocationException badLocationException) {
                try {
                    fileWindow.setPosition(fileWindow.textArea.getLineStartOffset(0));
                }
                catch (BadLocationException badLocationException2) {
                    fileWindow.setPosition(-1);
                }
            }
        }
        this.desk.add(fileWindow);
        if (n != -1) {
            this.currentWindow = fileWindow;
        }
        this.menubar.addFile(string2);
        fileWindow.setVisible(true);
        if (bl) {
            try {
                fileWindow.setMaximum(true);
                fileWindow.setSelected(true);
                fileWindow.moveToFront();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setFilePosition(FileWindow fileWindow, int n) {
        boolean bl = true;
        FileTextArea fileTextArea = fileWindow.textArea;
        try {
            if (n == -1) {
                fileWindow.setPosition(-1);
                if (this.currentWindow == fileWindow) {
                    this.currentWindow = null;
                }
            } else {
                int n2 = fileTextArea.getLineStartOffset(n - 1);
                if (this.currentWindow != null && this.currentWindow != fileWindow) {
                    this.currentWindow.setPosition(-1);
                }
                fileWindow.setPosition(n2);
                this.currentWindow = fileWindow;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (bl) {
            if (fileWindow.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(fileWindow);
            }
            this.desk.getDesktopManager().activateFrame(fileWindow);
            try {
                fileWindow.show();
                fileWindow.toFront();
                fileWindow.setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void enterInterruptImpl(Dim.StackFrame stackFrame, String string2, String string3) {
        this.statusBar.setText("Thread: " + string2);
        this.showStopLine(stackFrame);
        if (string3 != null) {
            MessageDialogWrapper.showMessageDialog(this, string3, "Exception in Script", 0);
        }
        this.updateEnabled(true);
        Dim.ContextData contextData = stackFrame.contextData();
        JComboBox jComboBox = this.context.context;
        Vector vector = this.context.toolTips;
        this.context.disableUpdate();
        int n = contextData.frameCount();
        jComboBox.removeAllItems();
        jComboBox.setSelectedItem(null);
        vector.removeAllElements();
        for (int i = 0; i < n; ++i) {
            Dim.StackFrame stackFrame2 = contextData.getFrame(i);
            String string4 = stackFrame2.getUrl();
            int n2 = stackFrame2.getLineNumber();
            String string5 = string4;
            if (string4.length() > 20) {
                string5 = "..." + string4.substring(string4.length() - 17);
            }
            String string6 = "\"" + string5 + "\", line " + n2;
            jComboBox.insertItemAt(string6, i);
            string6 = "\"" + string4 + "\", line " + n2;
            vector.addElement(string6);
        }
        this.context.enableUpdate();
        jComboBox.setSelectedIndex(0);
        jComboBox.setMinimumSize(new Dimension(50, jComboBox.getMinimumSize().height));
    }

    private JMenu getWindowMenu() {
        return this.menubar.getMenu(3);
    }

    private String chooseFile(String string2) {
        int n;
        this.dlg.setDialogTitle(string2);
        File file = null;
        String string3 = SecurityUtilities.getSystemProperty("user.dir");
        if (string3 != null) {
            file = new File(string3);
        }
        if (file != null) {
            this.dlg.setCurrentDirectory(file);
        }
        if ((n = this.dlg.showOpenDialog(this)) == 0) {
            try {
                String string4 = this.dlg.getSelectedFile().getCanonicalPath();
                file = this.dlg.getSelectedFile().getParentFile();
                Properties properties = System.getProperties();
                properties.put("user.dir", file.getPath());
                System.setProperties(properties);
                return string4;
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    private JInternalFrame getSelectedFrame() {
        JInternalFrame[] jInternalFrameArray = this.desk.getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (!jInternalFrameArray[i].isShowing()) continue;
            return jInternalFrameArray[i];
        }
        return jInternalFrameArray[jInternalFrameArray.length - 1];
    }

    private void updateEnabled(boolean bl) {
        int n;
        ((Menubar)this.getJMenuBar()).updateEnabled(bl);
        int n2 = this.toolBar.getComponentCount();
        for (n = 0; n < n2; ++n) {
            boolean bl2 = n == 0 ? !bl : bl;
            this.toolBar.getComponent(n).setEnabled(bl2);
        }
        if (bl) {
            this.toolBar.setEnabled(true);
            n = this.getExtendedState();
            if (n == 1) {
                this.setExtendedState(0);
            }
            this.toFront();
            this.context.enable();
        } else {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            this.context.disable();
        }
    }

    static void setResizeWeight(JSplitPane jSplitPane, double d) {
        try {
            Method method = (class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = SwingGui.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane).getMethod("setResizeWeight", Double.TYPE);
            method.invoke((Object)jSplitPane, new Double(d));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String string2) {
        String string3;
        try {
            FileReader fileReader = new FileReader(string2);
            try {
                string3 = Kit.readReader(fileReader);
            }
            finally {
                ((Reader)fileReader).close();
            }
        }
        catch (IOException iOException) {
            MessageDialogWrapper.showMessageDialog(this, iOException.getMessage(), "Error reading " + string2, 0);
            string3 = null;
        }
        return string3;
    }

    public void updateSourceText(Dim.SourceInfo sourceInfo) {
        RunProxy runProxy = new RunProxy(this, 3);
        runProxy.sourceInfo = sourceInfo;
        SwingUtilities.invokeLater(runProxy);
    }

    public void enterInterrupt(Dim.StackFrame stackFrame, String string2, String string3) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.enterInterruptImpl(stackFrame, string2, string3);
        } else {
            RunProxy runProxy = new RunProxy(this, 4);
            runProxy.lastFrame = stackFrame;
            runProxy.threadTitle = string2;
            runProxy.alertMessage = string3;
            SwingUtilities.invokeLater(runProxy);
        }
    }

    public boolean isGuiEventThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public void dispatchNextGuiEvent() throws InterruptedException {
        AWTEvent aWTEvent;
        EventQueue eventQueue = this.awtEventQueue;
        if (eventQueue == null) {
            this.awtEventQueue = eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        }
        if ((aWTEvent = eventQueue.getNextEvent()) instanceof ActiveEvent) {
            ((ActiveEvent)((Object)aWTEvent)).dispatch();
        } else {
            Object object = aWTEvent.getSource();
            if (object instanceof Component) {
                Component component = (Component)object;
                component.dispatchEvent(aWTEvent);
            } else if (object instanceof MenuComponent) {
                ((MenuComponent)object).dispatchEvent(aWTEvent);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string2 = actionEvent.getActionCommand();
        int n = -1;
        if (string2.equals("Cut") || string2.equals("Copy") || string2.equals("Paste")) {
            JInternalFrame jInternalFrame = this.getSelectedFrame();
            if (jInternalFrame != null && jInternalFrame instanceof ActionListener) {
                ((ActionListener)((Object)jInternalFrame)).actionPerformed(actionEvent);
            }
        } else if (string2.equals("Step Over")) {
            n = 0;
        } else if (string2.equals("Step Into")) {
            n = 1;
        } else if (string2.equals("Step Out")) {
            n = 2;
        } else if (string2.equals("Go")) {
            n = 3;
        } else if (string2.equals("Break")) {
            this.dim.setBreak();
        } else if (string2.equals("Exit")) {
            this.exit();
        } else if (string2.equals("Open")) {
            String string3;
            String string4 = this.chooseFile("Select a file to compile");
            if (string4 != null && (string3 = this.readFile(string4)) != null) {
                RunProxy runProxy = new RunProxy(this, 1);
                runProxy.fileName = string4;
                runProxy.text = string3;
                new Thread(runProxy).start();
            }
        } else if (string2.equals("Load")) {
            String string5;
            String string6 = this.chooseFile("Select a file to execute");
            if (string6 != null && (string5 = this.readFile(string6)) != null) {
                RunProxy runProxy = new RunProxy(this, 2);
                runProxy.fileName = string6;
                runProxy.text = string5;
                new Thread(runProxy).start();
            }
        } else if (string2.equals("More Windows...")) {
            MoreWindows moreWindows = new MoreWindows(this, this.fileWindows, "Window", "Files");
            moreWindows.showDialog(this);
        } else if (string2.equals("Console")) {
            if (this.console.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(this.console);
            }
            this.console.show();
            this.desk.getDesktopManager().activateFrame(this.console);
            this.console.consoleTextArea.requestFocus();
        } else if (!(string2.equals("Cut") || string2.equals("Copy") || string2.equals("Paste"))) {
            if (string2.equals("Go to function...")) {
                FindFunction findFunction = new FindFunction(this, "Go to function", "Function");
                findFunction.showDialog(this);
            } else if (string2.equals("Tile")) {
                JInternalFrame[] jInternalFrameArray = this.desk.getAllFrames();
                int n2 = jInternalFrameArray.length;
                int n3 = (int)Math.sqrt(n2);
                int n4 = n3;
                if (n4 * n3 < n2 && n4 * ++n3 < n2) {
                    ++n4;
                }
                Dimension dimension = this.desk.getSize();
                int n5 = dimension.width / n3;
                int n6 = dimension.height / n4;
                int n7 = 0;
                int n8 = 0;
                for (int i = 0; i < n4; ++i) {
                    int n9;
                    for (int j = 0; j < n3 && (n9 = i * n3 + j) < jInternalFrameArray.length; ++j) {
                        JInternalFrame jInternalFrame = jInternalFrameArray[n9];
                        try {
                            jInternalFrame.setIcon(false);
                            jInternalFrame.setMaximum(false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.desk.getDesktopManager().setBoundsForFrame(jInternalFrame, n7, n8, n5, n6);
                        n7 += n5;
                    }
                    n8 += n6;
                    n7 = 0;
                }
            } else if (string2.equals("Cascade")) {
                JInternalFrame[] jInternalFrameArray = this.desk.getAllFrames();
                int n10 = jInternalFrameArray.length;
                int n11 = 0;
                int n12 = 0;
                int n13 = this.desk.getHeight();
                int n14 = n13 / n10;
                if (n14 > 30) {
                    n14 = 30;
                }
                int n15 = n10 - 1;
                while (n15 >= 0) {
                    JInternalFrame jInternalFrame = jInternalFrameArray[n15];
                    try {
                        jInternalFrame.setIcon(false);
                        jInternalFrame.setMaximum(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Dimension dimension = jInternalFrame.getPreferredSize();
                    int n16 = dimension.width;
                    n13 = dimension.height;
                    this.desk.getDesktopManager().setBoundsForFrame(jInternalFrame, n12, n11, n16, n13);
                    --n15;
                    n12 += n14;
                    n11 += n14;
                }
            } else {
                FileWindow fileWindow = this.getFileWindow(string2);
                if (fileWindow != null) {
                    FileWindow fileWindow2 = fileWindow;
                    try {
                        if (fileWindow2.isIcon()) {
                            fileWindow2.setIcon(false);
                        }
                        fileWindow2.setVisible(true);
                        fileWindow2.moveToFront();
                        fileWindow2.setSelected(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (n != -1) {
            this.updateEnabled(false);
            this.dim.setReturnValue(n);
        }
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

