/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.XMLLibImpl;

class Namespace
extends IdScriptableObject {
    static final long serialVersionUID = -5765755238131301744L;
    private static final Object NAMESPACE_TAG = new Object();
    private XMLLibImpl lib;
    private String prefix;
    private String uri;
    private static final int Id_prefix = 1;
    private static final int Id_uri = 2;
    private static final int MAX_INSTANCE_ID = 2;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int MAX_PROTOTYPE_ID = 3;

    public Namespace(XMLLibImpl xMLLibImpl, String string2) {
        super(xMLLibImpl.globalScope(), xMLLibImpl.namespacePrototype);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        this.lib = xMLLibImpl;
        this.prefix = string2.length() == 0 ? "" : null;
        this.uri = string2;
    }

    public Namespace(XMLLibImpl xMLLibImpl, String string2, String string3) {
        super(xMLLibImpl.globalScope(), xMLLibImpl.namespacePrototype);
        if (string3 == null) {
            throw new IllegalArgumentException();
        }
        if (string3.length() == 0) {
            if (string2 == null) {
                throw new IllegalArgumentException();
            }
            if (string2.length() != 0) {
                throw new IllegalArgumentException();
            }
        }
        this.lib = xMLLibImpl;
        this.prefix = string2;
        this.uri = string3;
    }

    public void exportAsJSClass(boolean bl) {
        this.exportAsJSClass(3, this.lib.globalScope(), bl);
    }

    public String uri() {
        return this.uri;
    }

    public String prefix() {
        return this.prefix;
    }

    public String toString() {
        return this.uri();
    }

    public String toLocaleString() {
        return this.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Namespace)) {
            return false;
        }
        return this.equals((Namespace)object);
    }

    protected Object equivalentValues(Object object) {
        if (!(object instanceof Namespace)) {
            return Scriptable.NOT_FOUND;
        }
        boolean bl = this.equals((Namespace)object);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean equals(Namespace namespace) {
        return this.uri().equals(namespace.uri());
    }

    public String getClassName() {
        return "Namespace";
    }

    public Object getDefaultValue(Class clazz) {
        return this.uri();
    }

    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 2;
    }

    protected int findInstanceIdInfo(String string2) {
        int n;
        int n2 = 0;
        String string3 = null;
        int n3 = string2.length();
        if (n3 == 3) {
            string3 = "uri";
            n2 = 2;
        } else if (n3 == 6) {
            string3 = "prefix";
            n2 = 1;
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            n2 = 0;
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string2);
        }
        switch (n2) {
            case 1: 
            case 2: {
                n = 5;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Namespace.instanceIdInfo(n, super.getMaxInstanceId() + n2);
    }

    protected String getInstanceIdName(int n) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                return "prefix";
            }
            case 2: {
                return "uri";
            }
        }
        return super.getInstanceIdName(n);
    }

    protected Object getInstanceIdValue(int n) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                if (this.prefix == null) {
                    return Undefined.instance;
                }
                return this.prefix;
            }
            case 2: {
                return this.uri;
            }
        }
        return super.getInstanceIdValue(n);
    }

    protected int findPrototypeId(String string2) {
        int n = 0;
        String string3 = null;
        int n2 = string2.length();
        if (n2 == 8) {
            char c = string2.charAt(3);
            if (c == 'o') {
                string3 = "toSource";
                n = 3;
            } else if (c == 't') {
                string3 = "toString";
                n = 2;
            }
        } else if (n2 == 11) {
            string3 = "constructor";
            n = 1;
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            n = 0;
        }
        return n;
    }

    protected void initPrototypeId(int n) {
        String string2;
        int n2;
        switch (n) {
            case 1: {
                n2 = 2;
                string2 = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string2 = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string2 = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(NAMESPACE_TAG, n, string2, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(NAMESPACE_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return this.jsConstructor(context, scriptable2 == null, objectArray);
            }
            case 2: {
                return this.realThis(scriptable2, idFunctionObject).toString();
            }
            case 3: {
                return this.realThis(scriptable2, idFunctionObject).js_toSource();
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private Namespace realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (!(scriptable instanceof Namespace)) {
            throw Namespace.incompatibleCallError(idFunctionObject);
        }
        return (Namespace)scriptable;
    }

    private Object jsConstructor(Context context, boolean bl, Object[] objectArray) {
        if (!bl && objectArray.length == 1) {
            return this.lib.castToNamespace(context, objectArray[0]);
        }
        if (objectArray.length == 0) {
            return this.lib.constructNamespace(context);
        }
        if (objectArray.length == 1) {
            return this.lib.constructNamespace(context, objectArray[0]);
        }
        return this.lib.constructNamespace(context, objectArray[0], objectArray[1]);
    }

    private String js_toSource() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Namespace.toSourceImpl(this.prefix, this.uri, stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    static void toSourceImpl(String string2, String string3, StringBuffer stringBuffer) {
        stringBuffer.append("new Namespace(");
        if (string3.length() == 0) {
            if (!"".equals(string2)) {
                throw new IllegalArgumentException(string2);
            }
        } else {
            stringBuffer.append('\'');
            if (string2 != null) {
                stringBuffer.append(ScriptRuntime.escapeString(string2, '\''));
                stringBuffer.append("', '");
            }
            stringBuffer.append(ScriptRuntime.escapeString(string3, '\''));
            stringBuffer.append('\'');
        }
        stringBuffer.append(')');
    }
}

