/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public abstract class ExtraParameterHandler
extends BaseAnnotationHandler<GeneratedClassHolder> {
    private Class<? extends Annotation> methodAnnotationClass;
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();
    private AnnotationHelper annotationHelper;

    public ExtraParameterHandler(Class<? extends Annotation> targetClass, Class<? extends Annotation> methodAnnotationClass, ProcessingEnvironment processingEnvironment) {
        super(targetClass, processingEnvironment);
        this.methodAnnotationClass = methodAnnotationClass;
        this.annotationHelper = new AnnotationHelper(this.processingEnv);
    }

    @Override
    protected void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingMethodHasAnnotation(this.methodAnnotationClass, element, validatedElements, valid);
        this.validatorHelper.canBePutInABundle(element, valid);
    }

    @Override
    public void process(Element element, GeneratedClassHolder holder) throws Exception {
    }

    public JExpression getExtraValue(VariableElement parameter, JVar intent, JVar extras, JBlock block, JMethod annotatedMethod, GeneratedClassHolder holder) {
        return this.getExtraValue(parameter, intent, extras, block, annotatedMethod, holder.getGeneratedClass(), holder);
    }

    public JExpression getExtraValue(VariableElement parameter, JVar intent, JVar extras, JBlock block, JMethod annotatedMethod, JDefinedClass generatedClass, GeneratedClassHolder holder) {
        String parameterName = parameter.getSimpleName().toString();
        JClass parameterClass = this.codeModelHelper.typeMirrorToJClass(parameter.asType(), holder);
        String extraKey = this.getAnnotationValue(parameter);
        if (extraKey == null || extraKey.isEmpty()) {
            extraKey = parameterName;
        }
        BundleHelper bundleHelper = new BundleHelper(this.annotationHelper, parameter.asType());
        JExpression restoreMethodCall = bundleHelper.getExpressionToRestoreFromIntentOrBundle(parameterClass, intent, extras, this.getStaticExtraField(generatedClass, extraKey, holder), annotatedMethod);
        return block.decl(parameterClass, parameterName, restoreMethodCall);
    }

    private JFieldVar getStaticExtraField(JDefinedClass generatedClass, String extraName, GeneratedClassHolder holder) {
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase(null, extraName, "Extra");
        JFieldVar staticExtraField = generatedClass.fields().get(staticFieldName);
        if (staticExtraField == null) {
            staticExtraField = generatedClass.field(25, holder.classes().STRING, staticFieldName, JExpr.lit(extraName));
        }
        return staticExtraField;
    }

    public abstract String getAnnotationValue(VariableElement var1);
}

