/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.manager.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.asterisk.AsteriskVersion;
import net.sf.asterisk.manager.ActionBuilder;
import net.sf.asterisk.manager.action.ManagerAction;
import net.sf.asterisk.manager.impl.Util;
import net.sf.asterisk.util.Log;
import net.sf.asterisk.util.LogFactory;

public class ActionBuilderImpl
implements ActionBuilder {
    private static final String LINE_SEPARATOR = "\r\n";
    private final Log logger = LogFactory.getLog(this.getClass());
    private AsteriskVersion targetVersion = AsteriskVersion.ASTERISK_1_0;

    public void setTargetVersion(AsteriskVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    public String buildAction(ManagerAction action) {
        return this.buildAction(action, null);
    }

    public String buildAction(ManagerAction action, String internalActionId) {
        StringBuffer sb = new StringBuffer("action: ");
        sb.append(action.getAction());
        sb.append(LINE_SEPARATOR);
        if (internalActionId != null) {
            sb.append("actionid: ");
            sb.append(Util.addInternalActionId(action.getActionId(), internalActionId));
            sb.append(LINE_SEPARATOR);
        } else if (action.getActionId() != null) {
            sb.append("actionid: ");
            sb.append(action.getActionId());
            sb.append(LINE_SEPARATOR);
        }
        Map getters = this.getGetters(action.getClass());
        Iterator i = getters.keySet().iterator();
        while (i.hasNext()) {
            Object value;
            String name = (String)i.next();
            if ("class".equals(name) || "action".equals(name) || "actionid".equals(name)) continue;
            Method getter = (Method)getters.get(name);
            try {
                value = getter.invoke((Object)action, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                this.logger.error("Unable to retrieve property '" + name + "' of " + action.getClass(), ex);
                continue;
            }
            catch (InvocationTargetException ex) {
                this.logger.error("Unable to retrieve property '" + name + "' of " + action.getClass(), ex);
                continue;
            }
            if (value == null || value instanceof Class) continue;
            if (value instanceof Map) {
                this.appendMap(sb, name, (Map)value);
                continue;
            }
            if (value instanceof String) {
                this.appendString(sb, name, (String)value);
                continue;
            }
            this.appendString(sb, name, value.toString());
        }
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }

    private Map getGetters(Class clazz) {
        HashMap<String, Method> accessors = new HashMap<String, Method>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name;
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("get") || method.getParameterTypes().length != 0 || (name = methodName.substring("get".length()).toLowerCase()).length() == 0) continue;
            accessors.put(name, method);
        }
        return accessors;
    }

    protected void appendMap(StringBuffer sb, String key, Map values) {
        String singularKey = key.endsWith("s") ? key.substring(0, key.length() - 1) : key;
        if (this.targetVersion.isAtLeast(AsteriskVersion.ASTERISK_1_2)) {
            this.appendMap12(sb, singularKey, values);
        } else {
            this.appendMap10(sb, singularKey, values);
        }
    }

    protected void appendMap10(StringBuffer sb, String singularKey, Map values) {
        sb.append(singularKey);
        sb.append(": ");
        Iterator entryIterator = values.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            sb.append(entry.getKey());
            sb.append("=");
            if (entry.getValue() != null) {
                sb.append(entry.getValue());
            }
            if (!entryIterator.hasNext()) continue;
            sb.append("|");
        }
        sb.append(LINE_SEPARATOR);
    }

    protected void appendMap12(StringBuffer sb, String singularKey, Map values) {
        Iterator entryIterator = values.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            sb.append(singularKey);
            sb.append(": ");
            sb.append(entry.getKey());
            sb.append("=");
            if (entry.getValue() != null) {
                sb.append(entry.getValue());
            }
            sb.append(LINE_SEPARATOR);
        }
    }

    protected void appendString(StringBuffer sb, String key, String value) {
        sb.append(key);
        sb.append(": ");
        sb.append(value);
        sb.append(LINE_SEPARATOR);
    }
}

