/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.manager.impl;

import java.io.IOException;
import net.sf.asterisk.AsteriskVersion;
import net.sf.asterisk.io.SocketConnectionFacade;
import net.sf.asterisk.manager.ActionBuilder;
import net.sf.asterisk.manager.ManagerWriter;
import net.sf.asterisk.manager.action.ManagerAction;
import net.sf.asterisk.manager.impl.ActionBuilderImpl;
import net.sf.asterisk.util.Log;
import net.sf.asterisk.util.LogFactory;

public class ManagerWriterImpl
implements ManagerWriter {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ActionBuilder actionBuilder = new ActionBuilderImpl();
    private SocketConnectionFacade socket;

    public void setTargetVersion(AsteriskVersion version) {
        this.actionBuilder.setTargetVersion(version);
    }

    public synchronized void setSocket(SocketConnectionFacade socket) {
        this.socket = socket;
    }

    public synchronized void sendAction(ManagerAction action, String internalActionId) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException("Unable to send action: socket is null");
        }
        String actionString = this.actionBuilder.buildAction(action, internalActionId);
        this.socket.write(actionString);
        this.socket.flush();
        this.logger.debug("Sent " + action.getAction() + " action with actionId '" + action.getActionId() + "':\n" + actionString);
    }
}

