/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.live.AsteriskChannel;
import org.asteriskjava.live.CallerId;
import org.asteriskjava.live.ChannelState;
import org.asteriskjava.live.Extension;
import org.asteriskjava.live.HangupCause;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.NoSuchChannelException;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.CallDetailRecordImpl;
import org.asteriskjava.live.internal.OriginateCallbackData;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.action.StatusAction;
import org.asteriskjava.manager.event.AbstractChannelEvent;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.CdrEvent;
import org.asteriskjava.manager.event.DialEvent;
import org.asteriskjava.manager.event.DtmfEvent;
import org.asteriskjava.manager.event.HangupEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.MonitorStartEvent;
import org.asteriskjava.manager.event.MonitorStopEvent;
import org.asteriskjava.manager.event.NewCallerIdEvent;
import org.asteriskjava.manager.event.NewChannelEvent;
import org.asteriskjava.manager.event.NewExtenEvent;
import org.asteriskjava.manager.event.NewStateEvent;
import org.asteriskjava.manager.event.ParkedCallEvent;
import org.asteriskjava.manager.event.ParkedCallGiveUpEvent;
import org.asteriskjava.manager.event.ParkedCallTimeOutEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.manager.event.StatusEvent;
import org.asteriskjava.manager.event.UnparkedCallEvent;
import org.asteriskjava.manager.event.VarSetEvent;
import org.asteriskjava.util.DaemonThreadFactory;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class ChannelManager {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final long REMOVAL_THRESHOLD = 900000L;
    private static final long SLEEP_TIME_BEFORE_GET_VAR = 50L;
    private final AsteriskServerImpl server;
    final Map<String, AsteriskChannelImpl> channels = new LinkedHashMap<String, AsteriskChannelImpl>();
    ScheduledThreadPoolExecutor traceScheduledExecutorService;

    ChannelManager(AsteriskServerImpl server) {
        this.server = server;
    }

    void initialize() throws ManagerCommunicationException {
        this.initialize(null);
    }

    void initialize(List<String> variables) throws ManagerCommunicationException {
        this.shutdown();
        this.traceScheduledExecutorService = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());
        StatusAction sa = new StatusAction();
        sa.setVariables(variables);
        ResponseEvents re = this.server.sendEventGeneratingAction(sa);
        for (ManagerEvent managerEvent : re.getEvents()) {
            if (!(managerEvent instanceof StatusEvent)) continue;
            this.handleStatusEvent((StatusEvent)managerEvent);
        }
        this.logger.debug("ChannelManager has been initialised");
    }

    void disconnected() {
        this.shutdown();
        this.logger.debug("ChannelManager has been disconnected from Asterisk.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        if (this.traceScheduledExecutorService != null) {
            this.traceScheduledExecutorService.shutdown();
        }
        Map<String, AsteriskChannelImpl> map = this.channels;
        synchronized (map) {
            this.channels.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<AsteriskChannel> getChannels() {
        ArrayList<AsteriskChannel> copy;
        Map<String, AsteriskChannelImpl> map = this.channels;
        synchronized (map) {
            copy = new ArrayList<AsteriskChannel>(this.channels.size() + 2);
            for (AsteriskChannel asteriskChannel : this.channels.values()) {
                if (asteriskChannel.getState() == ChannelState.HUNGUP) continue;
                copy.add(asteriskChannel);
            }
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChannel(AsteriskChannelImpl channel) {
        Map<String, AsteriskChannelImpl> map = this.channels;
        synchronized (map) {
            this.channels.put(channel.getId(), channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldChannels() {
        Map<String, AsteriskChannelImpl> map = this.channels;
        synchronized (map) {
            Iterator<AsteriskChannelImpl> i = this.channels.values().iterator();
            while (i.hasNext()) {
                long diff;
                AsteriskChannel channel = i.next();
                Date dateOfRemoval = channel.getDateOfRemoval();
                if (channel.getState() != ChannelState.HUNGUP || dateOfRemoval == null || (diff = DateUtil.getDate().getTime() - dateOfRemoval.getTime()) < 900000L) continue;
                i.remove();
            }
        }
    }

    private AsteriskChannelImpl addNewChannel(String uniqueId, final String name, Date dateOfCreation, String callerIdNumber, String callerIdName, ChannelState state, String account) {
        final AsteriskChannelImpl channel = new AsteriskChannelImpl(this.server, name, uniqueId, dateOfCreation);
        channel.setCallerId(new CallerId(callerIdName, callerIdNumber));
        channel.setAccount(account);
        channel.stateChanged(dateOfCreation, state);
        this.logger.info("Adding channel " + channel.getName() + "(" + channel.getId() + ")");
        long start = System.currentTimeMillis();
        long end = start + 50L;
        while (System.currentTimeMillis() < end) {
            try {
                channel.getVariable("AJ_TRACE_ID");
            }
            catch (NoSuchChannelException e) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException intEx) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        String traceId = this.getTraceId(channel);
        channel.setTraceId(traceId);
        this.addChannel(channel);
        this.traceScheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                OriginateCallbackData callbackData;
                String traceId = ChannelManager.this.getTraceId(channel);
                channel.setTraceId(traceId);
                if (traceId != null && (!name.toLowerCase(Locale.ENGLISH).startsWith("local/") || name.endsWith(",1") || name.endsWith(";1")) && (callbackData = ChannelManager.this.server.getOriginateCallbackDataByTraceId(traceId)) != null && callbackData.getChannel() == null) {
                    callbackData.setChannel(channel);
                    try {
                        callbackData.getCallback().onDialing(channel);
                    }
                    catch (Throwable t) {
                        ChannelManager.this.logger.warn("Exception dispatching originate progress. " + channel, t);
                    }
                }
            }
        }, 50L, TimeUnit.MILLISECONDS);
        this.server.fireNewAsteriskChannel(channel);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleStatusEvent(StatusEvent event) {
        boolean isNew = false;
        Map<String, String> variables = event.getVariables();
        AsteriskChannelImpl channel = this.getChannelImplById(event.getUniqueId());
        if (channel == null) {
            Date dateOfCreation = event.getSeconds() != null ? new Date(DateUtil.getDate().getTime() - (long)event.getSeconds().intValue() * 1000L) : DateUtil.getDate();
            channel = new AsteriskChannelImpl(this.server, event.getChannel(), event.getUniqueId(), dateOfCreation);
            isNew = true;
            if (variables != null) {
                for (Map.Entry<String, String> variable : variables.entrySet()) {
                    channel.updateVariable(variable.getKey(), variable.getValue());
                }
            }
        }
        Extension extension = event.getContext() == null && event.getExtension() == null && event.getPriority() == null ? null : new Extension(event.getContext(), event.getExtension(), event.getPriority());
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            AsteriskChannelImpl linkedChannel;
            channel.setCallerId(new CallerId(event.getCallerIdName(), event.getCallerIdNum()));
            channel.setAccount(event.getAccountCode());
            if (event.getChannelState() != null) {
                channel.stateChanged(event.getDateReceived(), ChannelState.valueOf(event.getChannelState()));
            }
            channel.extensionVisited(event.getDateReceived(), extension);
            if (event.getBridgedChannel() != null && (linkedChannel = this.getChannelImplByName(event.getBridgedChannel())) != null) {
                channel.channelLinked(event.getDateReceived(), linkedChannel);
                AsteriskChannelImpl asteriskChannelImpl2 = linkedChannel;
                synchronized (asteriskChannelImpl2) {
                    linkedChannel.channelLinked(event.getDateReceived(), channel);
                }
            }
        }
        if (isNew) {
            this.logger.info("Adding new channel " + channel.getName());
            this.addChannel(channel);
            this.server.fireNewAsteriskChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskChannelImpl getChannelImplByName(String name) {
        Date dateOfCreation = null;
        AsteriskChannelImpl channel = null;
        if (name == null) {
            return null;
        }
        Map<String, AsteriskChannelImpl> map = this.channels;
        synchronized (map) {
            for (AsteriskChannelImpl tmp : this.channels.values()) {
                if (!name.equals(tmp.getName()) || dateOfCreation != null && !tmp.getDateOfCreation().after(dateOfCreation) && (!tmp.getDateOfCreation().equals(dateOfCreation) || tmp.getState() == ChannelState.HUNGUP)) continue;
                channel = tmp;
                dateOfCreation = channel.getDateOfCreation();
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskChannelImpl getChannelImplByNameAndActive(String name) {
        AsteriskChannelImpl channel = null;
        if (name == null) {
            return null;
        }
        Map<String, AsteriskChannelImpl> map = this.channels;
        synchronized (map) {
            for (AsteriskChannelImpl tmp : this.channels.values()) {
                if (!name.equals(tmp.getName()) || tmp.getState() == ChannelState.HUNGUP) continue;
                channel = tmp;
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskChannelImpl getChannelImplById(String uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        Map<String, AsteriskChannelImpl> map = this.channels;
        synchronized (map) {
            return this.channels.get(uniqueId);
        }
    }

    AsteriskChannelImpl getOtherSideOfLocalChannel(AsteriskChannel localChannel) {
        if (localChannel == null) {
            return null;
        }
        String name = localChannel.getName();
        if (name == null || !name.startsWith("Local/") || name.charAt(name.length() - 2) != ',' && name.charAt(name.length() - 2) != ';') {
            return null;
        }
        char num = name.charAt(name.length() - 1);
        if (num == '1') {
            return this.getChannelImplByName(name.substring(0, name.length() - 1) + "2");
        }
        if (num == '2') {
            return this.getChannelImplByName(name.substring(0, name.length() - 1) + "1");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNewChannelEvent(NewChannelEvent event) {
        AsteriskChannelImpl channel = this.getChannelImplById(event.getUniqueId());
        if (channel == null) {
            if (event.getChannel() == null) {
                this.logger.info("Ignored NewChannelEvent with empty channel name (uniqueId=" + event.getUniqueId() + ")");
            } else {
                this.addNewChannel(event.getUniqueId(), event.getChannel(), event.getDateReceived(), event.getCallerIdNum(), event.getCallerIdName(), ChannelState.valueOf(event.getChannelState()), event.getAccountCode());
            }
        } else {
            AsteriskChannelImpl asteriskChannelImpl = channel;
            synchronized (asteriskChannelImpl) {
                channel.nameChanged(event.getDateReceived(), event.getChannel());
                channel.setCallerId(new CallerId(event.getCallerIdName(), event.getCallerIdNum()));
                channel.stateChanged(event.getDateReceived(), ChannelState.valueOf(event.getChannelState()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNewExtenEvent(NewExtenEvent event) {
        AsteriskChannelImpl channel = this.getChannelImplById(event.getUniqueId());
        if (channel == null) {
            this.logger.warn("handleNewExtenEvent: Ignored NewExtenEvent for unknown channel " + event.getChannel());
            return;
        }
        Extension extension = new Extension(event.getContext(), event.getExtension(), event.getPriority(), event.getApplication(), event.getAppData());
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            channel.extensionVisited(event.getDateReceived(), extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void idChanged(AsteriskChannelImpl channel, AbstractChannelEvent event) {
        if (channel != null) {
            String oldId = channel.getId();
            String newId = event.getUniqueId();
            if (oldId != null && oldId.equals(newId)) {
                return;
            }
            this.logger.info("Changing unique_id for '" + channel.getName() + "' from " + oldId + " to " + newId + " < " + event);
            Map<String, AsteriskChannelImpl> map = this.channels;
            synchronized (map) {
                this.channels.remove(oldId);
                this.channels.put(newId, channel);
                channel.idChanged(event.getDateReceived(), newId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNewStateEvent(NewStateEvent event) {
        AsteriskChannelImpl channel = this.getChannelImplById(event.getUniqueId());
        if (channel == null) {
            channel = this.getChannelImplByNameAndActive(event.getChannel());
            this.idChanged(channel, event);
            if (channel == null) {
                this.logger.info("Creating new channel due to NewStateEvent '" + event.getChannel() + "' unique id " + event.getUniqueId());
                channel = this.addNewChannel(event.getUniqueId(), event.getChannel(), event.getDateReceived(), event.getCallerIdNum(), event.getCallerIdName(), ChannelState.valueOf(event.getChannelState()), null);
            }
        }
        if (event.getCallerIdNum() != null || event.getCallerIdName() != null) {
            String cidnum = "";
            String cidname = "";
            CallerId currentCallerId = channel.getCallerId();
            if (currentCallerId != null) {
                cidnum = currentCallerId.getNumber();
                cidname = currentCallerId.getName();
            }
            if (event.getCallerIdNum() != null) {
                cidnum = event.getCallerIdNum();
            }
            if (event.getCallerIdName() != null) {
                cidname = event.getCallerIdName();
            }
            CallerId newCallerId = new CallerId(cidname, cidnum);
            this.logger.debug("Updating CallerId (following NewStateEvent) to: " + newCallerId.toString());
            channel.setCallerId(newCallerId);
            if (event.getChannel() != null && !event.getChannel().equals(channel.getName())) {
                this.logger.info("Renaming channel (following NewStateEvent) '" + channel.getName() + "' to '" + event.getChannel() + "'");
                AsteriskChannelImpl asteriskChannelImpl = channel;
                synchronized (asteriskChannelImpl) {
                    channel.nameChanged(event.getDateReceived(), event.getChannel());
                }
            }
        }
        if (event.getChannelState() != null) {
            AsteriskChannelImpl asteriskChannelImpl = channel;
            synchronized (asteriskChannelImpl) {
                channel.stateChanged(event.getDateReceived(), ChannelState.valueOf(event.getChannelState()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNewCallerIdEvent(NewCallerIdEvent event) {
        AsteriskChannelImpl channel = this.getChannelImplById(event.getUniqueId());
        if (channel == null) {
            channel = this.getChannelImplByNameAndActive(event.getChannel());
            this.idChanged(channel, event);
            if (channel == null) {
                channel = this.addNewChannel(event.getUniqueId(), event.getChannel(), event.getDateReceived(), event.getCallerIdNum(), event.getCallerIdName(), ChannelState.DOWN, null);
            }
        }
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            channel.setCallerId(new CallerId(event.getCallerIdName(), event.getCallerIdNum()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleHangupEvent(HangupEvent event) {
        HangupCause cause = null;
        AsteriskChannelImpl channel = this.getChannelImplById(event.getUniqueId());
        if (channel == null) {
            this.logger.warn("handleHangupEvent: Ignored HangupEvent for unknown channel " + event.getChannel());
            return;
        }
        if (event.getCause() != null) {
            cause = HangupCause.getByCode(event.getCause());
        }
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            channel.hungup(event.getDateReceived(), cause, event.getCauseTxt());
        }
        this.logger.info("Removing channel " + channel.getName() + " due to hangup (" + (Object)((Object)cause) + ")");
        this.removeOldChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDialEvent(DialEvent event) {
        AsteriskChannelImpl sourceChannel = this.getChannelImplById(event.getUniqueId());
        AsteriskChannelImpl destinationChannel = this.getChannelImplById(event.getDestUniqueId());
        if (sourceChannel == null) {
            this.logger.warn("handleDialEvent: Ignored DialEvent for unknown source channel " + event.getChannel() + " with unique id " + event.getUniqueId());
            return;
        }
        if (destinationChannel == null) {
            if ("End".equalsIgnoreCase(event.getSubEvent())) {
                sourceChannel.updateVariable("AJ_DIAL_STATUS", event.getDialStatus());
                this.logger.info("handleDialEvent: Ignored DialEvent for unknown dst channel " + event.getDestination() + " with unique_id " + event.getDestUniqueId());
            } else {
                this.logger.warn("handleDialEvent: Ignored DialEvent for unknown dst channel " + event.getDestination() + " with unique_id " + event.getDestUniqueId());
            }
            return;
        }
        this.logger.info(sourceChannel.getName() + " dialed " + destinationChannel.getName());
        this.getTraceId(sourceChannel);
        this.getTraceId(destinationChannel);
        AsteriskChannelImpl asteriskChannelImpl = sourceChannel;
        synchronized (asteriskChannelImpl) {
            sourceChannel.channelDialed(event.getDateReceived(), destinationChannel);
        }
        asteriskChannelImpl = destinationChannel;
        synchronized (asteriskChannelImpl) {
            destinationChannel.channelDialing(event.getDateReceived(), sourceChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBridgeEvent(BridgeEvent event) {
        AsteriskChannelImpl asteriskChannelImpl;
        AsteriskChannelImpl channel1 = this.getChannelImplById(event.getUniqueId1());
        AsteriskChannelImpl channel2 = this.getChannelImplById(event.getUniqueId2());
        if (channel1 == null) {
            this.logger.warn("handleBridgeEvent: Ignored BridgeEvent for unknown channel " + event.getChannel1());
            return;
        }
        if (channel2 == null) {
            this.logger.warn("handleBridgeEvent: Ignored BridgeEvent for unknown channel " + event.getChannel2());
            return;
        }
        if (event.isLink()) {
            this.logger.info("Linking channels " + channel1.getName() + " and " + channel2.getName());
            asteriskChannelImpl = channel1;
            synchronized (asteriskChannelImpl) {
                channel1.channelLinked(event.getDateReceived(), channel2);
            }
            asteriskChannelImpl = channel2;
            synchronized (asteriskChannelImpl) {
                channel2.channelLinked(event.getDateReceived(), channel1);
            }
        }
        if (event.isUnlink()) {
            this.logger.info("Unlinking channels " + channel1.getName() + " and " + channel2.getName());
            asteriskChannelImpl = channel1;
            synchronized (asteriskChannelImpl) {
                channel1.channelUnlinked(event.getDateReceived());
            }
            asteriskChannelImpl = channel2;
            synchronized (asteriskChannelImpl) {
                channel2.channelUnlinked(event.getDateReceived());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRenameEvent(RenameEvent event) {
        AsteriskChannelImpl channel = this.getChannelImplById(event.getUniqueId());
        if (channel == null) {
            this.logger.warn("handleRenameEvent: Ignored RenameEvent for unknown channel with uniqueId " + event.getUniqueId());
            return;
        }
        this.logger.info("Renaming channel '" + channel.getName() + "' to '" + event.getNewname() + "', uniqueId is " + event.getUniqueId());
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            channel.nameChanged(event.getDateReceived(), event.getNewname());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCdrEvent(CdrEvent event) {
        AsteriskChannelImpl channel = this.getChannelImplById(event.getUniqueId());
        AsteriskChannelImpl destinationChannel = this.getChannelImplByName(event.getDestinationChannel());
        if (channel == null) {
            this.logger.info("Ignored CdrEvent for unknown channel with uniqueId " + event.getUniqueId());
            return;
        }
        CallDetailRecordImpl cdr = new CallDetailRecordImpl(channel, destinationChannel, event);
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            channel.callDetailRecordReceived(event.getDateReceived(), cdr);
        }
    }

    private String getTraceId(AsteriskChannel channel) {
        String traceId;
        try {
            traceId = channel.getVariable("AJ_TRACE_ID");
        }
        catch (Exception e) {
            traceId = null;
        }
        return traceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleParkedCallEvent(ParkedCallEvent event) {
        AsteriskChannelImpl channel = this.getChannelImplByNameAndActive(event.getParkeeChannel());
        if (channel == null) {
            this.logger.info("Ignored ParkedCallEvent for unknown channel " + event.getParkeeChannel());
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            Extension ext = new Extension(null, event.getExten(), 1);
            channel.setParkedAt(ext);
            this.logger.info("Channel " + channel.getName() + " is parked at " + channel.getParkedAt().getExtension());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleParkedCallGiveUpEvent(ParkedCallGiveUpEvent event) {
        AsteriskChannelImpl channel = this.getChannelImplByNameAndActive(event.getParkeeChannel());
        if (channel == null) {
            this.logger.info("Ignored ParkedCallGiveUpEvent for unknown channel " + event.getParkeeChannel());
            return;
        }
        Extension wasParkedAt = channel.getParkedAt();
        if (wasParkedAt == null) {
            this.logger.info("Ignored ParkedCallGiveUpEvent as the channel was not parked");
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            channel.setParkedAt(null);
        }
        this.logger.info("Channel " + channel.getName() + " is unparked (GiveUp) from " + wasParkedAt.getExtension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleParkedCallTimeOutEvent(ParkedCallTimeOutEvent event) {
        AsteriskChannelImpl channel = this.getChannelImplByNameAndActive(event.getParkeeChannel());
        if (channel == null) {
            this.logger.info("Ignored ParkedCallTimeOutEvent for unknown channel " + event.getParkeeChannel());
            return;
        }
        Extension wasParkedAt = channel.getParkedAt();
        if (wasParkedAt == null) {
            this.logger.info("Ignored ParkedCallTimeOutEvent as the channel was not parked");
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            channel.setParkedAt(null);
        }
        this.logger.info("Channel " + channel.getName() + " is unparked (Timeout) from " + wasParkedAt.getExtension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnparkedCallEvent(UnparkedCallEvent event) {
        AsteriskChannelImpl channel = this.getChannelImplByNameAndActive(event.getParkeeChannel());
        if (channel == null) {
            this.logger.info("Ignored UnparkedCallEvent for unknown channel " + event.getParkeeChannel());
            return;
        }
        Extension wasParkedAt = channel.getParkedAt();
        if (wasParkedAt == null) {
            this.logger.info("Ignored UnparkedCallEvent as the channel was not parked");
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            channel.setParkedAt(null);
        }
        this.logger.info("Channel " + channel.getName() + " is unparked (moved away) from " + wasParkedAt.getExtension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleVarSetEvent(VarSetEvent event) {
        if (event.getUniqueId() == null) {
            return;
        }
        AsteriskChannelImpl channel = this.getChannelImplById(event.getUniqueId());
        if (channel == null) {
            this.logger.info("Ignored VarSetEvent for unknown channel with uniqueId " + event.getUniqueId());
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            channel.updateVariable(event.getVariable(), event.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDtmfEvent(DtmfEvent event) {
        if (event.isBegin().booleanValue()) {
            return;
        }
        if (event.getUniqueId() == null) {
            return;
        }
        AsteriskChannelImpl channel = this.getChannelImplById(event.getUniqueId());
        if (channel == null) {
            this.logger.info("Ignored DtmfEvent for unknown channel with uniqueId " + event.getUniqueId());
            return;
        }
        Character dtmfDigit = event.getDigit() == null || event.getDigit().length() < 1 ? null : Character.valueOf(event.getDigit().charAt(0));
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            if (event.isReceived()) {
                channel.dtmfReceived(dtmfDigit);
            }
            if (event.isSent()) {
                channel.dtmfSent(dtmfDigit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMonitorStartEvent(MonitorStartEvent event) {
        AsteriskChannelImpl channel = this.getChannelImplByNameAndActive(event.getChannel());
        if (channel == null) {
            this.logger.info("Ignored MonitorStartEvent for unknown channel " + event.getChannel());
            return;
        }
        boolean isMonitored = channel.isMonitored();
        if (isMonitored) {
            this.logger.info("Ignored MonitorStartEvent as the channel was already monitored");
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            channel.setMonitored(true);
        }
        this.logger.info("Channel " + channel.getName() + " is monitored");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMonitorStopEvent(MonitorStopEvent event) {
        AsteriskChannelImpl channel = this.getChannelImplByNameAndActive(event.getChannel());
        if (channel == null) {
            this.logger.info("Ignored MonitorStopEvent for unknown channel " + event.getChannel());
            return;
        }
        boolean isMonitored = channel.isMonitored();
        if (!isMonitored) {
            this.logger.info("Ignored MonitorStopEvent as the channel was not monitored");
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl = channel;
        synchronized (asteriskChannelImpl) {
            channel.setMonitored(false);
        }
        this.logger.info("Channel " + channel.getName() + " is not monitored");
    }
}

