/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.EventTimeoutException;
import org.asteriskjava.manager.ExpectedResponse;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.SendActionCallback;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ChallengeAction;
import org.asteriskjava.manager.action.CommandAction;
import org.asteriskjava.manager.action.EventGeneratingAction;
import org.asteriskjava.manager.action.LoginAction;
import org.asteriskjava.manager.action.LogoffAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.UserEventAction;
import org.asteriskjava.manager.event.ConnectEvent;
import org.asteriskjava.manager.event.DialBeginEvent;
import org.asteriskjava.manager.event.DialEvent;
import org.asteriskjava.manager.event.DisconnectEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.ProtocolIdentifierReceivedEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.internal.Dispatcher;
import org.asteriskjava.manager.internal.ManagerReader;
import org.asteriskjava.manager.internal.ManagerReaderImpl;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.manager.internal.ManagerWriter;
import org.asteriskjava.manager.internal.ManagerWriterImpl;
import org.asteriskjava.manager.internal.ProtocolIdentifierWrapper;
import org.asteriskjava.manager.internal.ResponseEventsImpl;
import org.asteriskjava.manager.response.ChallengeResponse;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.SocketConnectionFacade;
import org.asteriskjava.util.internal.SocketConnectionFacadeImpl;

public class ManagerConnectionImpl
implements ManagerConnection,
Dispatcher {
    private static final int RECONNECTION_INTERVAL_1 = 50;
    private static final int RECONNECTION_INTERVAL_2 = 5000;
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORT = 5038;
    private static final int RECONNECTION_VERSION_INTERVAL = 500;
    private static final int MAX_VERSION_ATTEMPTS = 4;
    private static final Pattern SHOW_VERSION_PATTERN = Pattern.compile("^(core )?show version.*");
    private static final Pattern VERSION_PATTERN_1_6 = Pattern.compile("^\\s*Asterisk ((SVN-branch|GIT)-)?1\\.6[-. ].*");
    private static final Pattern VERSION_PATTERN_1_8 = Pattern.compile("^\\s*Asterisk ((SVN-branch|GIT)-)?1\\.8[-. ].*");
    private static final Pattern VERSION_PATTERN_10 = Pattern.compile("^\\s*Asterisk ((SVN-branch|GIT)-)?10[-. ].*");
    private static final Pattern VERSION_PATTERN_11 = Pattern.compile("^\\s*Asterisk ((SVN-branch|GIT)-)?11[-. ].*");
    private static final Pattern VERSION_PATTERN_CERTIFIED_11 = Pattern.compile("^\\s*Asterisk certified/((SVN-branch|GIT)-)?11[-. ].*");
    private static final Pattern VERSION_PATTERN_12 = Pattern.compile("^\\s*Asterisk ((SVN-branch|GIT)-)?12[-. ].*");
    private static final Pattern VERSION_PATTERN_13 = Pattern.compile("^\\s*Asterisk ((SVN-branch|GIT)-)?13[-. ].*");
    private static final Pattern VERSION_PATTERN_CERTIFIED_13 = Pattern.compile("^\\s*Asterisk certified/((SVN-branch|GIT)-)?13[-. ].*");
    private static final Pattern VERSION_PATTERN_14 = Pattern.compile("^\\s*Asterisk (GIT-)?14[-. ].*");
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private final Log logger = LogFactory.getLog(this.getClass());
    private final long id;
    private AtomicLong actionIdCounter = new AtomicLong(0L);
    private String hostname = "localhost";
    private int port = 5038;
    private boolean ssl = false;
    protected String username;
    protected String password;
    private Charset encoding = StandardCharsets.UTF_8;
    private long defaultResponseTimeout = 2000L;
    private long defaultEventTimeout = 5000L;
    private int socketTimeout = 0;
    private int socketReadTimeout = 0;
    private boolean keepAliveAfterAuthenticationFailure = true;
    private SocketConnectionFacade socket;
    private Thread readerThread;
    private final AtomicLong readerThreadCounter = new AtomicLong(0L);
    private final AtomicLong reconnectThreadCounter = new AtomicLong(0L);
    private ManagerReader reader;
    private ManagerWriter writer;
    private final ProtocolIdentifierWrapper protocolIdentifier;
    private AsteriskVersion version;
    private final Map<String, SendActionCallback> responseListeners;
    private final Map<String, ManagerEventListener> responseEventListeners;
    private final List<ManagerEventListener> eventListeners;
    protected ManagerConnectionState state = ManagerConnectionState.INITIAL;
    private String eventMask;

    public ManagerConnectionImpl() {
        this.id = idCounter.getAndIncrement();
        this.responseListeners = new HashMap<String, SendActionCallback>();
        this.responseEventListeners = new HashMap<String, ManagerEventListener>();
        this.eventListeners = new ArrayList<ManagerEventListener>();
        this.protocolIdentifier = new ProtocolIdentifierWrapper();
    }

    protected ManagerReader createReader(Dispatcher dispatcher, Object source) {
        return new ManagerReaderImpl(dispatcher, source);
    }

    protected ManagerWriter createWriter() {
        return new ManagerWriterImpl();
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port <= 0 ? 5038 : port;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public void setDefaultResponseTimeout(long defaultResponseTimeout) {
        this.defaultResponseTimeout = defaultResponseTimeout;
    }

    public void setDefaultEventTimeout(long defaultEventTimeout) {
        this.defaultEventTimeout = defaultEventTimeout;
    }

    public void setKeepAliveAfterAuthenticationFailure(boolean keepAliveAfterAuthenticationFailure) {
        this.keepAliveAfterAuthenticationFailure = keepAliveAfterAuthenticationFailure;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public AsteriskVersion getVersion() {
        return this.version;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isSsl() {
        return this.ssl;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.socket.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.socket.getRemotePort();
    }

    @Override
    public void registerUserEventClass(Class<? extends ManagerEvent> userEventClass) {
        if (this.reader == null) {
            this.reader = this.createReader(this, this);
        }
        this.reader.registerEventClass(userEventClass);
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Override
    public void setSocketReadTimeout(int socketReadTimeout) {
        this.socketReadTimeout = socketReadTimeout;
    }

    @Override
    public synchronized void login() throws IOException, AuthenticationFailedException, TimeoutException {
        this.login(null);
    }

    @Override
    public synchronized void login(String eventMask) throws IOException, AuthenticationFailedException, TimeoutException {
        if (this.state != ManagerConnectionState.INITIAL && this.state != ManagerConnectionState.DISCONNECTED) {
            throw new IllegalStateException("Login may only be perfomed when in state INITIAL or DISCONNECTED, but connection is in state " + (Object)((Object)this.state));
        }
        this.state = ManagerConnectionState.CONNECTING;
        this.eventMask = eventMask;
        try {
            this.doLogin(this.defaultResponseTimeout, eventMask);
        }
        finally {
            if (this.state != ManagerConnectionState.CONNECTED) {
                this.state = ManagerConnectionState.DISCONNECTED;
            }
        }
    }

    protected synchronized void doLogin(long timeout, String eventMask) throws IOException, AuthenticationFailedException, TimeoutException {
        ManagerResponse loginResponse;
        String key;
        ManagerResponse challengeResponse;
        if (this.socket == null) {
            this.connect();
        }
        if (this.protocolIdentifier.getValue() == null) {
            try {
                this.protocolIdentifier.await(timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.protocolIdentifier.getValue() == null) {
            this.disconnect();
            if (this.reader != null && this.reader.getTerminationException() != null) {
                throw this.reader.getTerminationException();
            }
            throw new TimeoutException("Timeout waiting for protocol identifier");
        }
        ChallengeAction challengeAction = new ChallengeAction("MD5");
        try {
            challengeResponse = this.sendAction(challengeAction);
        }
        catch (Exception e) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to send challenge action", e);
        }
        if (!(challengeResponse instanceof ChallengeResponse)) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to get challenge from Asterisk. ChallengeAction returned: " + challengeResponse.getMessage());
        }
        String challenge = ((ChallengeResponse)challengeResponse).getChallenge();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (challenge != null) {
                md.update(challenge.getBytes(StandardCharsets.UTF_8));
            }
            if (this.password != null) {
                md.update(this.password.getBytes(StandardCharsets.UTF_8));
            }
            key = ManagerUtil.toHexString(md.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to create login key using MD5 Message Digest", ex);
        }
        LoginAction loginAction = new LoginAction(this.username, "MD5", key, eventMask);
        try {
            loginResponse = this.sendAction(loginAction);
        }
        catch (Exception e) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to send login action", e);
        }
        if (loginResponse instanceof ManagerError) {
            this.disconnect();
            throw new AuthenticationFailedException(loginResponse.getMessage());
        }
        this.logger.info("Successfully logged in");
        this.version = this.determineVersion();
        this.state = ManagerConnectionState.CONNECTED;
        this.writer.setTargetVersion(this.version);
        this.logger.info("Determined Asterisk version: " + this.version);
        ConnectEvent connectEvent = new ConnectEvent(this);
        connectEvent.setProtocolIdentifier(this.getProtocolIdentifier());
        connectEvent.setDateReceived(DateUtil.getDate());
        this.fireEvent(connectEvent);
    }

    protected AsteriskVersion determineVersion() throws IOException, TimeoutException {
        int attempts = 0;
        while (attempts++ < 4) {
            List<String> coreShowVersionResult;
            List<String> showVersionFilesResult;
            boolean Asterisk14outputPresent = false;
            ManagerResponse showVersionFilesResponse = this.sendAction((ManagerAction)new CommandAction("show version files pbx.c"), this.defaultResponseTimeout * 2L);
            if (!(showVersionFilesResponse instanceof CommandResponse)) {
                if (showVersionFilesResponse.getOutput() == null) break;
                Asterisk14outputPresent = true;
            }
            if (Asterisk14outputPresent) {
                List<String> outputList = Arrays.asList(showVersionFilesResponse.getOutput().split(SocketConnectionFacadeImpl.NL_PATTERN.pattern()));
                showVersionFilesResult = outputList;
            } else {
                showVersionFilesResult = ((CommandResponse)showVersionFilesResponse).getResult();
            }
            if (showVersionFilesResult == null || showVersionFilesResult.isEmpty()) continue;
            String line1 = showVersionFilesResult.get(0);
            if (line1 != null && line1.startsWith("File")) {
                String rawVersion = this.getRawVersion();
                if (rawVersion != null && rawVersion.startsWith("Asterisk 1.4")) {
                    return AsteriskVersion.ASTERISK_1_4;
                }
                return AsteriskVersion.ASTERISK_1_2;
            }
            if (line1 == null || !line1.contains("No such command")) break;
            ManagerResponse coreShowVersionResponse = this.sendAction((ManagerAction)new CommandAction("core show version"), this.defaultResponseTimeout * 2L);
            if (coreShowVersionResponse != null && coreShowVersionResponse instanceof CommandResponse && (coreShowVersionResult = ((CommandResponse)coreShowVersionResponse).getResult()) != null && !coreShowVersionResult.isEmpty()) {
                String coreLine = coreShowVersionResult.get(0);
                if (VERSION_PATTERN_1_6.matcher(coreLine).matches()) {
                    return AsteriskVersion.ASTERISK_1_6;
                }
                if (VERSION_PATTERN_1_8.matcher(coreLine).matches()) {
                    return AsteriskVersion.ASTERISK_1_8;
                }
                if (VERSION_PATTERN_10.matcher(coreLine).matches()) {
                    return AsteriskVersion.ASTERISK_10;
                }
                if (VERSION_PATTERN_11.matcher(coreLine).matches()) {
                    return AsteriskVersion.ASTERISK_11;
                }
                if (VERSION_PATTERN_CERTIFIED_11.matcher(coreLine).matches()) {
                    return AsteriskVersion.ASTERISK_11;
                }
                if (VERSION_PATTERN_12.matcher(coreLine).matches()) {
                    return AsteriskVersion.ASTERISK_12;
                }
                if (VERSION_PATTERN_13.matcher(coreLine).matches()) {
                    return AsteriskVersion.ASTERISK_13;
                }
                if (VERSION_PATTERN_CERTIFIED_13.matcher(coreLine).matches()) {
                    return AsteriskVersion.ASTERISK_13;
                }
                if (VERSION_PATTERN_14.matcher(coreLine).matches()) {
                    return AsteriskVersion.ASTERISK_14;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        this.logger.error("Unable to determine asterisk version, assuming 1.6... you should expect problems to follow.");
        return AsteriskVersion.ASTERISK_1_6;
    }

    protected String getRawVersion() {
        List<String> showVersionResult;
        ManagerResponse showVersionResponse;
        try {
            showVersionResponse = this.sendAction((ManagerAction)new CommandAction("show version"), this.defaultResponseTimeout * 2L);
        }
        catch (Exception e) {
            return null;
        }
        if (showVersionResponse instanceof CommandResponse && (showVersionResult = ((CommandResponse)showVersionResponse).getResult()) != null && !showVersionResult.isEmpty()) {
            return showVersionResult.get(0);
        }
        return null;
    }

    protected synchronized void connect() throws IOException {
        this.logger.info("Connecting to " + this.hostname + ":" + this.port);
        if (this.reader == null) {
            this.logger.debug("Creating reader for " + this.hostname + ":" + this.port);
            this.reader = this.createReader(this, this);
        }
        if (this.writer == null) {
            this.logger.debug("Creating writer");
            this.writer = this.createWriter();
        }
        this.logger.debug("Creating socket");
        this.socket = this.createSocket();
        this.logger.debug("Passing socket to reader");
        this.reader.setSocket(this.socket);
        if (this.readerThread == null || !this.readerThread.isAlive() || this.reader.isDead()) {
            this.logger.debug("Creating and starting reader thread");
            this.readerThread = new Thread(this.reader);
            this.readerThread.setName("Asterisk-Java ManagerConnection-" + this.id + "-Reader-" + this.readerThreadCounter.getAndIncrement());
            this.readerThread.setDaemon(true);
            this.readerThread.start();
        }
        this.logger.debug("Passing socket to writer");
        this.writer.setSocket(this.socket);
    }

    protected SocketConnectionFacade createSocket() throws IOException {
        return new SocketConnectionFacadeImpl(this.hostname, this.port, this.ssl, this.socketTimeout, this.socketReadTimeout, this.encoding);
    }

    @Override
    public synchronized void logoff() throws IllegalStateException {
        if (this.state != ManagerConnectionState.CONNECTED && this.state != ManagerConnectionState.RECONNECTING) {
            throw new IllegalStateException("Logoff may only be perfomed when in state CONNECTED or RECONNECTING, but connection is in state " + (Object)((Object)this.state));
        }
        this.state = ManagerConnectionState.DISCONNECTING;
        if (this.socket != null) {
            try {
                this.sendAction(new LogoffAction());
            }
            catch (Exception e) {
                this.logger.warn("Unable to send LogOff action", e);
            }
        }
        this.cleanup();
        this.state = ManagerConnectionState.DISCONNECTED;
    }

    protected synchronized void disconnect() {
        if (this.socket != null) {
            this.logger.info("Closing socket.");
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                this.logger.warn("Unable to close socket: " + ex.getMessage());
            }
            this.socket = null;
        }
        this.protocolIdentifier.reset();
    }

    @Override
    public ManagerResponse sendAction(ManagerAction action) throws IOException, TimeoutException, IllegalArgumentException, IllegalStateException {
        return this.sendAction(action, this.defaultResponseTimeout);
    }

    @Override
    public ManagerResponse sendAction(ManagerAction action, long timeout) throws IOException, TimeoutException, IllegalArgumentException, IllegalStateException {
        ResponseHandlerResult result = new ResponseHandlerResult();
        DefaultSendActionCallback callbackHandler = new DefaultSendActionCallback(result);
        this.sendAction(action, callbackHandler);
        if (action instanceof UserEventAction) {
            return null;
        }
        if (result.getResponse() == null) {
            try {
                result.await(timeout);
            }
            catch (InterruptedException ex) {
                this.logger.warn("Interrupted while waiting for result");
                Thread.currentThread().interrupt();
            }
        }
        if (result.getResponse() == null) {
            throw new TimeoutException("Timeout waiting for response to " + action.getAction() + (action.getActionId() == null ? "" : " (actionId: " + action.getActionId() + ")"));
        }
        return result.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAction(ManagerAction action, SendActionCallback callback) throws IOException, IllegalArgumentException, IllegalStateException {
        Class<? extends ManagerResponse> responseClass;
        if (action == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (!((this.state == ManagerConnectionState.CONNECTING || this.state == ManagerConnectionState.RECONNECTING) && (action instanceof ChallengeAction || action instanceof LoginAction || this.isShowVersionCommandAction(action)) || this.state == ManagerConnectionState.DISCONNECTING && action instanceof LogoffAction || this.state == ManagerConnectionState.CONNECTED)) {
            throw new IllegalStateException("Actions may only be sent when in state CONNECTED, but connection is in state " + (Object)((Object)this.state));
        }
        if (this.socket == null) {
            throw new IllegalStateException("Unable to send " + action.getAction() + " action: socket not connected.");
        }
        String internalActionId = this.createInternalActionId();
        if (callback != null) {
            Map<String, SendActionCallback> map = this.responseListeners;
            synchronized (map) {
                this.responseListeners.put(internalActionId, callback);
            }
        }
        if ((responseClass = this.getExpectedResponseClass(action.getClass())) != null) {
            this.reader.expectResponseClass(internalActionId, responseClass);
        }
        this.writer.sendAction(action, internalActionId);
    }

    boolean isShowVersionCommandAction(ManagerAction action) {
        if (!(action instanceof CommandAction)) {
            return false;
        }
        Matcher showVersionMatcher = SHOW_VERSION_PATTERN.matcher(((CommandAction)action).getCommand());
        return showVersionMatcher.matches();
    }

    private Class<? extends ManagerResponse> getExpectedResponseClass(Class<? extends ManagerAction> actionClass) {
        ExpectedResponse annotation = actionClass.getAnnotation(ExpectedResponse.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    @Override
    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction action) throws IOException, EventTimeoutException, IllegalArgumentException, IllegalStateException {
        return this.sendEventGeneratingAction(action, this.defaultEventTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction action, long timeout) throws IOException, EventTimeoutException, IllegalArgumentException, IllegalStateException {
        Map<String, Object> map;
        if (action == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (action.getActionCompleteEventClass() == null) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass for " + action.getClass().getName() + " is null.");
        }
        if (!ResponseEvent.class.isAssignableFrom(action.getActionCompleteEventClass())) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass (" + action.getActionCompleteEventClass().getName() + ") for " + action.getClass().getName() + " is not a ResponseEvent.");
        }
        if (this.state != ManagerConnectionState.CONNECTED) {
            throw new IllegalStateException("Actions may only be sent when in state CONNECTED but connection is in state " + (Object)((Object)this.state));
        }
        ResponseEventsImpl responseEvents = new ResponseEventsImpl();
        ResponseEventHandler responseEventHandler = new ResponseEventHandler(responseEvents, action.getActionCompleteEventClass());
        String internalActionId = this.createInternalActionId();
        try {
            map = this.responseListeners;
            synchronized (map) {
                this.responseListeners.put(internalActionId, responseEventHandler);
            }
            map = this.responseEventListeners;
            synchronized (map) {
                this.responseEventListeners.put(internalActionId, responseEventHandler);
            }
            this.writer.sendAction(action, internalActionId);
            if (responseEvents.getResponse() == null || !responseEvents.isComplete()) {
                try {
                    responseEvents.await(timeout);
                }
                catch (InterruptedException e) {
                    this.logger.warn("Interrupted while waiting for response events.");
                    Thread.currentThread().interrupt();
                }
            }
            if (responseEvents.getResponse() == null || !responseEvents.isComplete()) {
                throw new EventTimeoutException("Timeout waiting for response or response events to " + action.getAction() + (action.getActionId() == null ? "" : " (actionId: " + action.getActionId() + ")"), responseEvents);
            }
        }
        finally {
            map = this.responseEventListeners;
            synchronized (map) {
                this.responseEventListeners.remove(internalActionId);
            }
            map = this.responseListeners;
            synchronized (map) {
                this.responseListeners.remove(internalActionId);
            }
        }
        return responseEvents;
    }

    private String createInternalActionId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hashCode());
        sb.append("_");
        sb.append(this.actionIdCounter.getAndIncrement());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(ManagerEventListener listener) {
        List<ManagerEventListener> list = this.eventListeners;
        synchronized (list) {
            if (!this.eventListeners.contains(listener)) {
                this.eventListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventListener(ManagerEventListener listener) {
        List<ManagerEventListener> list = this.eventListeners;
        synchronized (list) {
            if (this.eventListeners.contains(listener)) {
                this.eventListeners.remove(listener);
            }
        }
    }

    @Override
    public String getProtocolIdentifier() {
        return this.protocolIdentifier.getValue();
    }

    @Override
    public ManagerConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchResponse(ManagerResponse response) {
        if (response == null) {
            this.logger.error("Unable to dispatch null response. This should never happen. Please file a bug.");
            return;
        }
        String actionId = response.getActionId();
        String internalActionId = null;
        SendActionCallback listener = null;
        if (actionId != null) {
            internalActionId = ManagerUtil.getInternalActionId(actionId);
            response.setActionId(ManagerUtil.stripInternalActionId(actionId));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Dispatching response with internalActionId '" + internalActionId + "':\n" + response);
        }
        if (internalActionId != null) {
            Map<String, SendActionCallback> map = this.responseListeners;
            synchronized (map) {
                listener = this.responseListeners.get(internalActionId);
                if (listener != null) {
                    this.responseListeners.remove(internalActionId);
                } else {
                    this.logger.debug("No response listener registered for internalActionId '" + internalActionId + "'");
                }
            }
        } else {
            this.logger.error("Unable to retrieve internalActionId from response: actionId '" + actionId + "':\n" + response);
        }
        if (listener != null) {
            try {
                listener.onResponse(response);
            }
            catch (Exception e) {
                this.logger.warn("Unexpected exception in response listener " + listener.getClass().getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(ManagerEvent event) {
        Object responseEvent;
        String internalActionId;
        if (event == null) {
            this.logger.error("Unable to dispatch null event. This should never happen. Please file a bug.");
            return;
        }
        this.dispatchLegacyEventIfNeeded(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Dispatching event:\n" + event.toString());
        }
        if (event instanceof ResponseEvent && (internalActionId = ((ResponseEvent)(responseEvent = (ResponseEvent)event)).getInternalActionId()) != null) {
            Map<String, ManagerEventListener> map = this.responseEventListeners;
            synchronized (map) {
                ManagerEventListener listener = this.responseEventListeners.get(internalActionId);
                if (listener != null) {
                    try {
                        listener.onManagerEvent(event);
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected exception in response event listener " + listener.getClass().getName(), e);
                    }
                }
            }
        }
        if (event instanceof DisconnectEvent) {
            responseEvent = this;
            synchronized (responseEvent) {
                if (this.state != ManagerConnectionState.CONNECTED) {
                    return;
                }
                this.state = ManagerConnectionState.RECONNECTING;
                this.cleanup();
                Thread reconnectThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ManagerConnectionImpl.this.reconnect();
                    }
                });
                reconnectThread.setName("Asterisk-Java ManagerConnection-" + this.id + "-Reconnect-" + this.reconnectThreadCounter.getAndIncrement());
                reconnectThread.setDaemon(true);
                reconnectThread.start();
            }
        }
        if (event instanceof ProtocolIdentifierReceivedEvent) {
            ProtocolIdentifierReceivedEvent protocolIdentifierReceivedEvent = (ProtocolIdentifierReceivedEvent)event;
            String protocolIdentifier = protocolIdentifierReceivedEvent.getProtocolIdentifier();
            this.setProtocolIdentifier(protocolIdentifier);
            return;
        }
        this.fireEvent(event);
    }

    private void dispatchLegacyEventIfNeeded(ManagerEvent event) {
        if (event instanceof DialBeginEvent) {
            DialEvent legacyEvent = new DialEvent((DialBeginEvent)event);
            this.dispatchEvent(legacyEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(ManagerEvent event) {
        List<ManagerEventListener> list = this.eventListeners;
        synchronized (list) {
            for (ManagerEventListener listener : this.eventListeners) {
                try {
                    listener.onManagerEvent(event);
                }
                catch (RuntimeException e) {
                    this.logger.warn("Unexpected exception in eventHandler " + listener.getClass().getName(), e);
                }
            }
        }
    }

    private void setProtocolIdentifier(String identifier) {
        this.logger.info("Connected via " + identifier);
        if (!("Asterisk Call Manager/1.0".equals(identifier) || "Asterisk Call Manager/1.1".equals(identifier) || "Asterisk Call Manager/1.2".equals(identifier) || "Asterisk Call Manager/1.3".equals(identifier) || "Asterisk Call Manager/2.6.0".equals(identifier) || "Asterisk Call Manager/2.7.0".equals(identifier) || "Asterisk Call Manager/2.8.0".equals(identifier) || "Asterisk Call Manager/2.9.0".equals(identifier) || "Asterisk Call Manager/3.1.0".equals(identifier) || "OpenPBX Call Manager/1.0".equals(identifier) || "CallWeaver Call Manager/1.0".equals(identifier) || identifier != null && identifier.startsWith("Asterisk Call Manager Proxy/"))) {
            this.logger.warn("Unsupported protocol version '" + identifier + "'. Use at your own risk.");
        }
        this.protocolIdentifier.setValue(identifier);
        this.protocolIdentifier.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() {
        int numTries = 0;
        while (true) {
            try {
                if (numTries < 10) {
                    Thread.sleep(50L);
                } else {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                ManagerConnectionImpl e = this;
                synchronized (e) {
                    if (this.state != ManagerConnectionState.RECONNECTING) {
                        break;
                    }
                    this.connect();
                    try {
                        this.doLogin(this.defaultResponseTimeout, this.eventMask);
                        this.logger.info("Successfully reconnected.");
                        break;
                    }
                    catch (AuthenticationFailedException e1) {
                        if (this.keepAliveAfterAuthenticationFailure) {
                            this.logger.error("Unable to log in after reconnect: " + e1.getMessage());
                        } else {
                            this.logger.error("Unable to log in after reconnect: " + e1.getMessage() + ". Giving up.");
                            this.state = ManagerConnectionState.DISCONNECTED;
                        }
                    }
                    catch (TimeoutException e1) {
                        this.logger.error("TimeoutException while trying to log in after reconnect.");
                    }
                }
            }
            catch (IOException e) {
                String message = e.getClass().getSimpleName();
                if (e.getMessage() != null) {
                    message = e.getMessage();
                }
                this.logger.warn("Exception while trying to reconnect: " + message);
            }
            ++numTries;
        }
    }

    private void cleanup() {
        this.disconnect();
        this.readerThread = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ManagerConnection[");
        sb.append("id='").append(this.id).append("',");
        sb.append("hostname='").append(this.hostname).append("',");
        sb.append("port=").append(this.port).append(",");
        sb.append("systemHashcode=").append(System.identityHashCode(this)).append("]");
        return sb.toString();
    }

    @Override
    public void deregisterEventClass(Class<? extends ManagerEvent> eventClass) {
        if (this.reader == null) {
            this.reader = this.createReader(this, this);
        }
        this.reader.deregisterEventClass(eventClass);
    }

    private static class ResponseEventHandler
    implements ManagerEventListener,
    SendActionCallback {
        private final ResponseEventsImpl events;
        private final Class<?> actionCompleteEventClass;

        public ResponseEventHandler(ResponseEventsImpl events, Class<?> actionCompleteEventClass) {
            this.events = events;
            this.actionCompleteEventClass = actionCompleteEventClass;
        }

        @Override
        public void onManagerEvent(ManagerEvent event) {
            if (event instanceof ResponseEvent) {
                ResponseEvent responseEvent = (ResponseEvent)event;
                this.events.addEvent(responseEvent);
            }
            if (this.actionCompleteEventClass.isAssignableFrom(event.getClass())) {
                this.events.setComplete(true);
                if (this.events.getResponse() != null) {
                    this.events.countDown();
                }
            }
        }

        @Override
        public void onResponse(ManagerResponse response) {
            this.events.setRepsonse(response);
            if (response instanceof ManagerError) {
                this.events.setComplete(true);
            }
            if (this.events.isComplete()) {
                this.events.countDown();
            }
        }
    }

    private static class DefaultSendActionCallback
    implements SendActionCallback,
    Serializable {
        private static final long serialVersionUID = 2926598671855316803L;
        private final ResponseHandlerResult result;

        public DefaultSendActionCallback(ResponseHandlerResult result) {
            this.result = result;
        }

        @Override
        public void onResponse(ManagerResponse response) {
            this.result.setResponse(response);
            this.result.countDown();
        }
    }

    private static class ResponseHandlerResult
    implements Serializable {
        private static final long serialVersionUID = 7831097958568769220L;
        private ManagerResponse response;
        private final CountDownLatch latch = new CountDownLatch(1);

        public ManagerResponse getResponse() {
            return this.response;
        }

        public void setResponse(ManagerResponse response) {
            this.response = response;
        }

        private void countDown() {
            this.latch.countDown();
        }

        private void await(long millis) throws InterruptedException {
            this.latch.await(millis, TimeUnit.MILLISECONDS);
        }
    }
}

