/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.EventTimeoutException;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.actions.EventGeneratingAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.GetVarAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.ListCommandsAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.ManagerAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.SetVarAction;
import org.asteriskjava.pbx.asterisk.wrap.events.ConnectEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.DisconnectEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ResponseEvents;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse;
import org.asteriskjava.pbx.internal.core.CoherentEventFactory;
import org.asteriskjava.pbx.internal.core.CoherentManagerEventQueue;
import org.asteriskjava.pbx.internal.core.FilteredManagerListener;
import org.asteriskjava.pbx.internal.managerAPI.Connector;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class CoherentManagerConnection
implements FilteredManagerListener<ManagerEvent> {
    private static Log logger = LogFactory.getLog(CoherentManagerConnection.class);
    static Map<String, Integer> eventStatistics = new HashMap<String, Integer>();
    static Connector connector = null;
    static ManagerConnection managerConnection = null;
    private CoherentManagerEventQueue eventQueue;
    private CoherentManagerEventQueue realtimeEventQueue;
    private boolean canBridge;
    private boolean canMuteAudio;
    private static CoherentManagerConnection self = null;
    private CountDownLatch _reconnectLatch = new CountDownLatch(0);

    public static synchronized void init() throws IllegalStateException, IOException, AuthenticationFailedException, TimeoutException, InterruptedException {
        if (self != null) {
            logger.warn("The CoherentManagerConnection has already been initialised");
        } else {
            self = new CoherentManagerConnection();
            boolean done = false;
            while (!done) {
                try {
                    self.checkConnection();
                    self.checkFeatures();
                    done = true;
                }
                catch (Exception e) {
                    logger.error(e, e);
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
            }
        }
        self.checkConnection();
    }

    public static void reset() {
        self = null;
    }

    public static synchronized CoherentManagerConnection getInstance() {
        if (self == null) {
            throw new IllegalStateException("The CoherentManagerConnection has not been initialised");
        }
        self.checkConnection();
        return self;
    }

    private CoherentManagerConnection() throws IllegalStateException, IOException, AuthenticationFailedException, TimeoutException {
        connector = new Connector();
        this.configureConnection();
    }

    public AsteriskVersion getVersion() throws IllegalStateException {
        return managerConnection.getVersion();
    }

    public void setVariable(Channel channel, String variableName, String value) throws PBXException {
        try {
            SetVarAction setVariable = new SetVarAction(channel, variableName, value);
            PBX pbx = PBXFactory.getActivePBX();
            if (!pbx.waitForChannelToQuiescent(channel, 3000)) {
                throw new PBXException("Channel: " + channel + " cannot be retrieved as it is still in transition.");
            }
            ManagerResponse response = CoherentManagerConnection.sendAction(setVariable, 500);
            if (response == null || response.getResponse().compareToIgnoreCase("success") != 0) {
                throw new PBXException("failed to set variable '" + variableName + "' on channel " + channel + " to '" + value + "'" + (response != null ? " Error:" + response.getMessage() : ""));
            }
            logger.debug("set variable " + variableName + " to " + value + " on " + channel);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | TimeoutException e) {
            logger.error(e, e);
            throw new PBXException(e);
        }
    }

    public String getVariable(Channel channel, String variableName) {
        String value = "";
        GetVarAction var = new GetVarAction(channel, variableName);
        try {
            PBX pbx = PBXFactory.getActivePBX();
            if (!pbx.waitForChannelToQuiescent(channel, 3000)) {
                throw new PBXException("Channel: " + channel + " cannot be retrieved as it is still in transition.");
            }
            ManagerResponse convertedResponse = CoherentManagerConnection.sendAction(var, 500);
            if (convertedResponse != null) {
                value = convertedResponse.getAttribute("value");
                if (value == null) {
                    value = "";
                }
                logger.debug("getVarAction returned name:" + variableName + " value:" + value);
            }
        }
        catch (Exception e) {
            logger.debug(e, e);
            logger.error("getVariable: " + e);
        }
        return value;
    }

    public static void sendActionNoWait(final ManagerAction action) {
        Thread background = new Thread(){

            @Override
            public void run() {
                try {
                    CoherentManagerConnection.sendAction(action, 5000);
                }
                catch (Exception e) {
                    logger.error(e, e);
                }
            }
        };
        background.setName("sendActionNoWait");
        background.setDaemon(true);
        background.start();
    }

    public static ResponseEvents sendEventGeneratingAction(EventGeneratingAction action) throws EventTimeoutException, IllegalArgumentException, IllegalStateException, IOException {
        org.asteriskjava.manager.ResponseEvents events = managerConnection.sendEventGeneratingAction(action.getAJEventGeneratingAction());
        ResponseEvents convertedEvents = new ResponseEvents();
        for (ResponseEvent event : events.getEvents()) {
            convertedEvents.add(CoherentEventFactory.build(event));
        }
        return convertedEvents;
    }

    public static ResponseEvents sendEventGeneratingAction(EventGeneratingAction action, int timeout) throws EventTimeoutException, IllegalArgumentException, IllegalStateException, IOException {
        org.asteriskjava.manager.ResponseEvents events = managerConnection.sendEventGeneratingAction(action.getAJEventGeneratingAction(), timeout);
        ResponseEvents convertedEvents = new ResponseEvents();
        for (ResponseEvent event : events.getEvents()) {
            convertedEvents.add(CoherentEventFactory.build(event));
        }
        return convertedEvents;
    }

    public static ManagerResponse sendAction(ManagerAction action, int timeout) throws IllegalArgumentException, IllegalStateException, IOException, TimeoutException {
        if (logger.isDebugEnabled()) {
            logger.debug("Sending Action: " + action.toString());
        }
        CoherentManagerConnection.getInstance();
        if (managerConnection != null && managerConnection.getState() == ManagerConnectionState.CONNECTED) {
            org.asteriskjava.manager.action.ManagerAction ajAction = action.getAJAction();
            org.asteriskjava.manager.response.ManagerResponse response = managerConnection.sendAction(ajAction, timeout);
            ManagerResponse convertedResponse = null;
            if (response != null) {
                convertedResponse = CoherentEventFactory.build(response);
            }
            if (convertedResponse != null && convertedResponse.getResponse().compareToIgnoreCase("Error") == 0) {
                logger.warn("Action '" + ajAction + "' failed, Response: " + convertedResponse.getResponse() + " Message: " + convertedResponse.getMessage());
            }
            return convertedResponse;
        }
        throw new IllegalStateException("not connected.");
    }

    private void checkConnection() {
        this._reconnectLatch = new CountDownLatch(1);
        for (int trys = 3; trys > 0 && (managerConnection == null || managerConnection.getState() != ManagerConnectionState.CONNECTED); --trys) {
            if (trys == 3) {
                logger.warn("Awaiting Manager connection");
            }
            try {
                this._reconnectLatch.await(300L, TimeUnit.MILLISECONDS);
                continue;
            }
            catch (InterruptedException e) {
                logger.error(e, e);
            }
        }
    }

    public ManagerConnectionState getState() {
        return managerConnection.getState();
    }

    private void configureConnection() throws IOException, AuthenticationFailedException, TimeoutException, IllegalStateException {
        AsteriskSettings profile = PBXFactory.getActiveProfile();
        managerConnection = connector.connect(profile);
        CoherentManagerEventQueue newRealtime = new CoherentManagerEventQueue("Realtime");
        if (this.realtimeEventQueue != null) {
            this.realtimeEventQueue.stop();
            newRealtime.transferListeners(this.realtimeEventQueue);
        }
        this.realtimeEventQueue = newRealtime;
        CoherentManagerEventQueue newStandard = new CoherentManagerEventQueue("Standard");
        if (this.eventQueue != null) {
            this.eventQueue.stop();
            newStandard.transferListeners(this.eventQueue);
        }
        this.eventQueue = newStandard;
    }

    private void checkFeatures() throws IOException, TimeoutException {
        AsteriskSettings profile = PBXFactory.getActiveProfile();
        ListCommandsAction lca = new ListCommandsAction();
        ManagerResponse convertedResponse = CoherentManagerConnection.sendAction(lca, 500);
        boolean bridgeFound = false;
        boolean muteAudioFound = false;
        for (String command : convertedResponse.getAttributes().keySet()) {
            if (command.toLowerCase().contains("bridge")) {
                bridgeFound = true;
            }
            if (!command.toLowerCase().contains("muteaudio")) continue;
            muteAudioFound = true;
        }
        this.canMuteAudio = muteAudioFound;
        this.canBridge = profile.getDisableBridge() ? false : bridgeFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() {
        ManagerConnection oldConnection = managerConnection;
        try {
            try {
                InetAddress address = InetAddress.getByName(managerConnection.getHostname());
                int counter = 0;
                while (!address.isReachable(100)) {
                    if (counter % 10 == 0) {
                        logger.debug("Testing for host " + managerConnection.getHostname());
                    }
                    ++counter;
                }
            }
            catch (Exception e2) {
                logger.error(e2, e2);
            }
            try {
                logger.debug("reconnecting to asterisk");
                connector = new Connector();
                this.configureConnection();
                logger.debug("asterisk reconnection complete");
            }
            catch (Exception e1) {
                logger.error(e1, e1);
            }
        }
        finally {
            oldConnection.logoff();
        }
    }

    public void shutDown() {
        managerConnection.removeEventListener(this.eventQueue);
        this.eventQueue.stop();
        try {
            managerConnection.logoff();
        }
        catch (Exception e) {
            logger.debug("Manager logging off");
            logger.debug(e, e);
        }
    }

    public boolean isBridgeSupported() {
        return this.canBridge;
    }

    public boolean isMuteAudioSupported() {
        return this.canMuteAudio;
    }

    public void removeListener(FilteredManagerListener<ManagerEvent> listener) {
        if (listener.getPriority() == ListenerPriority.REALTIME) {
            this.realtimeEventQueue.removeListener(listener);
        } else {
            this.eventQueue.removeListener(listener);
        }
    }

    public void addListener(FilteredManagerListener<ManagerEvent> listener) {
        if (listener.getPriority() == ListenerPriority.REALTIME) {
            this.realtimeEventQueue.addListener(listener);
        } else {
            this.eventQueue.addListener(listener);
        }
    }

    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        required.add(ConnectEvent.class);
        required.add(DisconnectEvent.class);
        return required;
    }

    @Override
    public String getName() {
        return "CoherentManagerConnection";
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.REALTIME;
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
        if (event instanceof ConnectEvent) {
            logger.warn("****************** Asterisk manager connection acquired **************************");
            this._reconnectLatch.countDown();
        } else if (event instanceof DisconnectEvent) {
            logger.warn("****************** Asterisk manager connection lost **************************");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    CoherentManagerConnection.this.reconnect();
                }
            });
        }
    }
}

