/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.examples.activities;

import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.ActivityStatusEnum;
import org.asteriskjava.pbx.Call;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.TechType;
import org.asteriskjava.pbx.Trunk;
import org.asteriskjava.pbx.activities.DialActivity;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class Dial {
    private static Log logger = LogFactory.getLog(Dial.class);

    public static void main(String[] args) {
        Dial.syncDial();
        Dial.asyncDial();
    }

    private static void syncDial() {
        try {
            PBX pbx = PBXFactory.getActivePBX();
            Trunk trunk = pbx.buildTrunk("default");
            EndPoint from = pbx.buildEndPoint(TechType.SIP, "100");
            CallerID fromCallerID = pbx.buildCallerID("100", "My Phone");
            CallerID toCallerID = pbx.buildCallerID("83208100", "Asterisk Java is calling");
            EndPoint to = pbx.buildEndPoint(TechType.SIP, trunk, "5551234");
            DialActivity dial = pbx.dial(from, fromCallerID, to, toCallerID);
            Call call = dial.getNewCall();
            Thread.sleep(20000L);
            logger.warn("Hanging up");
            pbx.hangup(call);
        }
        catch (InterruptedException | PBXException e) {
            System.out.println(e);
        }
    }

    private static void asyncDial() {
        PBX pbx = PBXFactory.getActivePBX();
        EndPoint from = pbx.buildEndPoint(TechType.SIP, "100");
        CallerID fromCallerID = pbx.buildCallerID("100", "My Phone");
        CallerID toCallerID = pbx.buildCallerID("83208100", "Asterisk Java is calling");
        EndPoint to = pbx.buildEndPoint(TechType.SIP, pbx.buildTrunk("default"), "5551234");
        pbx.dial(from, fromCallerID, to, toCallerID, new ActivityCallback<DialActivity>(){

            @Override
            public void progress(DialActivity activity, ActivityStatusEnum status, String message) {
                if (status == ActivityStatusEnum.SUCCESS) {
                    System.out.println("Dial all good");
                    try {
                        Call call = activity.getNewCall();
                        logger.warn("Hanging up");
                        PBXFactory.getActivePBX().hangup(call.getOriginatingParty());
                    }
                    catch (PBXException e) {
                        System.out.println(e);
                    }
                }
                if (status == ActivityStatusEnum.FAILURE) {
                    System.out.println("Oops something bad happened when we dialed.");
                }
            }
        });
    }
}

