/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.asteriskjava.pbx.asterisk.wrap.events.BridgeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.LinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.UnlinkEvent;
import org.asteriskjava.pbx.internal.core.CoherentEventFactory;
import org.asteriskjava.pbx.internal.core.FilteredManagerListener;

public class FilteredManagerListenerWrapper {
    FilteredManagerListener<ManagerEvent> _listener;
    Set<Class<? extends ManagerEvent>> requiredEvents;
    private static final AtomicInteger seed = new AtomicInteger();
    Integer equalityBuster = seed.incrementAndGet();

    public FilteredManagerListenerWrapper(FilteredManagerListener<ManagerEvent> listener) {
        this._listener = listener;
        this.requiredEvents = listener.requiredEvents();
        if (this.requiredEvents.contains(BridgeEvent.class)) {
            this.requiredEvents.add(LinkEvent.class);
            this.requiredEvents.add(UnlinkEvent.class);
        }
        for (Class<? extends ManagerEvent> event : this.requiredEvents) {
            if (CoherentEventFactory.mapEvents.values().contains(event) || CoherentEventFactory.mapResponses.values().contains(event)) continue;
            throw new RuntimeException("The requested event type of " + event + "+isn't known by " + CoherentEventFactory.class);
        }
    }

    public String toString() {
        return this._listener.getName();
    }
}

