/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.alignment;

import java.util.List;
import org.biojava.nbio.core.alignment.SimpleProfile;
import org.biojava.nbio.core.alignment.template.AlignedSequence;
import org.biojava.nbio.core.alignment.template.SequencePair;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;

public class SimpleSequencePair<S extends Sequence<C>, C extends Compound>
extends SimpleProfile<S, C>
implements SequencePair<S, C> {
    private static final long serialVersionUID = 1L;
    private int identicals = -1;
    private int similars = -1;

    public SimpleSequencePair(AlignedSequence<S, C> query, AlignedSequence<S, C> target) {
        super(query, target);
    }

    public SimpleSequencePair(S query, S target, List<AlignedSequence.Step> sx, List<AlignedSequence.Step> sy) {
        this(query, target, sx, 0, 0, sy, 0, 0);
    }

    public SimpleSequencePair(S query, S target, List<AlignedSequence.Step> sx, int xb, int xa, List<AlignedSequence.Step> sy, int yb, int ya) {
        super(query, target, sx, xb, xa, sy, yb, ya);
    }

    @Override
    public C getCompoundInQueryAt(int alignmentIndex) {
        return this.getAlignedSequence(true).getCompoundAt(alignmentIndex);
    }

    @Override
    public C getCompoundInTargetAt(int alignmentIndex) {
        return this.getAlignedSequence(2).getCompoundAt(alignmentIndex);
    }

    @Override
    public int getIndexInQueryAt(int alignmentIndex) {
        return this.getAlignedSequence(true).getSequenceIndexAt(alignmentIndex);
    }

    @Override
    public int getIndexInQueryForTargetAt(int targetIndex) {
        return this.getAlignedSequence(true).getSequenceIndexAt(this.getAlignedSequence(2).getAlignmentIndexAt(targetIndex));
    }

    @Override
    public int getIndexInTargetAt(int alignmentIndex) {
        return this.getAlignedSequence(2).getSequenceIndexAt(alignmentIndex);
    }

    @Override
    public int getIndexInTargetForQueryAt(int queryIndex) {
        return this.getAlignedSequence(2).getSequenceIndexAt(this.getAlignedSequence(true).getAlignmentIndexAt(queryIndex));
    }

    @Override
    public int getNumIdenticals() {
        if (this.identicals == -1) {
            this.identicals = 0;
            for (int i = 1; i <= this.getLength(); ++i) {
                if (!this.getCompoundInQueryAt(i).equalsIgnoreCase((Compound)this.getCompoundInTargetAt(i))) continue;
                ++this.identicals;
            }
            this.getQuery().clearCache();
            this.getTarget().clearCache();
        }
        return this.identicals;
    }

    @Override
    public int getNumSimilars() {
        if (this.similars == -1) {
            this.similars = 0;
            for (int i = 1; i <= this.getLength(); ++i) {
                C c1 = this.getCompoundInQueryAt(i);
                C c2 = this.getCompoundInTargetAt(i);
                if (c1 instanceof AminoAcidCompound && c2 instanceof AminoAcidCompound) {
                    short value = matrix.getValue((AminoAcidCompound)c1, (AminoAcidCompound)c2);
                    if (value <= 0) continue;
                    ++this.similars;
                    continue;
                }
                if (!this.getCompoundSet().compoundsEquivalent(c1, c2)) continue;
                ++this.similars;
            }
            this.getQuery().clearCache();
            this.getTarget().clearCache();
        }
        return this.similars;
    }

    @Override
    public AlignedSequence<S, C> getQuery() {
        return this.getAlignedSequence(true);
    }

    @Override
    public AlignedSequence<S, C> getTarget() {
        return this.getAlignedSequence(2);
    }
}

