/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.cif;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.cif.CifFileConsumerImpl;
import org.biojava.nbio.structure.io.cif.CifFileSupplierImpl;
import org.rcsb.cif.CifIO;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.CifFile;

public class CifFileConverter {
    public static Structure fromPath(Path path) throws IOException {
        return CifFileConverter.fromInputStream(Files.newInputStream(path, new OpenOption[0]), new FileParsingParameters());
    }

    public static Structure fromPath(Path path, FileParsingParameters parameters) throws IOException {
        return CifFileConverter.fromInputStream(Files.newInputStream(path, new OpenOption[0]), parameters);
    }

    public static Structure fromURL(URL url) throws IOException {
        return CifFileConverter.fromURL(url, new FileParsingParameters());
    }

    private static Structure fromURL(URL url, FileParsingParameters parameters) throws IOException {
        return CifFileConverter.fromInputStream(url.openStream(), parameters);
    }

    public static Structure fromInputStream(InputStream inputStream) throws IOException {
        return CifFileConverter.fromInputStream(inputStream, new FileParsingParameters());
    }

    public static Structure fromInputStream(InputStream inputStream, FileParsingParameters parameters) throws IOException {
        return CifFileConverter.fromCifFile(CifIO.readFromInputStream((InputStream)inputStream), parameters);
    }

    public static Structure fromCifFile(CifFile cifFile) {
        return CifFileConverter.fromCifFile(cifFile, new FileParsingParameters());
    }

    public static Structure fromCifFile(CifFile cifFile, FileParsingParameters parameters) {
        CifFileConsumerImpl consumer = new CifFileConsumerImpl(parameters);
        consumer.prepare();
        Block cifBlock = cifFile.getFirstBlock();
        consumer.consumeAuditAuthor(cifBlock.getAuditAuthor());
        consumer.consumeAtomSite(cifBlock.getAtomSite());
        consumer.consumeAtomSites(cifBlock.getAtomSites());
        consumer.consumeCell(cifBlock.getCell());
        consumer.consumeChemComp(cifBlock.getChemComp());
        consumer.consumeChemCompBond(cifBlock.getChemCompBond());
        consumer.consumeDatabasePDBremark(cifBlock.getDatabasePDBRemark());
        consumer.consumeDatabasePDBrev(cifBlock.getDatabasePDBRev());
        consumer.consumeDatabasePDBrevRecord(cifBlock.getDatabasePDBRevRecord());
        consumer.consumeEntity(cifBlock.getEntity());
        consumer.consumeEntityPoly(cifBlock.getEntityPoly());
        consumer.consumeEntitySrcGen(cifBlock.getEntitySrcGen());
        consumer.consumeEntitySrcNat(cifBlock.getEntitySrcNat());
        consumer.consumeEntitySrcSyn(cifBlock.getPdbxEntitySrcSyn());
        consumer.consumeEntityPolySeq(cifBlock.getEntityPolySeq());
        consumer.consumeExptl(cifBlock.getExptl());
        consumer.consumePdbxAuditRevisionHistory(cifBlock.getPdbxAuditRevisionHistory());
        consumer.consumePdbxChemCompIdentifier(cifBlock.getPdbxChemCompIdentifier());
        consumer.consumePdbxDatabaseStatus(cifBlock.getPdbxDatabaseStatus());
        consumer.consumePdbxEntityDescriptor(cifBlock.getPdbxEntityDescriptor());
        consumer.consumePdbxMolecule(cifBlock.getPdbxMolecule());
        consumer.consumePdbxMoleculeFeatures(cifBlock.getPdbxMoleculeFeatures());
        consumer.consumePdbxNonpolyScheme(cifBlock.getPdbxNonpolyScheme());
        consumer.consumePdbxReferenceEntityLink(cifBlock.getPdbxReferenceEntityLink());
        consumer.consumePdbxReferenceEntityList(cifBlock.getPdbxReferenceEntityList());
        consumer.consumePdbxReferenceEntityPolyLink(cifBlock.getPdbxReferenceEntityPolyLink());
        consumer.consumePdbxStructAssembly(cifBlock.getPdbxStructAssembly());
        consumer.consumePdbxStructAssemblyGen(cifBlock.getPdbxStructAssemblyGen());
        consumer.consumePdbxStructModResidue(cifBlock.getPdbxStructModResidue());
        consumer.consumePdbxStructOperList(cifBlock.getPdbxStructOperList());
        consumer.consumeRefine(cifBlock.getRefine());
        consumer.consumeStruct(cifBlock.getStruct());
        consumer.consumeStructAsym(cifBlock.getStructAsym());
        consumer.consumeStructConf(cifBlock.getStructConf());
        consumer.consumeStructConn(cifBlock.getStructConn());
        consumer.consumeStructConnType(cifBlock.getStructConnType());
        consumer.consumeStructKeywords(cifBlock.getStructKeywords());
        consumer.consumeStructNcsOper(cifBlock.getStructNcsOper());
        consumer.consumeStructRef(cifBlock.getStructRef());
        consumer.consumeStructRefSeq(cifBlock.getStructRefSeq());
        consumer.consumeStructRefSeqDif(cifBlock.getStructRefSeqDif());
        consumer.consumeStructSheetRange(cifBlock.getStructSheetRange());
        consumer.consumeStructSite(cifBlock.getStructSite());
        consumer.consumeStructSiteGen(cifBlock.getStructSiteGen());
        consumer.consumeSymmetry(cifBlock.getSymmetry());
        consumer.finish();
        return (Structure)consumer.getContainer();
    }

    public static void toTextFile(Structure structure, Path path) throws IOException {
        CifIO.writeText((CifFile)CifFileConverter.toCifFile(structure), (Path)path);
    }

    public static void toBinaryFile(Structure structure, Path path) throws IOException {
        CifIO.writeBinary((CifFile)CifFileConverter.toCifFile(structure), (Path)path);
    }

    public static byte[] toBinary(Structure structure) throws IOException {
        return CifIO.writeText((CifFile)CifFileConverter.toCifFile(structure));
    }

    public static String toText(Structure structure) throws IOException {
        return new String(CifIO.writeText((CifFile)CifFileConverter.toCifFile(structure)));
    }

    public static CifFile toCifFile(Structure structure) {
        return new CifFileSupplierImpl().get(structure);
    }
}

