/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.Calc;

public class BondImpl
implements Bond {
    private static final long serialVersionUID = 8836120946858134380L;
    private Atom atomA;
    private Atom atomB;
    private int bondOrder;

    public BondImpl(Atom atomA, Atom atomB, int bondOrder) {
        this(atomA, atomB, bondOrder, true);
    }

    public BondImpl(Atom atomA, Atom atomB, int bondOrder, boolean addSelfToAtoms) {
        this.atomA = atomA;
        this.atomB = atomB;
        this.bondOrder = bondOrder;
        if (addSelfToAtoms) {
            this.addSelfToAtoms();
        }
    }

    private void addSelfToAtoms() {
        List<Bond> bonds = this.atomA.getBonds();
        if (bonds == null) {
            bonds = new ArrayList<Bond>(3);
            this.atomA.setBonds(bonds);
        }
        boolean exists = false;
        for (Bond bond : bonds) {
            if (!bond.getOther(this.atomA).equals(this.atomB)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.atomA.addBond(this);
            this.atomB.addBond(this);
        }
    }

    @Override
    public Atom getAtomA() {
        return this.atomA;
    }

    @Override
    public Atom getAtomB() {
        return this.atomB;
    }

    @Override
    public Atom getOther(Atom exclude) {
        if (exclude != this.atomA && exclude != this.atomB) {
            throw new IllegalArgumentException("Atom to exclude is not in bond.");
        }
        if (exclude == this.atomA) {
            return this.atomB;
        }
        return this.atomA;
    }

    @Override
    public int getBondOrder() {
        return this.bondOrder;
    }

    @Override
    public double getLength() {
        return Calc.getDistance(this.atomA, this.atomB);
    }

    public String toString() {
        return "Bond [atomA=" + String.valueOf(this.atomA) + ", atomB=" + String.valueOf(this.atomB) + ", bondOrder=" + this.bondOrder + "]";
    }
}

