/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="UnusedVariable", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnusedVariableCheck
extends SquidCheck<LexerlessGrammar> {
    private Scope currentScope;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN, EcmaScriptGrammar.PRIMARY_EXPRESSION, EcmaScriptGrammar.FORMAL_PARAMETER_LIST});
    }

    public void visitFile(AstNode astNode) {
        this.currentScope = null;
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            this.currentScope = new Scope(this.currentScope);
        } else if (this.currentScope != null && astNode.is(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST})) {
            this.declareInCurrentScope(CheckUtils.getParametersIdentifier(astNode), 1);
        } else if (this.currentScope != null) {
            AstNode identifier;
            if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN})) {
                this.declareInCurrentScope(CheckUtils.getVariableIdentifiers(astNode), 0);
            } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.PRIMARY_EXPRESSION}) && (identifier = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER})) != null) {
                this.currentScope.use(identifier);
            }
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            for (Map.Entry entry : this.currentScope.variables.entrySet()) {
                if (((Variable)entry.getValue()).usages != 0) continue;
                this.getContext().createLineViolation((CodeCheck)this, "Remove the declaration of the unused '" + (String)entry.getKey() + "' variable.", ((Variable)entry.getValue()).declaration, new Object[0]);
            }
            this.currentScope = this.currentScope.outerScope;
        }
    }

    public void leaveFile(AstNode astNode) {
        this.currentScope = null;
    }

    private void declareInCurrentScope(List<AstNode> identifiers, int usage) {
        for (AstNode identifier : identifiers) {
            this.currentScope.declare(identifier, usage);
        }
    }

    private static class Scope {
        private final Scope outerScope;
        private final Map<String, Variable> variables;

        public Scope(Scope outerScope) {
            this.outerScope = outerScope;
            this.variables = Maps.newHashMap();
        }

        private void declare(AstNode astNode, int usages) {
            Preconditions.checkState((boolean)astNode.is(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
            String identifier = astNode.getTokenValue();
            if (!this.variables.containsKey(identifier)) {
                this.variables.put(identifier, new Variable(astNode, usages));
            }
        }

        private void use(AstNode astNode) {
            Preconditions.checkState((boolean)astNode.is(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
            String identifier = astNode.getTokenValue();
            Scope scope = this;
            while (scope != null) {
                Variable var = scope.variables.get(identifier);
                if (var != null) {
                    ++var.usages;
                    return;
                }
                scope = scope.outerScope;
            }
            this.variables.put(identifier, new Variable(astNode, 1));
        }
    }

    private static class Variable {
        final AstNode declaration;
        int usages;

        public Variable(AstNode declaration, int usages) {
            this.declaration = declaration;
            this.usages = usages;
        }
    }
}

