/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.LabelledStatementTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1219", priority=Priority.CRITICAL, tags={"misra", "pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class NonCaseLabelInSwitchCheck
extends SquidCheck<LexerlessGrammar> {
    private boolean inCase;

    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.CASE_CLAUSE, Tree.Kind.LABELLED_STATEMENT});
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.inCase = false;
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{Tree.Kind.CASE_CLAUSE})) {
            this.inCase = true;
        } else if (this.inCase && astNode.is(new AstNodeType[]{Tree.Kind.LABELLED_STATEMENT})) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this misleading \"{0}\" label.", astNode, new Object[]{((LabelledStatementTree)astNode).label().name()});
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{Tree.Kind.CASE_CLAUSE})) {
            this.inCase = false;
        }
    }
}

