/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="SingleQuote", priority=Priority.MAJOR, tags={"convention"})
public class SingleQuoteStringLiteralsCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.STRING_LITERAL});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.getTokenValue().charAt(0) != '\'') {
            this.getContext().createLineViolation((CodeCheck)this, "Replace double quotes by simple quote", astNode, new Object[0]);
        }
    }
}

